/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hemp.broker;

import com.caucho.config.ConfigException;
import com.caucho.hemp.broker.HempMemoryQueue;
import com.caucho.hmtp.AbstractHmtpAgentStream;
import com.caucho.hmtp.HmtpAgentStream;
import com.caucho.hmtp.HmtpConnection;
import com.caucho.hmtp.HmtpStream;
import com.caucho.hmtp.disco.DiscoFeature;
import com.caucho.hmtp.disco.DiscoIdentity;
import com.caucho.hmtp.disco.DiscoInfoQuery;
import com.caucho.hmtp.spi.HmtpBroker;
import com.caucho.hmtp.spi.HmtpService;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.webbeans.In;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GenericService
extends AbstractHmtpAgentStream
implements HmtpService {
    private static final L10N L = new L10N(GenericService.class);
    private static final Logger log = Logger.getLogger(GenericService.class.getName());
    @In
    private HmtpBroker _broker;
    private String _jid;
    private HmtpConnection _conn;
    private HmtpStream _brokerStream;
    private HmtpAgentStream _agentStream;

    public void setName(String name) {
        this.setJid(name);
    }

    public void setJid(String jid) {
        this._jid = jid;
    }

    @Override
    public String getJid() {
        return this._jid;
    }

    public void setBroker(HmtpBroker broker) {
        this._broker = broker;
    }

    protected HmtpBroker getBroker() {
        return this._broker;
    }

    protected HmtpConnection getConnection() {
        return this._conn;
    }

    public HmtpStream getBrokerStream() {
        return this._brokerStream;
    }

    @PostConstruct
    public void init() {
        if (this.getJid() == null) {
            throw new ConfigException(L.l("{0} requires a jid", (Object)this.getClass().getSimpleName()));
        }
        this._agentStream = this.createQueue(this);
        this._broker.addService(this);
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " init");
        }
        this._brokerStream = this._broker.getBrokerStream();
    }

    protected HmtpAgentStream createQueue(HmtpAgentStream stream) {
        return new HempMemoryQueue(stream, this._broker.getBrokerStream());
    }

    @Override
    public HmtpAgentStream getAgentStream() {
        return this._agentStream;
    }

    @Override
    public HmtpAgentStream getAgentFilter(HmtpAgentStream agentStream) {
        return agentStream;
    }

    @Override
    public HmtpStream getBrokerFilter(HmtpStream brokerStream) {
        return brokerStream;
    }

    @Override
    public void onAgentStart(String jid) {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " onAgentStart(" + jid + ")");
        }
    }

    @Override
    public void onAgentStop(String jid) {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " onAgentStop(" + jid + ")");
        }
    }

    @Override
    public HmtpAgentStream findAgent(String jid) {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " findAgent(" + jid + ")");
        }
        return null;
    }

    @Override
    public boolean sendQueryGet(long id, String to, String from, Serializable value) {
        if (value instanceof DiscoInfoQuery) {
            this._brokerStream.sendQueryResult(id, from, to, new DiscoInfoQuery(this.getDiscoIdentity(), this.getDiscoFeatures()));
            return true;
        }
        Serializable result = this.doQueryGet(to, from, value);
        if (result != null) {
            this._brokerStream.sendQueryResult(id, from, to, result);
            return true;
        }
        return false;
    }

    protected Serializable doQueryGet(String to, String from, Serializable value) {
        return null;
    }

    protected Serializable doQuerySet(String to, String from, Serializable value) {
        return null;
    }

    protected DiscoIdentity[] getDiscoIdentity() {
        return new DiscoIdentity[]{new DiscoIdentity(this.getDiscoCategory(), this.getDiscoType())};
    }

    protected DiscoFeature[] getDiscoFeatures() {
        ArrayList<String> featureNames = new ArrayList<String>();
        this.getDiscoFeatureNames(featureNames);
        DiscoFeature[] features = new DiscoFeature[featureNames.size()];
        for (int i = 0; i < featureNames.size(); ++i) {
            features[i] = new DiscoFeature(featureNames.get(i));
        }
        return features;
    }

    protected String getDiscoCategory() {
        return "x-application";
    }

    protected String getDiscoType() {
        return this.getClass().getSimpleName();
    }

    protected void getDiscoFeatureNames(ArrayList<String> featureNames) {
        featureNames.add("http://jabber.org/protocol/disco#info");
    }

    @PreDestroy
    protected void destroy() {
        HmtpConnection conn = this._conn;
        this._conn = null;
        if (conn != null) {
            conn.close();
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " destroy");
        }
    }
}

