/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hemp.broker;

import com.caucho.hemp.broker.HempConnectionAgentStream;
import com.caucho.hemp.broker.HempConnectionImpl;
import com.caucho.hmtp.HmtpAgentStream;
import com.caucho.hmtp.HmtpConnection;
import com.caucho.hmtp.HmtpError;
import com.caucho.hmtp.HmtpStream;
import com.caucho.hmtp.spi.HmtpBroker;
import com.caucho.hmtp.spi.HmtpService;
import com.caucho.hmtp.spi.HmtpServiceManager;
import com.caucho.server.resin.Resin;
import com.caucho.util.Base64;
import com.caucho.util.L10N;
import com.caucho.util.RandomUtil;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HempBroker
implements HmtpBroker,
HmtpStream {
    private static final Logger log = Logger.getLogger(HempBroker.class.getName());
    private static final L10N L = new L10N(HempBroker.class);
    private final HashMap<String, WeakReference<HmtpAgentStream>> _agentMap = new HashMap();
    private final HashMap<String, HmtpService> _serviceMap = new HashMap();
    private final HashMap<String, WeakReference<HmtpService>> _serviceCache = new HashMap();
    private String _serverId = Resin.getCurrent().getServerId();
    private String _domain = "localhost";
    private String _managerJid = "localhost";
    private HmtpServiceManager[] _serviceManagerList = new HmtpServiceManager[0];

    public HmtpStream getBrokerStream() {
        return this;
    }

    public void addServiceManager(HmtpServiceManager serviceManager) {
        HmtpServiceManager[] serviceManagerList = new HmtpServiceManager[this._serviceManagerList.length + 1];
        System.arraycopy(this._serviceManagerList, 0, serviceManagerList, 0, this._serviceManagerList.length);
        serviceManagerList[serviceManagerList.length - 1] = serviceManager;
        this._serviceManagerList = serviceManagerList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HmtpConnection getConnection(String uid, String password) {
        String owner;
        HmtpService resource;
        int p;
        String jid = this.generateJid(uid);
        HempConnectionImpl conn = new HempConnectionImpl(this, jid);
        HempConnectionAgentStream agentStream = conn.getAgentStreamHandler();
        HashMap<String, WeakReference<HmtpAgentStream>> hashMap = this._agentMap;
        synchronized (hashMap) {
            this._agentMap.put(jid, new WeakReference<HempConnectionAgentStream>(agentStream));
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(conn + " created");
        }
        if ((p = jid.indexOf(47)) > 0 && (resource = this.findService(owner = jid.substring(0, p))) != null) {
            resource.onAgentStart(jid);
        }
        return conn;
    }

    protected String generateJid(String uid) {
        StringBuilder sb = new StringBuilder();
        sb.append(uid);
        sb.append("/");
        sb.append(this._serverId);
        sb.append(":");
        Base64.encode((StringBuilder)sb, (long)RandomUtil.getRandomLong());
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addService(HmtpService service) {
        String jid = service.getJid();
        HashMap<String, Object> hashMap = this._serviceMap;
        synchronized (hashMap) {
            HmtpService oldService = this._serviceMap.get(jid);
            if (oldService != null) {
                throw new IllegalStateException(L.l("duplicated jid='{0}' is not allowed", (Object)jid));
            }
            this._serviceMap.put(jid, service);
            this._serviceCache.put(jid, new WeakReference<HmtpService>(service));
        }
        hashMap = this._agentMap;
        synchronized (hashMap) {
            WeakReference<HmtpAgentStream> oldRef = this._agentMap.get(jid);
            if (oldRef != null && oldRef.get() != null) {
                throw new IllegalStateException(L.l("duplicated jid='{0}' is not allowed", (Object)jid));
            }
            HmtpAgentStream agentStream = service.getAgentStream();
            this._agentMap.put(jid, new WeakReference<HmtpAgentStream>(agentStream));
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " addService jid=" + jid + " " + service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeService(HmtpService service) {
        String jid = service.getJid();
        HashMap<String, Object> hashMap = this._serviceMap;
        synchronized (hashMap) {
            this._serviceMap.remove(jid);
        }
        hashMap = this._serviceCache;
        synchronized (hashMap) {
            this._serviceCache.remove(jid);
        }
        hashMap = this._agentMap;
        synchronized (hashMap) {
            this._agentMap.remove(jid);
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " removeService jid=" + jid + " " + service);
        }
    }

    protected String getManagerJid() {
        return this._managerJid;
    }

    protected String getDomain() {
        return this._domain;
    }

    public void sendPresence(String to, String from, Serializable[] data) {
        HmtpAgentStream stream = this.findAgent(to);
        if (stream != null) {
            stream.sendPresence(to, from, data);
        } else if (log.isLoggable(Level.FINER)) {
            log.finer(this + " sendPresence (no resource) to=" + to + " from=" + from);
        }
    }

    public void sendPresenceUnavailable(String to, String from, Serializable[] data) {
        HmtpAgentStream stream = this.findAgent(to);
        if (stream != null) {
            stream.sendPresenceUnavailable(to, from, data);
        }
    }

    public void sendPresenceProbe(String to, String from, Serializable[] data) {
        HmtpAgentStream stream = this.findAgent(to);
        if (stream != null) {
            stream.sendPresenceProbe(to, from, data);
        }
    }

    public void sendPresenceSubscribe(String to, String from, Serializable[] data) {
        HmtpAgentStream stream = this.findAgent(to);
        if (stream != null) {
            stream.sendPresenceSubscribe(to, from, data);
        }
    }

    public void sendPresenceSubscribed(String to, String from, Serializable[] data) {
        HmtpAgentStream stream = this.findAgent(to);
        if (stream != null) {
            stream.sendPresenceSubscribed(to, from, data);
        }
    }

    public void sendPresenceUnsubscribe(String to, String from, Serializable[] data) {
        HmtpAgentStream stream = this.findAgent(to);
        if (stream != null) {
            stream.sendPresenceUnsubscribe(to, from, data);
        }
    }

    public void sendPresenceUnsubscribed(String to, String from, Serializable[] data) {
        HmtpAgentStream stream = this.findAgent(to);
        if (stream != null) {
            stream.sendPresenceUnsubscribed(to, from, data);
        }
    }

    public void sendPresenceError(String to, String from, Serializable[] data, HmtpError error) {
        HmtpAgentStream stream = this.findAgent(to);
        if (stream != null) {
            stream.sendPresenceError(to, from, data, error);
        }
    }

    public void sendMessage(String to, String from, Serializable value) {
        HmtpAgentStream stream = this.findAgent(to);
        if (stream != null) {
            stream.sendMessage(to, from, value);
        } else {
            log.fine(this + " sendMessage to=" + to + " from=" + from + " is an unknown stream");
        }
    }

    public void sendMessageError(String to, String from, Serializable value, HmtpError error) {
        HmtpAgentStream stream = this.findAgent(to);
        if (stream != null) {
            stream.sendMessageError(to, from, value, error);
        } else {
            log.fine(this + " sendMessageError to=" + to + " from=" + from + " error=" + error + " is an unknown stream");
        }
    }

    public boolean sendQueryGet(long id, String to, String from, Serializable query) {
        HmtpAgentStream stream = this.findAgent(to);
        if (stream != null) {
            if (!stream.sendQueryGet(id, to, from, query)) {
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this + " queryGet to unknown feature to='" + to + "' from=" + from + " query='" + query + "'");
                }
                String msg = L.l("'{0}' is an unknown feature for to='{1}'", (Object)query, (Object)to);
                HmtpError error = new HmtpError("cancel", "feature-not-implemented", msg);
                this.sendQueryError(id, from, to, query, error);
            }
            return true;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " queryGet to unknown stream to='" + to + "' from=" + from);
        }
        String msg = L.l("'{0}' is an unknown service for queryGet", (Object)to);
        HmtpError error = new HmtpError("cancel", "service-unavailable", msg);
        this.sendQueryError(id, from, to, query, error);
        return true;
    }

    public boolean sendQuerySet(long id, String to, String from, Serializable query) {
        HmtpAgentStream stream = this.findAgent(to);
        if (stream == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " querySet to unknown stream '" + to + "' from=" + from);
            }
            String msg = L.l("'{0}' is an unknown service for querySet", (Object)to);
            HmtpError error = new HmtpError("cancel", "service-unavailable", msg);
            this.sendQueryError(id, from, to, query, error);
            return true;
        }
        if (stream.sendQuerySet(id, to, from, query)) {
            return true;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " querySet with unknown feature to=" + to + " from=" + from + " resource=" + stream + " query=" + query);
        }
        String msg = L.l("'{0}' is an unknown feature for querySet", (Object)query);
        HmtpError error = new HmtpError("cancel", "feature-not-implemented", msg);
        this.sendQueryError(id, from, to, query, error);
        return true;
    }

    public void sendQueryResult(long id, String to, String from, Serializable value) {
        HmtpAgentStream stream = this.findAgent(to);
        if (stream == null) {
            throw new RuntimeException(L.l("{0} is an unknown entity", (Object)to));
        }
        stream.sendQueryResult(id, to, from, value);
    }

    public void sendQueryError(long id, String to, String from, Serializable query, HmtpError error) {
        HmtpAgentStream stream = this.findAgent(to);
        if (stream == null) {
            throw new RuntimeException(L.l("{0} is an unknown entity", (Object)to));
        }
        stream.sendQueryError(id, to, from, query, error);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HmtpAgentStream findAgent(String jid) {
        HashMap<String, WeakReference<HmtpAgentStream>> hashMap = this._agentMap;
        synchronized (hashMap) {
            WeakReference<HmtpAgentStream> ref = this._agentMap.get(jid);
            if (ref != null) {
                return (HmtpAgentStream)ref.get();
            }
        }
        HmtpService service = this.findService(jid);
        if (service == null) {
            return null;
        }
        HmtpAgentStream agentStream = jid.equals(service.getJid()) ? service.getAgentStream() : service.findAgent(jid);
        if (agentStream != null) {
            HashMap<String, WeakReference<HmtpAgentStream>> hashMap2 = this._agentMap;
            synchronized (hashMap2) {
                WeakReference<HmtpAgentStream> ref = this._agentMap.get(jid);
                if (ref != null) {
                    return (HmtpAgentStream)ref.get();
                }
                this._agentMap.put(jid, new WeakReference<HmtpAgentStream>(agentStream));
                return agentStream;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected HmtpService findService(String jid) {
        Object ref;
        if (jid == null) {
            return null;
        }
        HashMap<String, WeakReference<HmtpService>> hashMap = this._serviceCache;
        synchronized (hashMap) {
            ref = this._serviceCache.get(jid);
            if (ref != null) {
                return (HmtpService)((Reference)ref).get();
            }
        }
        HmtpService service = this.findServiceFromManager(jid);
        if (service != null) {
            ref = this._serviceCache;
            synchronized (ref) {
                WeakReference<HmtpService> ref2 = this._serviceCache.get(jid);
                if (ref2 != null) {
                    return (HmtpService)ref2.get();
                }
                this._serviceCache.put(jid, new WeakReference<HmtpService>(service));
                return service;
            }
        }
        int p = jid.indexOf(47);
        if (p > 0) {
            String uid = jid.substring(0, p);
            return this.findService(uid);
        }
        p = jid.indexOf(64);
        if (p > 0) {
            String domainName = jid.substring(p + 1);
            return this.findService(domainName);
        }
        return null;
    }

    protected HmtpService findServiceFromManager(String jid) {
        for (HmtpServiceManager manager : this._serviceManagerList) {
            HmtpService service = manager.findService(jid);
            if (service == null) continue;
            return service;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void closeAgent(String jid) {
        String owner;
        HmtpService service;
        int p = jid.indexOf(47);
        if (p > 0 && (service = this.findService(owner = jid.substring(0, p))) != null) {
            try {
                service.onAgentStop(jid);
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        HashMap<String, WeakReference<Object>> hashMap = this._serviceCache;
        synchronized (hashMap) {
            this._serviceCache.remove(jid);
        }
        hashMap = this._agentMap;
        synchronized (hashMap) {
            this._agentMap.remove(jid);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

