/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hemp.broker;

import com.caucho.hemp.broker.HempConnectionImpl;
import com.caucho.hmtp.HmtpAgentStream;
import com.caucho.hmtp.HmtpError;
import com.caucho.hmtp.HmtpMessageStream;
import com.caucho.hmtp.HmtpPresenceStream;
import com.caucho.hmtp.HmtpQueryStream;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

class HempConnectionAgentStream
implements HmtpAgentStream {
    private static final Logger log = Logger.getLogger(HempConnectionAgentStream.class.getName());
    private static final L10N L = new L10N(HempConnectionAgentStream.class);
    private final HempConnectionImpl _conn;
    private final String _jid;
    private HmtpMessageStream _messageHandler;
    private HmtpQueryStream _queryHandler;
    private HmtpPresenceStream _presenceHandler;

    HempConnectionAgentStream(HempConnectionImpl conn) {
        this._conn = conn;
        this._jid = conn.getJid();
    }

    public String getJid() {
        return this._jid;
    }

    void setMessageHandler(HmtpMessageStream handler) {
        this._messageHandler = handler;
    }

    public void setQueryHandler(HmtpQueryStream handler) {
        this._queryHandler = handler;
    }

    public void setPresenceHandler(HmtpPresenceStream handler) {
        this._presenceHandler = handler;
    }

    public void sendMessage(String to, String from, Serializable value) {
        HmtpMessageStream handler = this._messageHandler;
        if (handler == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " sendMessage (no handler) to=" + to + " from=" + from);
            }
            return;
        }
        handler.sendMessage(to, from, value);
    }

    public void sendMessageError(String to, String from, Serializable value, HmtpError error) {
        HmtpMessageStream handler = this._messageHandler;
        if (handler == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " sendMessageError (no handler) to=" + to + " from=" + from + " error=" + error);
            }
            return;
        }
        handler.sendMessageError(to, from, value, error);
    }

    public boolean sendQueryGet(long id, String to, String from, Serializable query) {
        HmtpQueryStream handler = this._queryHandler;
        if (handler == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " sendQueryGet (no handler) to=" + to + " from=" + from);
            }
            return false;
        }
        if (handler.sendQueryGet(id, to, from, query)) {
            return true;
        }
        HmtpError error = new HmtpError("cancel", "feature-not-implemented", "unknown query: " + query.getClass().getName());
        this._conn.getBrokerStream().sendQueryError(id, from, to, query, error);
        return true;
    }

    public boolean sendQuerySet(long id, String to, String from, Serializable query) {
        HmtpQueryStream handler = this._queryHandler;
        if (handler == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " sendQuerySet (no handler) to=" + to + " from=" + from);
            }
            return false;
        }
        if (handler.sendQuerySet(id, to, from, query)) {
            return true;
        }
        HmtpError error = new HmtpError("cancel", "feature-not-implemented", "unknown query: " + query.getClass().getName());
        this._conn.getBrokerStream().sendQueryError(id, from, to, query, error);
        return true;
    }

    public void sendQueryResult(long id, String to, String from, Serializable value) {
        HmtpQueryStream handler = this._queryHandler;
        if (handler == null) {
            if (this._conn.onQueryResult(id, to, from, value)) {
                return;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " sendQueryResult (no handler) to=" + to + " from=" + from);
            }
            return;
        }
        handler.sendQueryResult(id, to, from, value);
    }

    public void sendQueryError(long id, String to, String from, Serializable query, HmtpError error) {
        HmtpQueryStream handler = this._queryHandler;
        if (handler == null) {
            if (this._conn.onQueryError(id, to, from, query, error)) {
                return;
            }
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " sendQueryError (no handler) to=" + to + " from=" + from);
            }
            return;
        }
        handler.sendQueryError(id, to, from, query, error);
    }

    public void sendPresence(String to, String from, Serializable[] data) {
        HmtpPresenceStream handler = this._presenceHandler;
        if (handler == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " sendPresence (no handler) to=" + to + " from=" + from);
            }
            return;
        }
        handler.sendPresence(to, from, data);
    }

    public void sendPresenceProbe(String to, String from, Serializable[] data) {
        HmtpPresenceStream handler = this._presenceHandler;
        if (handler == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " sendPresenceProbe (no handler) to=" + to + " from=" + from);
            }
            return;
        }
        handler.sendPresenceProbe(to, from, data);
    }

    public void sendPresenceUnavailable(String to, String from, Serializable[] data) {
        HmtpPresenceStream handler = this._presenceHandler;
        if (handler == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " sendPresenceUnavailable (no handler) to=" + to + " from=" + from);
            }
            return;
        }
        handler.sendPresenceUnavailable(to, from, data);
    }

    public void sendPresenceSubscribe(String to, String from, Serializable[] data) {
        HmtpPresenceStream handler = this._presenceHandler;
        if (handler == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " sendPresenceSubscribe (no handler) to=" + to + " from=" + from);
            }
            return;
        }
        handler.sendPresenceSubscribe(to, from, data);
    }

    public void sendPresenceSubscribed(String to, String from, Serializable[] data) {
        HmtpPresenceStream handler = this._presenceHandler;
        if (handler == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " sendPresenceSubscribed (no handler) to=" + to + " from=" + from);
            }
            return;
        }
        handler.sendPresenceSubscribed(to, from, data);
    }

    public void sendPresenceUnsubscribe(String to, String from, Serializable[] data) {
        HmtpPresenceStream handler = this._presenceHandler;
        if (handler == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " sendPresenceUnsubscribe (no handler) to=" + to + " from=" + from);
            }
            return;
        }
        handler.sendPresenceUnsubscribe(to, from, data);
    }

    public void sendPresenceUnsubscribed(String to, String from, Serializable[] data) {
        HmtpPresenceStream handler = this._presenceHandler;
        if (handler == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " sendPresenceUnsubscribed (no handler) to=" + to + " from=" + from);
            }
            return;
        }
        handler.sendPresenceUnsubscribed(to, from, data);
    }

    public void sendPresenceError(String to, String from, Serializable[] data, HmtpError error) {
        HmtpPresenceStream handler = this._presenceHandler;
        if (handler == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " sendPresenceError (no handler) to=" + to + " from=" + from);
            }
            return;
        }
        handler.sendPresenceError(to, from, data, error);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getJid() + "]";
    }
}

