/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hemp.broker;

import com.caucho.hemp.broker.HempBroker;
import com.caucho.hemp.broker.HempConnectionAgentStream;
import com.caucho.hmtp.HmtpConnection;
import com.caucho.hmtp.HmtpError;
import com.caucho.hmtp.HmtpMessageStream;
import com.caucho.hmtp.HmtpPresenceStream;
import com.caucho.hmtp.HmtpQueryCallback;
import com.caucho.hmtp.HmtpQueryStream;
import com.caucho.hmtp.HmtpStream;
import com.caucho.hmtp.spi.HmtpService;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HempConnectionImpl
implements HmtpConnection {
    private static final Logger log = Logger.getLogger(HempConnectionImpl.class.getName());
    private static final L10N L = new L10N(HempConnectionImpl.class);
    private final HempBroker _broker;
    private final HempConnectionAgentStream _handler;
    private final String _jid;
    private HashMap<Long, QueryItem> _queryMap = new HashMap();
    private long _qId;
    private HmtpStream _brokerFilter;
    private HmtpStream _brokerStream;
    private HmtpService _resource;
    private boolean _isClosed;

    HempConnectionImpl(HempBroker manager, String jid) {
        this._broker = manager;
        this._jid = jid;
        this._handler = new HempConnectionAgentStream(this);
        this._brokerStream = manager;
        String uid = jid;
        int p = uid.indexOf(47);
        if (p > 0) {
            uid = uid.substring(0, p);
        }
        this._resource = manager.findService(uid);
        if (this._resource != null) {
            this._brokerStream = this._brokerFilter = this._resource.getBrokerFilter(this._broker);
        }
    }

    public String getJid() {
        return this._jid;
    }

    HempConnectionAgentStream getAgentStreamHandler() {
        return this._handler;
    }

    public HmtpStream getBrokerStream() {
        return this._brokerStream;
    }

    public void setMessageHandler(HmtpMessageStream handler) {
        this._handler.setMessageHandler(handler);
    }

    public void setQueryHandler(HmtpQueryStream handler) {
        this._handler.setQueryHandler(handler);
    }

    public void setPresenceHandler(HmtpPresenceStream handler) {
        this._handler.setPresenceHandler(handler);
    }

    public void sendMessage(String to, Serializable msg) {
        if (this._isClosed) {
            throw new IllegalStateException(L.l("session is closed"));
        }
        this._brokerStream.sendMessage(to, this._jid, msg);
    }

    public Serializable queryGet(String to, Serializable query) {
        if (this._isClosed) {
            throw new IllegalStateException(L.l("session is closed"));
        }
        WaitQueryCallback callback = new WaitQueryCallback();
        this.queryGet(to, query, callback);
        if (callback.waitFor()) {
            return callback.getResult();
        }
        throw new RuntimeException(String.valueOf(callback.getError()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryGet(String to, Serializable value, HmtpQueryCallback callback) {
        long id;
        if (this._isClosed) {
            throw new IllegalStateException(L.l("session is closed"));
        }
        HempConnectionImpl hempConnectionImpl = this;
        synchronized (hempConnectionImpl) {
            id = this._qId++;
            this._queryMap.put(id, new QueryItem(id, callback));
        }
        this.getBrokerStream().sendQueryGet(id, to, this._jid, value);
    }

    public Serializable querySet(String to, Serializable query) {
        if (this._isClosed) {
            throw new IllegalStateException(L.l("session is closed"));
        }
        WaitQueryCallback callback = new WaitQueryCallback();
        this.querySet(to, query, callback);
        if (callback.waitFor()) {
            return callback.getResult();
        }
        throw new RuntimeException(String.valueOf(callback.getError()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void querySet(String to, Serializable value, HmtpQueryCallback callback) {
        long id;
        if (this._isClosed) {
            throw new IllegalStateException(L.l("session is closed"));
        }
        HempConnectionImpl hempConnectionImpl = this;
        synchronized (hempConnectionImpl) {
            id = this._qId++;
            this._queryMap.put(id, new QueryItem(id, callback));
        }
        this.getBrokerStream().sendQuerySet(id, to, this._jid, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean onQueryResult(long id, String to, String from, Serializable value) {
        QueryItem item = null;
        HempConnectionImpl hempConnectionImpl = this;
        synchronized (hempConnectionImpl) {
            item = this._queryMap.remove(id);
        }
        if (item != null) {
            item.onQueryResult(to, from, value);
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean onQueryError(long id, String to, String from, Serializable value, HmtpError error) {
        QueryItem item = null;
        HempConnectionImpl hempConnectionImpl = this;
        synchronized (hempConnectionImpl) {
            item = this._queryMap.remove(id);
        }
        if (item != null) {
            item.onQueryError(to, from, value, error);
            return true;
        }
        return false;
    }

    public void presence(Serializable[] data) {
        if (this._isClosed) {
            throw new IllegalStateException(L.l("session is closed"));
        }
        this._brokerStream.sendPresence(null, this._jid, data);
    }

    public void presence(String to, Serializable[] data) {
        if (this._isClosed) {
            throw new IllegalStateException(L.l("session is closed"));
        }
        this._brokerStream.sendPresence(to, this._jid, data);
    }

    public void presenceUnavailable(Serializable[] data) {
        if (this._isClosed) {
            throw new IllegalStateException(L.l("session is closed"));
        }
        this._brokerStream.sendPresenceUnavailable(null, this._jid, data);
    }

    public void presenceUnavailable(String to, Serializable[] data) {
        if (this._isClosed) {
            throw new IllegalStateException(L.l("session is closed"));
        }
        this._brokerStream.sendPresenceUnavailable(to, this._jid, data);
    }

    public void presenceProbe(String to, Serializable[] data) {
        if (this._isClosed) {
            throw new IllegalStateException(L.l("session is closed"));
        }
        this._brokerStream.sendPresenceProbe(to, this._jid, data);
    }

    public void presenceSubscribe(String to, Serializable[] data) {
        if (this._isClosed) {
            throw new IllegalStateException(L.l("session is closed"));
        }
        this._brokerStream.sendPresenceSubscribe(to, this._jid, data);
    }

    public void presenceSubscribed(String to, Serializable[] data) {
        if (this._isClosed) {
            throw new IllegalStateException(L.l("session is closed"));
        }
        this._brokerStream.sendPresenceSubscribed(to, this._jid, data);
    }

    public void presenceUnsubscribe(String to, Serializable[] data) {
        if (this._isClosed) {
            throw new IllegalStateException(L.l("session is closed"));
        }
        this._brokerStream.sendPresenceUnsubscribe(to, this._jid, data);
    }

    public void presenceUnsubscribed(String to, Serializable[] data) {
        if (this._isClosed) {
            throw new IllegalStateException(L.l("session is closed"));
        }
        this._brokerStream.sendPresenceUnsubscribed(to, this._jid, data);
    }

    public void presenceError(String to, Serializable[] data, HmtpError error) {
        if (this._isClosed) {
            throw new IllegalStateException(L.l("session is closed"));
        }
        this._brokerStream.sendPresenceError(to, this._jid, data, error);
    }

    public boolean isClosed() {
        return this._isClosed;
    }

    public void close() {
        this._isClosed = true;
        this._broker.closeAgent(this._jid);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._jid + "]";
    }

    static class WaitQueryCallback
    implements HmtpQueryCallback {
        private Serializable _result;
        private HmtpError _error;
        private boolean _isResult;

        WaitQueryCallback() {
        }

        public Serializable getResult() {
            return this._result;
        }

        public HmtpError getError() {
            return this._error;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean waitFor() {
            try {
                WaitQueryCallback waitQueryCallback = this;
                synchronized (waitQueryCallback) {
                    if (!this._isResult) {
                        this.wait(10000L);
                    }
                }
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
            return this._isResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onQueryResult(String fromJid, String toJid, Serializable value) {
            this._result = value;
            WaitQueryCallback waitQueryCallback = this;
            synchronized (waitQueryCallback) {
                this._isResult = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onQueryError(String fromJid, String toJid, Serializable value, HmtpError error) {
            this._error = error;
            WaitQueryCallback waitQueryCallback = this;
            synchronized (waitQueryCallback) {
                this._isResult = true;
                this.notifyAll();
            }
        }
    }

    static class QueryItem {
        private final long _id;
        private final HmtpQueryCallback _callback;

        QueryItem(long id, HmtpQueryCallback callback) {
            this._id = id;
            this._callback = callback;
        }

        void onQueryResult(String to, String from, Serializable value) {
            if (this._callback != null) {
                this._callback.onQueryResult(to, from, value);
            }
        }

        void onQueryError(String to, String from, Serializable value, HmtpError error) {
            if (this._callback != null) {
                this._callback.onQueryError(to, from, value, error);
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._id + "," + this._callback + "]";
        }
    }
}

