/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hemp.broker;

import com.caucho.hmtp.HmtpAgentStream;
import com.caucho.hmtp.HmtpError;
import com.caucho.hmtp.HmtpStream;
import com.caucho.hmtp.packet.Message;
import com.caucho.hmtp.packet.MessageError;
import com.caucho.hmtp.packet.Packet;
import com.caucho.hmtp.packet.Presence;
import com.caucho.hmtp.packet.PresenceError;
import com.caucho.hmtp.packet.PresenceProbe;
import com.caucho.hmtp.packet.PresenceSubscribe;
import com.caucho.hmtp.packet.PresenceSubscribed;
import com.caucho.hmtp.packet.PresenceUnavailable;
import com.caucho.hmtp.packet.PresenceUnsubscribe;
import com.caucho.hmtp.packet.PresenceUnsubscribed;
import com.caucho.hmtp.packet.QueryError;
import com.caucho.hmtp.packet.QueryGet;
import com.caucho.hmtp.packet.QueryResult;
import com.caucho.hmtp.packet.QuerySet;
import com.caucho.server.util.ScheduledThreadPool;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.util.concurrent.Executor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HempMemoryQueue
implements HmtpAgentStream,
Runnable {
    private static final Logger log = Logger.getLogger(HempMemoryQueue.class.getName());
    private static final L10N L = new L10N(HempMemoryQueue.class);
    private final Executor _executor = ScheduledThreadPool.getLocal();
    private final ClassLoader _loader = Thread.currentThread().getContextClassLoader();
    private final HmtpAgentStream _agentStream;
    private final HmtpStream _brokerStream;
    private int _threadSemaphore;
    private Packet[] _queue = new Packet[32];
    private int _head;
    private int _tail;

    public HempMemoryQueue(HmtpAgentStream agentStream, HmtpStream brokerStream) {
        if (agentStream == null) {
            throw new NullPointerException();
        }
        if (brokerStream == null) {
            throw new NullPointerException();
        }
        this._agentStream = agentStream;
        this._brokerStream = brokerStream;
        this._threadSemaphore = 1;
    }

    public String getJid() {
        return this._agentStream.getJid();
    }

    public void sendMessage(String to, String from, Serializable value) {
        this.enqueue(new Message(to, from, value));
    }

    public void sendMessageError(String to, String from, Serializable value, HmtpError error) {
        this.enqueue(new MessageError(to, from, value, error));
    }

    public boolean sendQueryGet(long id, String to, String from, Serializable query) {
        this.enqueue(new QueryGet(id, to, from, query));
        return true;
    }

    public boolean sendQuerySet(long id, String to, String from, Serializable query) {
        this.enqueue(new QuerySet(id, to, from, query));
        return true;
    }

    public void sendQueryResult(long id, String to, String from, Serializable value) {
        this.enqueue(new QueryResult(id, to, from, value));
    }

    public void sendQueryError(long id, String to, String from, Serializable query, HmtpError error) {
        this.enqueue(new QueryError(id, to, from, query, error));
    }

    public void sendPresence(String to, String from, Serializable[] data) {
        this.enqueue(new Presence(to, from, data));
    }

    public void sendPresenceUnavailable(String to, String from, Serializable[] data) {
        this.enqueue(new PresenceUnavailable(to, from, data));
    }

    public void sendPresenceProbe(String to, String from, Serializable[] data) {
        this.enqueue(new PresenceProbe(to, from, data));
    }

    public void sendPresenceSubscribe(String to, String from, Serializable[] data) {
        this.enqueue(new PresenceSubscribe(to, from, data));
    }

    public void sendPresenceSubscribed(String to, String from, Serializable[] data) {
        this.enqueue(new PresenceSubscribed(to, from, data));
    }

    public void sendPresenceUnsubscribe(String to, String from, Serializable[] data) {
        this.enqueue(new PresenceUnsubscribe(to, from, data));
    }

    public void sendPresenceUnsubscribed(String to, String from, Serializable[] data) {
        this.enqueue(new PresenceUnsubscribed(to, from, data));
    }

    public void sendPresenceError(String to, String from, Serializable[] data, HmtpError error) {
        this.enqueue(new PresenceError(to, from, data, error));
    }

    protected HmtpStream getStream() {
        return this._agentStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void enqueue(Packet packet) {
        if (log.isLoggable(Level.FINER)) {
            int size = (this._head - this._tail + this._queue.length) % this._queue.length;
            log.finer(this + " enqueue(" + size + ") " + packet);
        }
        boolean isStartThread = false;
        HempMemoryQueue hempMemoryQueue = this;
        synchronized (hempMemoryQueue) {
            int next = (this._head + 1) % this._queue.length;
            if (next == this._tail) {
                Packet[] extQueue = new Packet[this._queue.length + 32];
                int i = 0;
                int tail = this._tail;
                while (tail != this._head) {
                    extQueue[i++] = this._queue[tail];
                    tail = (tail + 1) % this._queue.length;
                }
                this._queue = extQueue;
                this._tail = 0;
                this._head = i;
                next = this._head + 1;
            }
            this._queue[this._head] = packet;
            this._head = next;
            if (this._threadSemaphore > 0) {
                --this._threadSemaphore;
                isStartThread = true;
            }
        }
        if (isStartThread) {
            this._executor.execute(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Packet dequeue() {
        boolean isStartThread = false;
        HempMemoryQueue hempMemoryQueue = this;
        synchronized (hempMemoryQueue) {
            if (this._head == this._tail) {
                ++this._threadSemaphore;
                return null;
            }
            Packet packet = this._queue[this._tail];
            this._tail = (this._tail + 1) % this._queue.length;
            return packet;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        Thread.currentThread().setContextClassLoader(this._loader);
        Packet packet;
        while ((packet = this.dequeue()) != null) {
            HempMemoryQueue hempMemoryQueue;
            Object var5_4;
            boolean isValid = false;
            try {
                try {
                    if (log.isLoggable(Level.FINER)) {
                        log.finer(this + " dequeue " + packet);
                    }
                    packet.dispatch(this.getStream(), this._brokerStream);
                    isValid = true;
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                    isValid = true;
                    var5_4 = null;
                    if (isValid) continue;
                    hempMemoryQueue = this;
                    synchronized (hempMemoryQueue) {
                        ++this._threadSemaphore;
                        continue;
                    }
                }
                var5_4 = null;
                if (isValid) continue;
                hempMemoryQueue = this;
            }
            catch (Throwable throwable) {
                var5_4 = null;
                if (!isValid) {
                    hempMemoryQueue = this;
                    synchronized (hempMemoryQueue) {
                        ++this._threadSemaphore;
                    }
                }
                throw throwable;
            }
            synchronized (hempMemoryQueue) {
                ++this._threadSemaphore;
            }
        }
        return;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._agentStream + "]";
    }
}

