/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hemp.im;

import com.caucho.hemp.im.ImBrokerFilter;
import com.caucho.hmtp.HmtpStream;
import com.caucho.hmtp.disco.DiscoFeature;
import com.caucho.hmtp.disco.DiscoIdentity;
import com.caucho.hmtp.disco.DiscoInfoQuery;
import com.caucho.hmtp.im.RosterItem;
import com.caucho.hmtp.im.RosterQuery;
import com.caucho.hmtp.spi.SimpleHmtpService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ImUserService
extends SimpleHmtpService {
    private static final Logger log = Logger.getLogger(ImUserService.class.getName());
    private HmtpStream _broker;
    private ArrayList<String> _jidList = new ArrayList();
    private String[] _jids = new String[0];

    public ImUserService() {
    }

    public ImUserService(HmtpStream broker, String jid) {
        if (broker == null) {
            throw new NullPointerException("server may not be null");
        }
        this.setJid(jid);
        this._broker = broker;
    }

    public String[] getJids() {
        return this._jids;
    }

    public HmtpStream getBrokerFilter(HmtpStream stream) {
        return new ImBrokerFilter(stream, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAgentStart(String jid) {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " login(" + jid + ")");
        }
        ArrayList<String> arrayList = this._jidList;
        synchronized (arrayList) {
            if (!this._jidList.contains(jid)) {
                this._jidList.add(jid);
            }
            this._jids = new String[this._jidList.size()];
            this._jidList.toArray(this._jids);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onAgentStop(String jid) {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " logout(" + jid + ")");
        }
        ArrayList<String> arrayList = this._jidList;
        synchronized (arrayList) {
            this._jidList.remove(jid);
            this._jids = new String[this._jidList.size()];
            this._jidList.toArray(this._jids);
        }
    }

    public void sendMessage(String to, String from, Serializable value) {
        String[] jids;
        for (String jid : jids = this._jids) {
            this._broker.sendMessage(jid, from, value);
        }
    }

    public boolean sendQueryGet(long id, String to, String from, Serializable query) {
        if (query instanceof DiscoInfoQuery) {
            DiscoInfoQuery info = new DiscoInfoQuery(this.getDiscoIdentity(), this.getDiscoFeatures());
            this._broker.sendQueryResult(id, from, to, info);
            return true;
        }
        if (query instanceof RosterQuery) {
            this._broker.sendQueryResult(id, from, to, new RosterQuery(this.getRoster()));
            return true;
        }
        return false;
    }

    public boolean sendQuerySet(long id, String to, String from, Serializable query) {
        if (query instanceof RosterQuery) {
            RosterQuery roster = (RosterQuery)query;
            return this.querySetRoster(id, to, from, roster);
        }
        return false;
    }

    public void sendPresence(String to, String from, Serializable[] data) {
        String[] jids;
        for (String jid : jids = this._jids) {
            this._broker.sendPresence(jid, from, data);
        }
    }

    public void sendPresenceProbe(String to, String from, Serializable[] data) {
        String[] jids;
        for (String jid : jids = this._jids) {
            this._broker.sendPresenceProbe(jid, from, data);
        }
    }

    public void sendPresenceUnavailable(String to, String from, Serializable[] data) {
        String[] jids;
        for (String jid : jids = this._jids) {
            this._broker.sendPresenceUnavailable(jid, from, data);
        }
    }

    public void sendPresence(String from, Serializable[] data) {
        for (RosterItem item : this.getRoster()) {
            String subscription = item.getSubscription();
            if ("from".equals(subscription) || "both".equals(subscription)) {
                this._broker.sendPresence(item.getJid(), this.getJid(), data);
            }
            if (!"to".equals(subscription) && !"both".equals(subscription)) continue;
            this._broker.sendPresenceProbe(item.getJid(), this.getJid(), data);
        }
        for (String jid : this._jids) {
            if (jid.equals(from)) continue;
            this._broker.sendPresence(jid, from, data);
        }
    }

    public void sendPresenceSubscribe(String to, String from, Serializable[] data) {
        if (!this.rosterSubscribeFrom(to, from, data)) {
            log.fine(this + " sendPresenceSubscribe denied from=" + from);
            return;
        }
        String[] jids = this._jids;
        if (jids.length > 0) {
            this._broker.sendPresenceSubscribe(jids[0], from, data);
        } else {
            log.fine(this + " onPresenceSubscribe to=" + to);
        }
    }

    public void sendPresenceSubscribed(String to, String from, Serializable[] data) {
        String[] jids;
        if (this.rosterSubscribedFrom(to, from, data) && (jids = this._jids).length > 0) {
            this._broker.sendPresenceSubscribed(jids[0], from, data);
        }
    }

    private boolean querySetRoster(long id, String to, String from, RosterQuery roster) {
        String user = from;
        int p = from.indexOf(47);
        if (p > 0) {
            user = from.substring(0, p);
        }
        if (!user.equals(to)) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " roster set with non-matching to='" + to + "' from='" + from + "'");
            }
            return false;
        }
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " roster set to='" + to + "' from='" + from + "'");
        }
        if (roster.getItems() != null) {
            for (RosterItem item : roster.getItems()) {
                if ("remove".equals(item.getSubscription())) {
                    this.removeRoster(item);
                    continue;
                }
                this.updateRoster(item);
            }
        }
        this.querySetResources(roster);
        this._broker.sendQueryResult(id, from, to, null);
        return true;
    }

    protected DiscoIdentity[] getDiscoIdentity() {
        return new DiscoIdentity[]{new DiscoIdentity("foo", "bar")};
    }

    protected DiscoFeature[] getDiscoFeatures() {
        return new DiscoFeature[]{new DiscoFeature(DiscoInfoQuery.class.getName())};
    }

    protected void updateRoster(RosterItem item) {
    }

    protected void removeRoster(RosterItem item) {
    }

    protected boolean rosterSubscribeTo(String to, String from, Serializable[] data) {
        return true;
    }

    protected boolean rosterSubscribeFrom(String to, String from, Serializable[] data) {
        return true;
    }

    protected boolean rosterSubscribedTo(String to, String from, Serializable[] data) {
        return true;
    }

    protected boolean rosterSubscribedFrom(String to, String from, Serializable[] data) {
        return true;
    }

    protected RosterItem[] getRoster() {
        return new RosterItem[0];
    }

    protected void querySetResources(Serializable query) {
    }
}

