/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hemp.muc.memory;

import com.caucho.hemp.muc.memory.MemoryRoom;
import com.caucho.hmtp.im.ImMessage;
import com.caucho.hmtp.muc.MucUserPresence;
import com.caucho.hmtp.spi.SimpleHmtpService;
import java.io.Serializable;
import java.util.logging.Logger;

public class MemoryNick
extends SimpleHmtpService {
    private static final Logger log = Logger.getLogger(MemoryNick.class.getName());
    private static final String MUC_PERSISTENT_FEATURE = "muc_persistent";
    private final MemoryRoom _room;
    private String _userJid;
    private String _affiliation = "member";
    private String _role = "participant";

    public MemoryNick(MemoryRoom room, String jid) {
        this._room = room;
        this.setJid(jid);
    }

    public String getUserJid() {
        return this._userJid;
    }

    public String getAffiliation() {
        return this._affiliation;
    }

    public String getRole() {
        return this._role;
    }

    public void sendMessage(String to, String from, Serializable value) {
        MemoryNick user = this._room.getNick(from);
        if (user == null) {
            log.warning(this + " sendMessage unknown user from=" + from);
            return;
        }
        if (!(value instanceof ImMessage)) {
            log.fine(this + " sendMessage with unknown value from=" + from + " value=" + value);
            return;
        }
        ImMessage msg = (ImMessage)value;
        this._room.getBrokerStream().sendMessage(this.getUserJid(), user.getJid(), msg);
    }

    public void sendPresence(String to, String from, Serializable[] data) {
        this._userJid = from;
        this._room.addPresence(this);
    }

    public MucUserPresence toPresenceData() {
        MucUserPresence presence = new MucUserPresence();
        presence.setAffiliation(this.getAffiliation());
        presence.setRole(this.getRole());
        return presence;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getJid() + ",user=" + this.getUserJid() + "]";
    }
}

