/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hemp.muc.memory;

import com.caucho.hemp.broker.GenericService;
import com.caucho.hemp.muc.memory.MemoryNick;
import com.caucho.hmtp.HmtpAgentStream;
import com.caucho.hmtp.HmtpStream;
import com.caucho.hmtp.im.ImMessage;
import com.caucho.hmtp.muc.MucUserPresence;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryRoom
extends GenericService {
    private static final Logger log = Logger.getLogger(MemoryRoom.class.getName());
    private static final String MUC_PERSISTENT_FEATURE = "muc_persistent";
    private HashMap<String, MemoryNick> _nicknameMap = new HashMap();
    private ArrayList<MemoryNick> _users = new ArrayList();
    private MemoryNick[] _userArray = new MemoryNick[0];

    @Override
    protected String getDiscoCategory() {
        return "conference";
    }

    @Override
    protected String getDiscoType() {
        return "text";
    }

    @Override
    protected void getDiscoFeatureNames(ArrayList<String> featureNames) {
        super.getDiscoFeatureNames(featureNames);
        featureNames.add(MUC_PERSISTENT_FEATURE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HmtpAgentStream findAgent(String jid) {
        HashMap<String, MemoryNick> hashMap = this._nicknameMap;
        synchronized (hashMap) {
            MemoryNick nick = this._nicknameMap.get(jid);
            if (nick == null) {
                nick = new MemoryNick(this, jid);
                this._nicknameMap.put(jid, nick);
            }
            return nick.getAgentStream();
        }
    }

    @Override
    public void sendMessage(String to, String from, Serializable value) {
        MemoryNick[] users;
        MemoryNick nick = this.getNick(from);
        if (nick == null) {
            log.warning(this + " sendMessage unknown user from=" + from);
            return;
        }
        if (!(value instanceof ImMessage)) {
            log.fine(this + " sendMessage with unknown value from=" + from + " value=" + value);
            return;
        }
        ImMessage msg = (ImMessage)value;
        if (!"groupchat".equals(msg.getType())) {
            log.fine(this + " sendMessage expects 'groupchat' at type='" + msg.getType() + "' from='" + from + "'");
            return;
        }
        for (MemoryNick user : users = this._userArray) {
            this.getBrokerStream().sendMessage(user.getUserJid(), nick.getJid(), msg);
        }
    }

    public MemoryNick getNick(String from) {
        MemoryNick[] users;
        for (MemoryNick user : users = this._userArray) {
            if (!user.getUserJid().equals(from)) continue;
            return user;
        }
        return null;
    }

    @Override
    public HmtpStream getBrokerStream() {
        return super.getBrokerStream();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addPresence(MemoryNick nick) {
        MucUserPresence presenceData;
        MemoryNick[] users;
        ArrayList<MemoryNick> arrayList = this._users;
        synchronized (arrayList) {
            if (!this._users.contains(nick)) {
                this._users.add(nick);
                this._userArray = new MemoryNick[this._users.size()];
                this._users.toArray(this._userArray);
                if (log.isLoggable(Level.FINE)) {
                    log.fine(this + " addPresence " + nick);
                }
            }
        }
        for (MemoryNick user : users = this._userArray) {
            if (user == nick) continue;
            presenceData = user.toPresenceData();
            this.getBrokerStream().sendPresence(nick.getUserJid(), user.getJid(), new Serializable[]{presenceData});
        }
        for (MemoryNick user : users) {
            if (user == nick) continue;
            presenceData = user.toPresenceData();
            this.getBrokerStream().sendPresence(user.getUserJid(), nick.getJid(), new Serializable[]{presenceData});
        }
        MucUserPresence presenceData2 = nick.toPresenceData();
        presenceData2.setStatus(new int[]{110});
        this.getBrokerStream().sendPresence(nick.getUserJid(), nick.getJid(), new Serializable[]{presenceData2});
    }
}

