/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hemp.pubsub.memory;

import com.caucho.hemp.pubsub.memory.MemoryPubSub;
import com.caucho.hmtp.pubsub.PubSubItem;
import com.caucho.hmtp.pubsub.PublishMessage;
import com.caucho.util.Base64;
import com.caucho.util.CharBuffer;
import com.caucho.util.RandomUtil;
import java.util.ArrayList;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryNode {
    private static final Logger log = Logger.getLogger(MemoryNode.class.getName());
    private String _name;
    private MemoryPubSub _service;
    private ArrayList<String> _ownerList = new ArrayList();
    private ArrayList<String> _subscriberList = new ArrayList();

    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    public void setService(MemoryPubSub service) {
        this._service = service;
    }

    public void addOwner(String owner) {
        this._ownerList.add(owner);
        this.addSubscriber(owner);
    }

    public void addSubscriber(String subscriber) {
        this._subscriberList.add(subscriber);
    }

    public ArrayList<String> getSubscribers() {
        return this._subscriberList;
    }

    public void publish(PubSubItem[] publishItems) {
        PubSubItem[] items = new PubSubItem[publishItems.length];
        for (int i = 0; i < publishItems.length; ++i) {
            PubSubItem item = publishItems[i];
            String id = item.getId();
            if (id == null) {
                id = this.generateId();
            }
            items[i] = new PubSubItem(id, item.getValue());
        }
        PublishMessage msg = new PublishMessage(this.getName(), items);
        for (String jid : this._subscriberList) {
            this._service.getBrokerStream().sendMessage(jid, this._service.getJid(), msg);
        }
    }

    private String generateId() {
        CharBuffer cb = new CharBuffer();
        Base64.encode((CharBuffer)cb, (long)RandomUtil.getRandomLong());
        Base64.encode((CharBuffer)cb, (long)RandomUtil.getRandomLong());
        return cb.toString();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "]";
    }
}

