/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hemp.pubsub.memory;

import com.caucho.hemp.broker.GenericService;
import com.caucho.hemp.pubsub.memory.MemoryNode;
import com.caucho.hmtp.HmtpError;
import com.caucho.hmtp.pubsub.PubSubPublish;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryPubSub
extends GenericService {
    private static final Logger log = Logger.getLogger(MemoryPubSub.class.getName());
    public static final String PUBSUB_FEATURE = "http://jabber.org/protocol/pubsub";
    private HashMap<String, MemoryNode> _nodeMap = new HashMap();

    public void addNode(MemoryNode node) {
        this._nodeMap.put(node.getName(), node);
        node.setService(this);
    }

    public MemoryNode getNode(String node) {
        return this._nodeMap.get(node);
    }

    @Override
    protected String getDiscoCategory() {
        return "pubsub";
    }

    @Override
    protected String getDiscoType() {
        return "service";
    }

    @Override
    protected void getDiscoFeatureNames(ArrayList<String> featureNames) {
        super.getDiscoFeatureNames(featureNames);
        featureNames.add(PUBSUB_FEATURE);
    }

    @Override
    public boolean sendQuerySet(long id, String to, String from, Serializable query) {
        if (query instanceof PubSubPublish) {
            PubSubPublish publish = (PubSubPublish)query;
            MemoryNode node = this.getNode(publish.getNode());
            if (node == null) {
                this.getBrokerStream().sendQueryError(id, from, to, query, new HmtpError("cancel", "no-node"));
                return true;
            }
            node.publish(publish.getItems());
            this.getBrokerStream().sendQueryResult(id, from, to, null);
            return true;
        }
        return super.sendQuerySet(id, to, from, query);
    }
}

