/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hemp.servlet;

import com.caucho.hemp.servlet.ServerBrokerStream;
import com.caucho.hmtp.AbstractHmtpStream;
import com.caucho.hmtp.HmtpError;
import com.caucho.hmtp.HmtpStream;
import com.caucho.hmtp.auth.AuthQuery;
import com.caucho.hmtp.auth.AuthResult;
import java.io.Serializable;
import java.util.logging.Logger;

public class AuthBrokerStream
extends AbstractHmtpStream {
    private static final Logger log = Logger.getLogger(AuthBrokerStream.class.getName());
    private ServerBrokerStream _manager;
    private HmtpStream _broker;

    AuthBrokerStream(ServerBrokerStream manager, HmtpStream server) {
        this._manager = manager;
        this._broker = server;
    }

    public boolean sendQueryGet(long id, String to, String from, Serializable value) {
        this._broker.sendQueryError(id, from, to, value, new HmtpError("cancel", "forbidden"));
        return true;
    }

    public boolean sendQuerySet(long id, String to, String from, Serializable value) {
        if (value instanceof AuthQuery) {
            AuthQuery auth = (AuthQuery)value;
            String jid = this._manager.login(auth.getUid(), auth.getCredentials(), auth.getResource());
            if (jid != null) {
                this._broker.sendQueryResult(id, from, to, new AuthResult(jid));
            } else {
                this._broker.sendQueryError(id, from, to, value, new HmtpError("auth", "forbidden"));
            }
        } else {
            this._broker.sendQueryError(id, from, to, value, new HmtpError("cancel", "forbidden"));
        }
        return true;
    }

    public void sendPresence(String to, String from, Serializable[] data) {
        log.fine(this + " sendPresence requires login first");
    }

    public void sendPresenceUnavailable(String to, String from, Serializable[] data) {
        log.fine(this + " sendPresenceUnavailable requires login first");
    }

    public void sendPresenceProbe(String to, String from, Serializable[] data) {
        log.fine(this + " sendPresenceProbe requires login first");
    }

    public void sendPresenceSubscribe(String to, String from, Serializable[] data) {
        log.fine(this + " sendPresenceSubscribe requires login first");
    }

    public void sendPresenceSubscribed(String to, String from, Serializable[] data) {
        log.fine(this + " sendPresenceSubscribed requires login first");
    }

    public void sendPresenceUnsubscribe(String to, String from, Serializable[] data) {
        log.fine(this + " sendPresenceUnsubscribe requires login first");
    }

    public void sendPresenceUnsubscribed(String to, String from, Serializable[] data) {
        log.fine(this + " sendPresenceUnsubscribed requires login first");
    }

    public void sendPresenceError(String to, String from, Serializable[] data, HmtpError error) {
        log.fine(this + " sendPresenceError requires login first");
    }
}

