/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hemp.servlet;

import com.caucho.hemp.servlet.ServerBrokerStream;
import com.caucho.hessian.io.Hessian2StreamingOutput;
import com.caucho.hmtp.HmtpError;
import com.caucho.hmtp.HmtpStream;
import com.caucho.hmtp.packet.Message;
import com.caucho.hmtp.packet.MessageError;
import com.caucho.hmtp.packet.Presence;
import com.caucho.hmtp.packet.PresenceError;
import com.caucho.hmtp.packet.PresenceProbe;
import com.caucho.hmtp.packet.PresenceSubscribe;
import com.caucho.hmtp.packet.PresenceSubscribed;
import com.caucho.hmtp.packet.PresenceUnavailable;
import com.caucho.hmtp.packet.PresenceUnsubscribe;
import com.caucho.hmtp.packet.PresenceUnsubscribed;
import com.caucho.hmtp.packet.QueryError;
import com.caucho.hmtp.packet.QueryGet;
import com.caucho.hmtp.packet.QueryResult;
import com.caucho.hmtp.packet.QuerySet;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerAgentStream
implements HmtpStream {
    private static final Logger log = Logger.getLogger(ServerAgentStream.class.getName());
    private ServerBrokerStream _packetHandler;
    private Hessian2StreamingOutput _out;

    ServerAgentStream(ServerBrokerStream packetHandler, Hessian2StreamingOutput out) {
        this._packetHandler = packetHandler;
        this._out = out;
    }

    public void sendMessage(String to, String from, Serializable value) {
        try {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this._packetHandler + " send message to=" + to + " from=" + from);
            }
            this._out.writeObject((Object)new Message(to, from, value));
            this._out.flush();
        }
        catch (IOException e) {
            this._packetHandler.close();
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void sendMessageError(String to, String from, Serializable value, HmtpError error) {
        try {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this._packetHandler + " send error message to=" + to + " from=" + from + " error=" + error);
            }
            this._out.writeObject((Object)new MessageError(to, from, value, error));
            this._out.flush();
        }
        catch (IOException e) {
            this._packetHandler.close();
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public boolean sendQueryGet(long id, String to, String from, Serializable query) {
        try {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this._packetHandler + " queryGet to=" + to + " from=" + from);
            }
            this._out.writeObject((Object)new QueryGet(id, to, from, query));
            this._out.flush();
        }
        catch (IOException e) {
            this._packetHandler.close();
            log.log(Level.FINE, e.toString(), e);
        }
        return true;
    }

    public boolean sendQuerySet(long id, String to, String from, Serializable query) {
        try {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this._packetHandler + " querySet to=" + to + " from=" + from);
            }
            this._out.writeObject((Object)new QuerySet(id, to, from, query));
            this._out.flush();
        }
        catch (IOException e) {
            this._packetHandler.close();
            log.log(Level.FINE, e.toString(), e);
        }
        return true;
    }

    public void sendQueryResult(long id, String to, String from, Serializable value) {
        try {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this._packetHandler + " queryResult id=" + id + " to=" + to + " from=" + from);
            }
            this._out.writeObject((Object)new QueryResult(id, to, from, value));
            this._out.flush();
        }
        catch (IOException e) {
            this._packetHandler.close();
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void sendQueryError(long id, String to, String from, Serializable query, HmtpError error) {
        try {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this._packetHandler + " send " + error + " to=" + to + " from=" + from);
            }
            this._out.writeObject((Object)new QueryError(id, to, from, query, error));
            this._out.flush();
        }
        catch (IOException e) {
            this._packetHandler.close();
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void sendPresence(String to, String from, Serializable[] data) {
        try {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this._packetHandler + " send presence to=" + to + " from=" + from);
            }
            this._out.writeObject((Object)new Presence(to, from, data));
            this._out.flush();
        }
        catch (IOException e) {
            this._packetHandler.close();
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void sendPresenceUnavailable(String to, String from, Serializable[] data) {
        try {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this._packetHandler + " send presenceUnavailable to=" + to + " from=" + from);
            }
            this._out.writeObject((Object)new PresenceUnavailable(to, from, data));
            this._out.flush();
        }
        catch (IOException e) {
            this._packetHandler.close();
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void sendPresenceProbe(String to, String from, Serializable[] data) {
        try {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this._packetHandler + " send presenceProbe to=" + to + " from=" + from);
            }
            this._out.writeObject((Object)new PresenceProbe(to, from, data));
            this._out.flush();
        }
        catch (IOException e) {
            this._packetHandler.close();
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void sendPresenceSubscribe(String to, String from, Serializable[] data) {
        try {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this._packetHandler + " send presenceSubscribe to=" + to + " from=" + from);
            }
            this._out.writeObject((Object)new PresenceSubscribe(to, from, data));
            this._out.flush();
        }
        catch (IOException e) {
            this._packetHandler.close();
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void sendPresenceSubscribed(String to, String from, Serializable[] data) {
        try {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this._packetHandler + " send presenceSubscribed to=" + to + " from=" + from);
            }
            this._out.writeObject((Object)new PresenceSubscribed(to, from, data));
            this._out.flush();
        }
        catch (IOException e) {
            this._packetHandler.close();
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void sendPresenceUnsubscribe(String to, String from, Serializable[] data) {
        try {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this._packetHandler + " send presenceUnsubscribe to=" + to + " from=" + from);
            }
            this._out.writeObject((Object)new PresenceUnsubscribe(to, from, data));
            this._out.flush();
        }
        catch (IOException e) {
            this._packetHandler.close();
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void sendPresenceUnsubscribed(String to, String from, Serializable[] data) {
        try {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this._packetHandler + " send presenceUnsubscribed to=" + to + " from=" + from);
            }
            this._out.writeObject((Object)new PresenceUnsubscribed(to, from, data));
            this._out.flush();
        }
        catch (IOException e) {
            this._packetHandler.close();
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void sendPresenceError(String to, String from, Serializable[] data, HmtpError error) {
        try {
            if (log.isLoggable(Level.FINER)) {
                log.finer(this._packetHandler + " send presenceError to=" + to + " from=" + from);
            }
            this._out.writeObject((Object)new PresenceError(to, from, data, error));
            this._out.flush();
        }
        catch (IOException e) {
            this._packetHandler.close();
            log.log(Level.FINE, e.toString(), e);
        }
    }
}

