/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hemp.servlet;

import com.caucho.hemp.servlet.AuthBrokerStream;
import com.caucho.hemp.servlet.ServerAgentStream;
import com.caucho.hessian.io.Hessian2StreamingInput;
import com.caucho.hessian.io.Hessian2StreamingOutput;
import com.caucho.hessian.io.HessianDebugInputStream;
import com.caucho.hessian.io.HessianDebugOutputStream;
import com.caucho.hmtp.HmtpConnection;
import com.caucho.hmtp.HmtpError;
import com.caucho.hmtp.HmtpStream;
import com.caucho.hmtp.packet.Packet;
import com.caucho.hmtp.spi.HmtpBroker;
import com.caucho.server.connection.TcpConnectionController;
import com.caucho.server.connection.TcpConnectionHandler;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerBrokerStream
implements TcpConnectionHandler,
HmtpStream {
    private static final Logger log = Logger.getLogger(ServerBrokerStream.class.getName());
    private HmtpBroker _broker;
    private HmtpConnection _conn;
    private HmtpStream _toBroker;
    private Hessian2StreamingInput _in;
    private Hessian2StreamingOutput _out;
    private ServerAgentStream _callbackHandler;
    private AuthBrokerStream _authHandler;
    private String _jid;

    ServerBrokerStream(HmtpBroker broker, ReadStream rs, WriteStream ws) {
        this._broker = broker;
        ReadStream is = rs;
        WriteStream os = ws;
        if (log.isLoggable(Level.FINEST)) {
            os = new HessianDebugOutputStream((OutputStream)os, log, Level.FINEST);
            is = new HessianDebugInputStream((InputStream)is, log, Level.FINEST);
        }
        this._in = new Hessian2StreamingInput((InputStream)is);
        this._out = new Hessian2StreamingOutput((OutputStream)os);
        this._callbackHandler = new ServerAgentStream(this, this._out);
        this._authHandler = new AuthBrokerStream(this, this._callbackHandler);
    }

    protected String getJid() {
        return this._jid;
    }

    public boolean serviceRead(ReadStream is, TcpConnectionController controller) throws IOException {
        Hessian2StreamingInput in = this._in;
        if (in == null) {
            return false;
        }
        Object obj = in.readObject();
        Packet packet = (Packet)obj;
        if (packet == null) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " end of stream");
            }
            controller.close();
            return false;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " receive " + packet);
        }
        if (this._conn != null) {
            packet.dispatch(this, this._toBroker);
        } else {
            packet.dispatch(this._authHandler, this._toBroker);
        }
        return true;
    }

    public boolean serviceWrite(WriteStream os, TcpConnectionController controller) throws IOException {
        return false;
    }

    String login(String uid, Serializable credentials, String resource) {
        String password = (String)((Object)credentials);
        this._conn = this._broker.getConnection(uid, password);
        this._conn.setMessageHandler(this._callbackHandler);
        this._conn.setQueryHandler(this._callbackHandler);
        this._conn.setPresenceHandler(this._callbackHandler);
        this._jid = this._conn.getJid();
        this._toBroker = this._conn.getBrokerStream();
        return this._jid;
    }

    public void sendMessage(String to, String from, Serializable value) {
        this._toBroker.sendMessage(to, this._jid, value);
    }

    public void sendMessageError(String to, String from, Serializable value, HmtpError error) {
        this._toBroker.sendMessageError(to, this._jid, value, error);
    }

    public boolean sendQueryGet(long id, String to, String from, Serializable value) {
        this._toBroker.sendQueryGet(id, to, this._jid, value);
        return true;
    }

    public boolean sendQuerySet(long id, String to, String from, Serializable value) {
        this._toBroker.sendQuerySet(id, to, this._jid, value);
        return true;
    }

    public void sendQueryResult(long id, String to, String from, Serializable value) {
        this._toBroker.sendQueryResult(id, to, this._jid, value);
    }

    public void sendQueryError(long id, String to, String from, Serializable value, HmtpError error) {
        this._toBroker.sendQueryError(id, to, this._jid, value, error);
    }

    public void sendPresence(String to, String from, Serializable[] data) {
        this._toBroker.sendPresence(to, this._jid, data);
    }

    public void sendPresenceUnavailable(String to, String from, Serializable[] data) {
        this._toBroker.sendPresenceUnavailable(to, this._jid, data);
    }

    public void sendPresenceProbe(String to, String from, Serializable[] data) {
        this._toBroker.sendPresenceProbe(to, this._jid, data);
    }

    public void sendPresenceSubscribe(String to, String from, Serializable[] data) {
        this._toBroker.sendPresenceSubscribe(to, this._jid, data);
    }

    public void sendPresenceSubscribed(String to, String from, Serializable[] data) {
        this._toBroker.sendPresenceSubscribed(to, this._jid, data);
    }

    public void sendPresenceUnsubscribe(String to, String from, Serializable[] data) {
        this._toBroker.sendPresenceUnsubscribe(to, this._jid, data);
    }

    public void sendPresenceUnsubscribed(String to, String from, Serializable[] data) {
        this._toBroker.sendPresenceUnsubscribed(to, this._jid, data);
    }

    public void sendPresenceError(String to, String from, Serializable[] data, HmtpError error) {
        this._toBroker.sendPresenceError(to, this._jid, data, error);
    }

    public void close() {
        Hessian2StreamingInput in = this._in;
        this._in = null;
        Hessian2StreamingOutput out = this._out;
        this._out = null;
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (out != null) {
            try {
                out.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._conn + "]";
    }
}

