/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hmtp.client;

import com.caucho.hessian.io.Hessian2StreamingInput;
import com.caucho.hmtp.HmtpError;
import com.caucho.hmtp.HmtpMessageStream;
import com.caucho.hmtp.HmtpPresenceStream;
import com.caucho.hmtp.HmtpQueryStream;
import com.caucho.hmtp.HmtpStream;
import com.caucho.hmtp.client.HmtpClient;
import com.caucho.hmtp.packet.Packet;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

class ClientAgentStream
implements Runnable,
HmtpStream {
    private static final Logger log = Logger.getLogger(ClientAgentStream.class.getName());
    private static long _gId;
    private HmtpClient _client;
    private HmtpStream _clientStream;
    private ClassLoader _loader;
    private boolean _isFinest;

    ClientAgentStream(HmtpClient client) {
        this._client = client;
        this._clientStream = client.getBrokerStream();
        this._loader = Thread.currentThread().getContextClassLoader();
    }

    private void close() {
        this._client.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this._isFinest = log.isLoggable(Level.FINEST);
        Thread thread = Thread.currentThread();
        String oldName = thread.getName();
        try {
            try {
                thread.setName("hmpp-client-" + _gId++);
                thread.setContextClassLoader(this._loader);
                while (!this._client.isClosed()) {
                    this.readPacket();
                }
                Object var5_3 = null;
                this.close();
                thread.setName(oldName);
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
                Object var5_4 = null;
                this.close();
                thread.setName(oldName);
            }
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            this.close();
            thread.setName(oldName);
            throw throwable;
        }
    }

    private void readPacket() throws IOException {
        Hessian2StreamingInput in = this._client.getStreamingInput();
        if (in == null) {
            return;
        }
        Packet packet = (Packet)in.readObject();
        if (packet == null) {
            this.close();
            return;
        }
        if (log.isLoggable(Level.FINER)) {
            log.finer(this + " receive " + packet);
        }
        packet.dispatch(this, this._clientStream);
    }

    public void sendMessage(String to, String from, Serializable value) {
        HmtpMessageStream handler = this._client.getMessageHandler();
        if (handler != null) {
            handler.sendMessage(to, from, value);
        }
    }

    public void sendMessageError(String to, String from, Serializable value, HmtpError error) {
        HmtpMessageStream handler = this._client.getMessageHandler();
        if (handler != null) {
            handler.sendMessageError(to, from, value, error);
        } else if (log.isLoggable(Level.FINER)) {
            log.finer(this + " sendMessageError to=" + to + " from=" + from + " error=" + error);
        }
    }

    public boolean sendQueryGet(long id, String to, String from, Serializable value) {
        HmtpQueryStream handler = this._client.getQueryHandler();
        if (handler == null || !handler.sendQueryGet(id, to, from, value)) {
            String msg = "no sendQueryGet handling " + value.getClass().getName();
            HmtpError error = new HmtpError("unknown", msg);
            this._clientStream.sendQueryError(id, from, to, value, error);
        }
        return true;
    }

    public boolean sendQuerySet(long id, String to, String from, Serializable value) {
        HmtpQueryStream handler = this._client.getQueryHandler();
        if (handler == null || !handler.sendQuerySet(id, to, from, value)) {
            String msg = "no sendQuerySet handling " + value.getClass().getName();
            HmtpError error = new HmtpError("unknown", msg);
            this._clientStream.sendQueryError(id, from, to, value, error);
        }
        return true;
    }

    public void sendQueryResult(long id, String to, String from, Serializable value) {
        this._client.onQueryResult(id, to, from, value);
    }

    public void sendQueryError(long id, String to, String from, Serializable value, HmtpError error) {
        this._client.onQueryError(id, to, from, value, error);
    }

    public void sendPresence(String to, String from, Serializable[] data) {
        HmtpPresenceStream handler = this._client.getPresenceHandler();
        if (handler != null) {
            handler.sendPresence(to, from, data);
        }
    }

    public void sendPresenceUnavailable(String to, String from, Serializable[] data) {
        HmtpPresenceStream handler = this._client.getPresenceHandler();
        if (handler != null) {
            handler.sendPresenceUnavailable(to, from, data);
        }
    }

    public void sendPresenceProbe(String to, String from, Serializable[] data) {
        HmtpPresenceStream handler = this._client.getPresenceHandler();
        if (handler != null) {
            handler.sendPresenceProbe(to, from, data);
        }
    }

    public void sendPresenceSubscribe(String to, String from, Serializable[] data) {
        HmtpPresenceStream handler = this._client.getPresenceHandler();
        if (handler != null) {
            handler.sendPresenceSubscribe(to, from, data);
        }
    }

    public void sendPresenceSubscribed(String to, String from, Serializable[] data) {
        HmtpPresenceStream handler = this._client.getPresenceHandler();
        if (handler != null) {
            handler.sendPresenceSubscribed(to, from, data);
        }
    }

    public void sendPresenceUnsubscribe(String to, String from, Serializable[] data) {
        HmtpPresenceStream handler = this._client.getPresenceHandler();
        if (handler != null) {
            handler.sendPresenceUnsubscribe(to, from, data);
        }
    }

    public void sendPresenceUnsubscribed(String to, String from, Serializable[] data) {
        HmtpPresenceStream handler = this._client.getPresenceHandler();
        if (handler != null) {
            handler.sendPresenceUnsubscribed(to, from, data);
        }
    }

    public void sendPresenceError(String to, String from, Serializable[] data, HmtpError error) {
        HmtpPresenceStream handler = this._client.getPresenceHandler();
        if (handler != null) {
            handler.sendPresenceError(to, from, data, error);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

