/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hmtp.client;

import com.caucho.hessian.io.Hessian2StreamingInput;
import com.caucho.hessian.io.Hessian2StreamingOutput;
import com.caucho.hessian.io.HessianDebugInputStream;
import com.caucho.hessian.io.HessianDebugOutputStream;
import com.caucho.hmtp.HmtpError;
import com.caucho.hmtp.HmtpProtocolException;
import com.caucho.hmtp.HmtpStream;
import com.caucho.hmtp.packet.Message;
import com.caucho.hmtp.packet.MessageError;
import com.caucho.hmtp.packet.Presence;
import com.caucho.hmtp.packet.PresenceError;
import com.caucho.hmtp.packet.PresenceProbe;
import com.caucho.hmtp.packet.PresenceSubscribe;
import com.caucho.hmtp.packet.PresenceSubscribed;
import com.caucho.hmtp.packet.PresenceUnavailable;
import com.caucho.hmtp.packet.PresenceUnsubscribe;
import com.caucho.hmtp.packet.PresenceUnsubscribed;
import com.caucho.hmtp.packet.QueryError;
import com.caucho.hmtp.packet.QueryGet;
import com.caucho.hmtp.packet.QueryResult;
import com.caucho.hmtp.packet.QuerySet;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ClientBrokerStream
implements HmtpStream {
    private static final Logger log = Logger.getLogger(ClientBrokerStream.class.getName());
    private InputStream _is;
    private OutputStream _os;
    private Hessian2StreamingInput _in;
    private Hessian2StreamingOutput _out;
    private boolean _isFinest;

    public ClientBrokerStream(InputStream is, OutputStream os) {
        this._is = is;
        this._os = os;
        this._isFinest = log.isLoggable(Level.FINEST);
        if (log.isLoggable(Level.FINEST)) {
            this._os = new HessianDebugOutputStream(this._os, log, Level.FINEST);
            this._is = new HessianDebugInputStream(this._is, log, Level.FINEST);
        }
        this._out = new Hessian2StreamingOutput(this._os);
        this._in = new Hessian2StreamingInput(this._is);
    }

    Hessian2StreamingInput getStreamingInput() {
        return this._in;
    }

    public void sendMessage(String to, String from, Serializable value) {
        try {
            Hessian2StreamingOutput out = this._out;
            if (out != null) {
                out.writeObject((Object)new Message(to, from, value));
                out.flush();
            }
        }
        catch (IOException e) {
            throw new HmtpProtocolException(e);
        }
    }

    public void sendMessageError(String to, String from, Serializable value, HmtpError error) {
        try {
            Hessian2StreamingOutput out = this._out;
            if (out != null) {
                out.writeObject((Object)new MessageError(to, from, value, error));
                out.flush();
            }
        }
        catch (IOException e) {
            throw new HmtpProtocolException(e);
        }
    }

    public boolean sendQueryGet(long id, String to, String from, Serializable value) {
        try {
            Hessian2StreamingOutput out = this._out;
            if (out != null) {
                out.writeObject((Object)new QueryGet(id, to, from, value));
                out.flush();
            }
            return true;
        }
        catch (IOException e) {
            throw new HmtpProtocolException(e);
        }
    }

    public boolean sendQuerySet(long id, String to, String from, Serializable value) {
        try {
            Hessian2StreamingOutput out = this._out;
            if (out != null) {
                out.writeObject((Object)new QuerySet(id, to, from, value));
                out.flush();
            }
            return true;
        }
        catch (IOException e) {
            throw new HmtpProtocolException(e);
        }
    }

    public void sendQueryResult(long id, String to, String from, Serializable value) {
        try {
            Hessian2StreamingOutput out = this._out;
            if (out != null) {
                out.writeObject((Object)new QueryResult(id, to, from, value));
                out.flush();
            }
        }
        catch (IOException e) {
            throw new HmtpProtocolException(e);
        }
    }

    public void sendQueryError(long id, String to, String from, Serializable value, HmtpError error) {
        try {
            Hessian2StreamingOutput out = this._out;
            if (out != null) {
                out.writeObject((Object)new QueryError(id, to, from, value, error));
                out.flush();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void sendPresence(String to, String from, Serializable[] data) {
        try {
            Hessian2StreamingOutput out = this._out;
            if (out != null) {
                out.writeObject((Object)new Presence(to, from, data));
                out.flush();
            }
        }
        catch (IOException e) {
            throw new HmtpProtocolException(e);
        }
    }

    public void sendPresenceUnavailable(String to, String from, Serializable[] data) {
        try {
            Hessian2StreamingOutput out = this._out;
            if (out != null) {
                out.writeObject((Object)new PresenceUnavailable(to, from, data));
                out.flush();
            }
        }
        catch (IOException e) {
            throw new HmtpProtocolException(e);
        }
    }

    public void sendPresenceProbe(String to, String from, Serializable[] data) {
        try {
            Hessian2StreamingOutput out = this._out;
            if (out != null) {
                out.writeObject((Object)new PresenceProbe(to, from, data));
                out.flush();
            }
        }
        catch (IOException e) {
            throw new HmtpProtocolException(e);
        }
    }

    public void sendPresenceSubscribe(String to, String from, Serializable[] data) {
        try {
            Hessian2StreamingOutput out = this._out;
            if (out != null) {
                out.writeObject((Object)new PresenceSubscribe(to, from, data));
                out.flush();
            }
        }
        catch (IOException e) {
            throw new HmtpProtocolException(e);
        }
    }

    public void sendPresenceSubscribed(String to, String from, Serializable[] data) {
        try {
            Hessian2StreamingOutput out = this._out;
            if (out != null) {
                out.writeObject((Object)new PresenceSubscribed(to, from, data));
                out.flush();
            }
        }
        catch (IOException e) {
            throw new HmtpProtocolException(e);
        }
    }

    public void sendPresenceUnsubscribe(String to, String from, Serializable[] data) {
        try {
            Hessian2StreamingOutput out = this._out;
            if (out != null) {
                out.writeObject((Object)new PresenceUnsubscribe(to, from, data));
                out.flush();
            }
        }
        catch (IOException e) {
            throw new HmtpProtocolException(e);
        }
    }

    public void sendPresenceUnsubscribed(String to, String from, Serializable[] data) {
        try {
            Hessian2StreamingOutput out = this._out;
            if (out != null) {
                out.writeObject((Object)new PresenceUnsubscribed(to, from, data));
                out.flush();
            }
        }
        catch (IOException e) {
            throw new HmtpProtocolException(e);
        }
    }

    public void sendPresenceError(String to, String from, Serializable[] data, HmtpError error) {
        try {
            Hessian2StreamingOutput out = this._out;
            if (out != null) {
                out.writeObject((Object)new PresenceError(to, from, data, error));
                out.flush();
            }
        }
        catch (IOException e) {
            throw new HmtpProtocolException(e);
        }
    }

    public void flush() throws IOException {
        Hessian2StreamingOutput out = this._out;
        if (out != null) {
            out.flush();
        }
    }

    public boolean isClosed() {
        return this._is == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " close");
        }
        try {
            OutputStream os;
            InputStream is;
            ClientBrokerStream clientBrokerStream = this;
            synchronized (clientBrokerStream) {
                is = this._is;
                this._is = null;
                this._in = null;
                os = this._os;
                this._os = null;
                this._out = null;
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (is != null) {
                is.close();
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

