/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hmtp.client;

import com.caucho.hessian.io.Hessian2StreamingInput;
import com.caucho.hmtp.HmtpConnection;
import com.caucho.hmtp.HmtpError;
import com.caucho.hmtp.HmtpMessageStream;
import com.caucho.hmtp.HmtpPresenceStream;
import com.caucho.hmtp.HmtpQueryCallback;
import com.caucho.hmtp.HmtpQueryStream;
import com.caucho.hmtp.HmtpStream;
import com.caucho.hmtp.auth.AuthQuery;
import com.caucho.hmtp.auth.AuthResult;
import com.caucho.hmtp.client.ClientAgentStream;
import com.caucho.hmtp.client.ClientBrokerStream;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.Socket;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;

public class HmtpClient
implements HmtpConnection {
    private static final Logger log = Logger.getLogger(HmtpClient.class.getName());
    private String _url;
    private String _scheme;
    private String _host;
    private int _port;
    private String _path;
    private InetAddress _address;
    private String _to;
    protected Socket _s;
    protected InputStream _is;
    protected OutputStream _os;
    private ClientBrokerStream _clientStream;
    private String _jid;
    private HmtpMessageStream _messageHandler;
    private HmtpQueryStream _queryHandler;
    private HmtpPresenceStream _presenceHandler;
    private HashMap<Long, QueryItem> _queryMap = new HashMap();
    private long _qId;
    private boolean _isFinest;

    public HmtpClient(String url) {
        this._url = url;
        this.parseURL(url);
        this._isFinest = log.isLoggable(Level.FINEST);
    }

    protected void parseURL(String url) {
        int p = url.indexOf("://");
        if (p < 0) {
            throw new IllegalArgumentException("URL '" + url + "' is not well-formed");
        }
        this._scheme = url.substring(0, p);
        if ((p = (url = url.substring(p + 3)).indexOf("/")) >= 0) {
            this._path = url.substring(p);
            url = url.substring(0, p);
        } else {
            this._path = "/";
        }
        p = url.indexOf(58);
        if (p > 0) {
            this._host = url.substring(0, p);
            this._port = Integer.parseInt(url.substring(p + 1));
        } else {
            this._host = url;
            this._port = "https".equals(this._scheme) ? 443 : 80;
        }
    }

    public String getHost() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public void connect() throws IOException {
        if (this._s != null) {
            throw new IllegalStateException(this + " is already connected");
        }
        this.openSocket(this._host, this._port);
        this.print(this._os, "POST " + this._path + " HTTP/1.1\r\n");
        this.print(this._os, "Host: " + this._to + ":" + this._port + "\r\n");
        this.print(this._os, "Upgrade: HMTP/0.9\r\n");
        this.print(this._os, "Content-Length: 0\r\n");
        this.print(this._os, "\r\n");
        this._os.flush();
        String result = this.readLine(this._is);
        if (result.startsWith("HTTP/1.1 101")) {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " " + result);
            }
            while (!(result = this.readLine(this._is)).trim().equals("")) {
                if (!log.isLoggable(Level.FINE)) continue;
                log.fine(this + " " + result);
            }
        } else {
            if (log.isLoggable(Level.FINE)) {
                log.fine(this + " " + result);
            }
            throw new IOException("Unexpected result: " + result);
        }
        this._clientStream = new ClientBrokerStream(this._is, this._os);
        this.executeThread(new ClientAgentStream(this));
    }

    protected void executeThread(Runnable r) {
        Thread thread = new Thread(r);
        thread.setDaemon(true);
        thread.start();
    }

    protected void openSocket(String host, int port) throws IOException {
        this._s = new Socket(this._host, this._port);
        InputStream is = this._s.getInputStream();
        OutputStream os = this._s.getOutputStream();
        this._os = new BufferedOutputStream(os);
        this._is = new BufferedInputStream(is);
    }

    protected void print(OutputStream os, String s) throws IOException {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            os.write(s.charAt(i));
        }
    }

    protected String readLine(InputStream is) throws IOException {
        int ch;
        StringBuilder sb = new StringBuilder();
        while ((ch = is.read()) >= 0 && ch != 10) {
            sb.append((char)ch);
        }
        return sb.toString();
    }

    public void login(String uid, String password) {
        try {
            AuthResult result = (AuthResult)this.querySet("", new AuthQuery(uid, (Serializable)((Object)password)));
            this._jid = result.getJid();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    Hessian2StreamingInput getStreamingInput() {
        return this._clientStream.getStreamingInput();
    }

    public String getJid() {
        return this._jid;
    }

    public void setMessageHandler(HmtpMessageStream listener) {
        this._messageHandler = listener;
    }

    public HmtpMessageStream getMessageHandler() {
        return this._messageHandler;
    }

    public void setPresenceHandler(HmtpPresenceStream handler) {
        this._presenceHandler = handler;
    }

    public HmtpPresenceStream getPresenceHandler() {
        return this._presenceHandler;
    }

    public HmtpStream getBrokerStream() {
        return this._clientStream;
    }

    public void sendMessage(String to, Serializable value) {
        ClientBrokerStream stream = this._clientStream;
        if (stream == null) {
            throw new IllegalStateException("connection is closed");
        }
        stream.sendMessage(to, null, value);
    }

    public void presence(Serializable[] data) {
        ClientBrokerStream stream = this._clientStream;
        if (stream == null) {
            throw new IllegalStateException("connection is closed");
        }
        this._clientStream.sendPresence(null, null, data);
    }

    public void presence(String to, Serializable[] data) {
        ClientBrokerStream stream = this._clientStream;
        if (stream == null) {
            throw new IllegalStateException("connection is closed");
        }
        this._clientStream.sendPresence(to, null, data);
    }

    public void presenceUnavailable(Serializable[] data) {
        ClientBrokerStream stream = this._clientStream;
        if (stream == null) {
            throw new IllegalStateException("connection is closed");
        }
        this._clientStream.sendPresenceUnavailable(null, null, data);
    }

    public void presenceUnavailable(String to, Serializable[] data) {
        ClientBrokerStream stream = this._clientStream;
        if (stream == null) {
            throw new IllegalStateException("connection is closed");
        }
        this._clientStream.sendPresenceUnavailable(to, null, data);
    }

    public void presenceProbe(String to, Serializable[] data) {
        ClientBrokerStream stream = this._clientStream;
        if (stream == null) {
            throw new IllegalStateException("connection is closed");
        }
        this._clientStream.sendPresenceProbe(to, null, data);
    }

    public void presenceSubscribe(String to, Serializable[] data) {
        ClientBrokerStream stream = this._clientStream;
        if (stream == null) {
            throw new IllegalStateException("connection is closed");
        }
        this._clientStream.sendPresenceSubscribe(to, null, data);
    }

    public void presenceSubscribed(String to, Serializable[] data) {
        ClientBrokerStream stream = this._clientStream;
        if (stream == null) {
            throw new IllegalStateException("connection is closed");
        }
        this._clientStream.sendPresenceSubscribed(to, null, data);
    }

    public void presenceUnsubscribe(String to, Serializable[] data) {
        ClientBrokerStream stream = this._clientStream;
        if (stream == null) {
            throw new IllegalStateException("connection is closed");
        }
        this._clientStream.sendPresenceUnsubscribe(to, null, data);
    }

    public void presenceUnsubscribed(String to, Serializable[] data) {
        ClientBrokerStream stream = this._clientStream;
        if (stream == null) {
            throw new IllegalStateException("connection is closed");
        }
        this._clientStream.sendPresenceUnsubscribed(to, null, data);
    }

    public void presenceError(String to, Serializable[] data, HmtpError error) {
        ClientBrokerStream stream = this._clientStream;
        if (stream == null) {
            throw new IllegalStateException("connection is closed");
        }
        this._clientStream.sendPresenceError(to, null, data, error);
    }

    public void setQueryHandler(HmtpQueryStream handler) {
        this._queryHandler = handler;
    }

    public HmtpQueryStream getQueryHandler() {
        return this._queryHandler;
    }

    public Serializable queryGet(String to, Serializable query) {
        WaitQueryCallback callback = new WaitQueryCallback();
        this.queryGet(to, query, callback);
        if (callback.waitFor()) {
            return callback.getResult();
        }
        throw new RuntimeException(String.valueOf(callback.getError()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void queryGet(String to, Serializable value, HmtpQueryCallback callback) {
        long id;
        HmtpClient hmtpClient = this;
        synchronized (hmtpClient) {
            id = this._qId++;
            this._queryMap.put(id, new QueryItem(id, callback));
        }
        ClientBrokerStream stream = this._clientStream;
        if (stream == null) {
            throw new IllegalStateException("connection is closed");
        }
        this._clientStream.sendQueryGet(id, to, null, value);
    }

    public Serializable querySet(String to, Serializable query) {
        WaitQueryCallback callback = new WaitQueryCallback();
        this.querySet(to, query, callback);
        if (callback.waitFor()) {
            return callback.getResult();
        }
        throw new RuntimeException(String.valueOf(callback.getError()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void querySet(String to, Serializable value, HmtpQueryCallback callback) {
        long id;
        HmtpClient hmtpClient = this;
        synchronized (hmtpClient) {
            id = this._qId++;
            this._queryMap.put(id, new QueryItem(id, callback));
        }
        ClientBrokerStream stream = this._clientStream;
        if (stream == null) {
            throw new IllegalStateException("connection is closed");
        }
        stream.sendQuerySet(id, to, null, value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onQueryResult(long id, String to, String from, Serializable value) {
        QueryItem item = null;
        HmtpClient hmtpClient = this;
        synchronized (hmtpClient) {
            item = this._queryMap.remove(id);
        }
        if (item != null) {
            item.onQueryResult(to, from, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onQueryError(long id, String to, String from, Serializable value, HmtpError error) {
        QueryItem item = null;
        HmtpClient hmtpClient = this;
        synchronized (hmtpClient) {
            item = this._queryMap.remove(id);
        }
        if (item != null) {
            item.onQueryError(to, from, value, error);
        }
    }

    public void flush() throws IOException {
        ClientBrokerStream stream = this._clientStream;
        if (stream != null) {
            stream.flush();
        }
    }

    public boolean isClosed() {
        return this._clientStream == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        if (log.isLoggable(Level.FINE)) {
            log.fine(this + " close");
        }
        try {
            OutputStream os;
            ClientBrokerStream stream;
            InputStream is;
            Socket s;
            HmtpClient hmtpClient = this;
            synchronized (hmtpClient) {
                s = this._s;
                this._s = null;
                is = this._is;
                this._is = null;
                stream = this._clientStream;
                this._clientStream = null;
                os = this._os;
                this._os = null;
            }
            if (stream != null) {
                stream.close();
            }
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (is != null) {
                is.close();
            }
            if (s != null) {
                s.close();
            }
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._jid + "," + this._url + "]";
    }

    protected void finalize() {
        this.close();
    }

    static class WaitQueryCallback
    implements HmtpQueryCallback {
        private Serializable _result;
        private HmtpError _error;
        private boolean _isResult;

        WaitQueryCallback() {
        }

        public Serializable getResult() {
            return this._result;
        }

        public HmtpError getError() {
            return this._error;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        boolean waitFor() {
            try {
                WaitQueryCallback waitQueryCallback = this;
                synchronized (waitQueryCallback) {
                    if (!this._isResult) {
                        this.wait(10000L);
                    }
                }
            }
            catch (Exception e) {
                log.log(Level.FINE, e.toString(), e);
            }
            return this._isResult;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onQueryResult(String fromJid, String toJid, Serializable value) {
            this._result = value;
            WaitQueryCallback waitQueryCallback = this;
            synchronized (waitQueryCallback) {
                this._isResult = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onQueryError(String fromJid, String toJid, Serializable value, HmtpError error) {
            this._error = error;
            WaitQueryCallback waitQueryCallback = this;
            synchronized (waitQueryCallback) {
                this._isResult = true;
                this.notifyAll();
            }
        }
    }

    static class QueryItem {
        private final long _id;
        private final HmtpQueryCallback _callback;

        QueryItem(long id, HmtpQueryCallback callback) {
            this._id = id;
            this._callback = callback;
        }

        void onQueryResult(String to, String from, Serializable value) {
            if (this._callback != null) {
                this._callback.onQueryResult(to, from, value);
            }
        }

        void onQueryError(String to, String from, Serializable value, HmtpError error) {
            if (this._callback != null) {
                this._callback.onQueryError(to, from, value, error);
            }
        }

        public String toString() {
            return this.getClass().getSimpleName() + "[" + this._id + "," + this._callback + "]";
        }
    }
}

