/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hmtp.packet;

import com.caucho.hmtp.HmtpError;
import com.caucho.hmtp.HmtpStream;
import com.caucho.hmtp.packet.Packet;
import java.io.Serializable;

public class QueryGet
extends Packet {
    private final long _id;
    private final Serializable _value;

    private QueryGet() {
        this._id = 0L;
        this._value = null;
    }

    public QueryGet(long id, String to, Serializable value) {
        super(to);
        this._id = id;
        this._value = value;
    }

    public QueryGet(long id, String to, String from, Serializable value) {
        super(to, from);
        this._id = id;
        this._value = value;
    }

    public long getId() {
        return this._id;
    }

    public Serializable getValue() {
        return this._value;
    }

    public void dispatch(HmtpStream handler, HmtpStream toSource) {
        if (!handler.sendQueryGet(this.getId(), this.getTo(), this.getFrom(), this.getValue())) {
            toSource.sendQueryError(this.getId(), this.getFrom(), this.getTo(), this.getValue(), new HmtpError("cancel", "item-not-found"));
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[");
        sb.append("id=");
        sb.append(this._id);
        if (this.getTo() != null) {
            sb.append(",to=");
            sb.append(this.getTo());
        }
        if (this.getFrom() != null) {
            sb.append(",from=");
            sb.append(this.getFrom());
        }
        if (this._value != null) {
            sb.append("," + this._value.getClass().getName());
        }
        sb.append("]");
        return sb.toString();
    }
}

