/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.iiop;

import com.caucho.iiop.IiopProtocol;
import com.caucho.iiop.IiopSkeleton;
import com.caucho.log.Log;
import com.caucho.naming.AbstractModel;
import com.caucho.naming.MemoryModel;
import java.rmi.NoSuchObjectException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.NamingException;
import org.omg.CORBA.Object;
import org.omg.CosNaming.NameComponent;
import org.omg.CosNaming.NamingContextPackage.CannotProceed;
import org.omg.CosNaming.NamingContextPackage.InvalidName;
import org.omg.CosNaming.NamingContextPackage.NotFound;
import org.omg.CosNaming.NamingContextPackage.NotFoundReason;

public class CosServer {
    private static final Logger log = Log.open(CosServer.class);
    private IiopProtocol _iiopServer;
    private String _host;
    private int _port;
    AbstractModel _model = new MemoryModel();

    CosServer(IiopProtocol iiopServer) {
        this._iiopServer = iiopServer;
    }

    void setHost(String host) {
        this._host = host;
    }

    void setPort(int port) {
        this._port = port;
    }

    public Object resolve(NameComponent[] n) throws NotFound, CannotProceed, InvalidName {
        java.lang.Object value = null;
        String host = this._host;
        String uri = "";
        try {
            if (log.isLoggable(Level.FINE)) {
                String name = "";
                for (int i = 0; i < n.length; ++i) {
                    name = name + "/" + n[i].id;
                }
                log.fine("IIOP NameService lookup: " + name);
            }
            for (int i = 0; i < n.length; ++i) {
                String name = n[i].id;
                String type = n[i].kind;
                value = this._model.lookup(name);
                if (value != null) continue;
                uri = uri + "/" + name;
            }
            if (value == null) {
                if (uri.equals("")) {
                    String oid = "/NameService";
                    IiopSkeleton skel = this._iiopServer.getService(this._host, this._port, oid);
                    return skel;
                }
                IiopSkeleton skel = this._iiopServer.getService(this._host, this._port, uri);
                if (skel != null) {
                    return skel;
                }
            }
        }
        catch (NamingException e) {
            log.log(Level.FINE, e.toString(), e);
            throw new NotFound(NotFoundReason.from_int((int)0), n);
        }
        catch (NoSuchObjectException e) {
            log.log(Level.FINE, e.toString(), e);
            throw new NotFound(NotFoundReason.from_int((int)0), n);
        }
        log.fine("IIOP COS NotFound: " + uri);
        throw new NotFound(NotFoundReason.from_int((int)0), n);
    }
}

