/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.iiop;

import com.caucho.iiop.IiopWriter;
import com.caucho.iiop.MessageWriter;
import com.caucho.vfs.TempBuffer;

public class EncapsulationMessageWriter
extends MessageWriter {
    private TempBuffer _head;
    private TempBuffer _tail;
    private byte[] _buffer;
    private int _offset;
    private int _length;

    public EncapsulationMessageWriter() {
        this._head = this._tail = TempBuffer.allocate();
        this._buffer = this._head.getBuffer();
    }

    public int getOffset() {
        return this._offset;
    }

    public void write(int v) {
        if (this._buffer.length <= this._length) {
            this.flushBuffer();
        }
        ++this._offset;
        this._buffer[this._length++] = (byte)v;
    }

    public void write(byte[] buffer, int offset, int length) {
        while (length > 0) {
            int sublen = this._buffer.length - this._length;
            if (length < sublen) {
                sublen = length;
            }
            System.arraycopy(buffer, offset, this._buffer, this._length, sublen);
            this._offset += sublen;
            this._length += sublen;
            if ((length -= sublen) <= 0) continue;
            this.flushBuffer();
        }
    }

    public final void writeShort(int v) {
        if (this._buffer.length <= this._length + 1) {
            this.flushBuffer();
        }
        this._offset += 2;
        this._buffer[this._length++] = (byte)(v >> 8);
        this._buffer[this._length++] = (byte)v;
    }

    public void writeInt(int v) {
        if (this._buffer.length <= this._length + 3) {
            this.flushBuffer();
        }
        this._offset += 4;
        this._buffer[this._length++] = (byte)(v >> 24);
        this._buffer[this._length++] = (byte)(v >> 16);
        this._buffer[this._length++] = (byte)(v >> 8);
        this._buffer[this._length++] = (byte)v;
    }

    public void align(int v) {
        int delta = v - this._length % v;
        if (delta == v) {
            return;
        }
        this._offset += delta;
        while (delta > 0) {
            this._buffer[this._length++] = 0;
            --delta;
        }
    }

    private void flushBuffer() {
        this._tail.setLength(this._length);
        TempBuffer tail = TempBuffer.allocate();
        this._tail.setNext(tail);
        this._tail = tail;
        this._buffer = this._tail.getBuffer();
        this._length = 0;
    }

    public void close() {
        this._tail.setLength(this._length);
        this._tail = null;
    }

    public void writeToWriter(IiopWriter out) {
        TempBuffer ptr = this._head;
        int fullLen = 0;
        while (ptr != null) {
            TempBuffer next = ptr.getNext();
            int len = ptr.getLength();
            byte[] buffer = ptr.getBuffer();
            out.write(buffer, 0, len);
            fullLen += len;
            TempBuffer.free((TempBuffer)ptr);
            ptr = next;
        }
    }
}

