/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.iiop;

import com.caucho.ejb.AbstractEJBObject;
import com.caucho.ejb.AbstractServer;
import com.caucho.iiop.CosServer;
import com.caucho.iiop.IiopContext;
import com.caucho.iiop.IiopRemoteService;
import com.caucho.iiop.IiopRequest;
import com.caucho.iiop.IiopSkeleton;
import com.caucho.iiop.orb.ORBImpl;
import com.caucho.management.j2ee.J2EEManagedObject;
import com.caucho.management.j2ee.RMI_IIOPResource;
import com.caucho.naming.Jndi;
import com.caucho.server.connection.Connection;
import com.caucho.server.port.Protocol;
import com.caucho.server.port.ServerRequest;
import java.lang.reflect.Method;
import java.rmi.NoSuchObjectException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.naming.NamingException;

public class IiopProtocol
extends Protocol {
    private static final Logger log = Logger.getLogger(IiopProtocol.class.getName());
    static final String COPYRIGHT = "Copyright (c) 1998-2008 Caucho Technology.  All rights reserved.";
    private String _protocolName = "iiop";
    private ORBImpl _orb = new ORBImpl();
    private boolean _isOrbInit;
    private CosServer _cos;
    private IiopContext _iiopContext = new IiopContext();

    public IiopProtocol() {
        try {
            Jndi.rebindDeep("java:comp/ORB", (Object)this._orb);
        }
        catch (NamingException e) {
            log.log(Level.FINER, e.toString(), e);
        }
        this._cos = new CosServer(this);
        IiopContext.setLocalContext(this._iiopContext);
    }

    public String getProtocolName() {
        return this._protocolName;
    }

    public void setProtocolName(String name) {
        this._protocolName = name;
    }

    @PostConstruct
    public void init() {
        J2EEManagedObject.register(new RMI_IIOPResource(this));
    }

    public CosServer getCos() {
        return this._cos;
    }

    public IiopSkeleton getService(String host, int port, String oid) throws NoSuchObjectException {
        return this.lookupService(host, port, oid);
    }

    ORBImpl getOrb(String host, int port) {
        if (!this._isOrbInit) {
            this._isOrbInit = true;
            this._orb.setHost(host);
            this._orb.setPort(port);
        }
        return this._orb;
    }

    private IiopSkeleton lookupService(String host, int port, String oid) throws NoSuchObjectException {
        String local;
        String url;
        int p = oid.indexOf(63);
        if (p < 0) {
            url = oid;
            local = null;
        } else {
            url = oid.substring(0, p);
            local = oid.substring(p + 1);
        }
        IiopRemoteService service = this._iiopContext.getService(url);
        if (service == null) {
            return null;
        }
        if (local == null) {
            ArrayList<Class> apiList = service.getHomeAPI();
            Object obj = service.getHome();
            if (obj == null) {
                throw new IllegalStateException(service + " does not have a valid EJB home interface");
            }
            if (service.getRemoteInterface() != null) {
                apiList.clear();
                apiList.add(service.getRemoteInterface());
                for (Method method : obj.getClass().getDeclaredMethods()) {
                    try {
                        if (!method.getName().startsWith("create")) continue;
                        obj = method.invoke(obj, null);
                    }
                    catch (Exception e) {
                        log.config("Remote home " + obj.getClass().getName() + " has no create method");
                    }
                }
            }
            if (obj instanceof AbstractEJBObject) {
                AbstractEJBObject ejb = (AbstractEJBObject)obj;
                AbstractServer server = ejb.__caucho_getServer();
                local = ejb.__caucho_getId();
                url = url + "?" + local;
            }
            return new IiopSkeleton(obj, apiList, service.getClassLoader(), host, port, url);
        }
        Object obj = service.getObject(local);
        if (obj == null) {
            return null;
        }
        ArrayList<Class> apiList = service.getObjectAPI();
        if (service.getRemoteInterface() != null) {
            apiList.clear();
            apiList.add(service.getRemoteInterface());
            for (Method method : obj.getClass().getDeclaredMethods()) {
                try {
                    if (!method.getName().startsWith("create")) continue;
                    obj = method.invoke(obj, null);
                }
                catch (Exception e) {
                    log.config("Remote home " + obj.getClass().getName() + " has no create method");
                }
            }
        }
        return new IiopSkeleton(obj, apiList, service.getClassLoader(), host, port, url + '?' + local);
    }

    public ServerRequest createRequest(Connection conn) {
        return new IiopRequest(this, conn);
    }
}

