/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.iiop;

import com.caucho.iiop.DummyObjectImpl;
import com.caucho.iiop.IOR;
import com.caucho.iiop.InputStreamMessageReader;
import com.caucho.iiop.MessageReader;
import com.caucho.iiop.ReaderContext;
import com.caucho.iiop.RemoteUserException;
import com.caucho.iiop.any.AbstractInterfaceTypeCode;
import com.caucho.iiop.any.AnyImpl;
import com.caucho.iiop.any.BooleanTypeCode;
import com.caucho.iiop.any.DoubleTypeCode;
import com.caucho.iiop.any.FloatTypeCode;
import com.caucho.iiop.any.LongLongTypeCode;
import com.caucho.iiop.any.LongTypeCode;
import com.caucho.iiop.any.OctetTypeCode;
import com.caucho.iiop.any.SequenceTypeCode;
import com.caucho.iiop.any.ShortTypeCode;
import com.caucho.iiop.any.TypeCodeImpl;
import com.caucho.iiop.any.ValueBoxTypeCode;
import com.caucho.iiop.any.ValueTypeCode;
import com.caucho.iiop.any.WcharTypeCode;
import com.caucho.iiop.orb.IiopSocketPool;
import com.caucho.iiop.orb.ORBImpl;
import com.caucho.iiop.orb.StubImpl;
import com.caucho.server.util.CauchoSystem;
import com.caucho.transaction.XidImpl;
import com.caucho.util.ByteBuffer;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.ReadWritePair;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.logging.Logger;
import javax.rmi.CORBA.Util;
import javax.rmi.CORBA.ValueHandler;
import org.omg.CORBA.Any;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.IndirectionException;
import org.omg.SendingContext.RunTime;

public class IiopReader
extends org.omg.CORBA_2_3.portable.InputStream {
    protected static final L10N L = new L10N(IiopReader.class);
    protected static final Logger log = Logger.getLogger(IiopReader.class.getName());
    public static final int MSG_REQUEST = 0;
    public static final int MSG_REPLY = 1;
    public static final int MSG_CANCEL_REQUEST = 2;
    public static final int MSG_LOCATE_REQUEST = 3;
    public static final int MSG_LOCATE_REPLY = 4;
    public static final int MSG_CLOSE_CONNECTION = 5;
    public static final int MSG_ERROR = 6;
    public static final int MSG_FRAGMENT = 7;
    public static final int SERVICE_TRANSACTION = 0;
    public static final int SERVICE_CODE_SET = 1;
    public static final int SERVICE_CHAIN_BYPASS_CHECK = 2;
    public static final int SERVICE_CHAIN_BYPASS_INFO = 3;
    public static final int SERVICE_LOGICAL_THREAD_ID = 4;
    public static final int SERVICE_BI_DIR_IIOP = 5;
    public static final int SERVICE_SENDING_CONTEXT_RUN_TIME = 6;
    public static final int SERVICE_INVOCATION_POLICIES = 7;
    public static final int SERVICE_FORWARDED_IDENTITY = 8;
    public static final int SERVICE_UNKNOWN_EXCEPTION_INFO = 9;
    public static final int SERVICE_RT_CORBA_PRIORITY = 10;
    public static final int SERVICE_RT_CORBA_PRIORITY_RANGE = 11;
    public static final int SERVICE_FT_GROUP_VERSION = 12;
    public static final int SERVICE_FT_REQUEST = 13;
    public static final int SERVICE_EXCEPTION_DETAIL_MESSAGE = 14;
    public static final int SERVICE_SECURITY_ATTRIBUTE_SERVICE = 15;
    public static final int SERVICE_ACTIVITY_SERVICE = 16;
    public static final int SERVICE_RMI_CUSTOM_MAX_STREAM_FORMAT = 17;
    public static final int STATUS_NO_EXCEPTION = 0;
    public static final int STATUS_USER_EXCEPTION = 1;
    public static final int STATUS_SYSTEM_EXCEPTION = 2;
    public static final int STATUS_LOCATION_FORWARD = 3;
    private IiopSocketPool _pool;
    private ReadWritePair _pair;
    private ReadStream _rs;
    private byte[] _header = new byte[8];
    private byte[] buf = new byte[16];
    private ReaderContext _context;
    private MessageReader _in;
    private int _major;
    private int _minor;
    private boolean _isBigEndian;
    private boolean _hasMoreFragments;
    private int _flags;
    private int _type;
    private int _fragmentOffset;
    private int _chunkEnd = -1;
    private int _chunkDepth = 0;
    private int requestId;
    private boolean responseExpected;
    private ByteBuffer _objectKey = new ByteBuffer();
    private CharBuffer _operation = new CharBuffer();
    private ByteBuffer principal = new ByteBuffer();
    private XidImpl _xid;
    private char[] _cb = new char[256];
    private ValueHandler _valueHandler = Util.createValueHandler();
    private RunTime runTime = this._valueHandler.getRunTimeCodeBase();
    private Throwable _unknownExn;
    private ORBImpl _orb;

    public IiopReader() {
    }

    public IiopReader(ReadStream rs) {
        this.init(rs);
    }

    public IiopReader(IiopSocketPool pool, ReadWritePair pair) {
        this._pool = pool;
        this._pair = pair;
        this.init(pair.getReadStream());
    }

    public void setOrb(ORBImpl orb) {
        this._orb = orb;
    }

    public void init(ReadStream rs) {
        this._rs = rs;
        this._major = 0;
        this._minor = 0;
        this._type = 0;
        this.requestId = 0;
        this._objectKey.clear();
        this._operation.clear();
        this._fragmentOffset = 0;
        this._context = new ReaderContext();
    }

    public ValueHandler getValueHandler() {
        return this._valueHandler;
    }

    public int getMajorVersion() {
        return this._major;
    }

    public int getMinorVersion() {
        return this._minor;
    }

    public int getRequestType() {
        return this._type;
    }

    public int getRequestId() {
        return this.requestId;
    }

    public boolean isBigEndian() {
        return this._isBigEndian;
    }

    public int getOffset() {
        return this._in.getOffset();
    }

    public boolean isResponseExpected() {
        return this.responseExpected;
    }

    public ByteBuffer getObjectKey() {
        return this._objectKey;
    }

    public CharBuffer getOperation() {
        return this._operation;
    }

    public XidImpl getXid() {
        return this._xid;
    }

    public boolean readRequest() throws IOException {
        block22: {
            block24: {
                block23: {
                    block21: {
                        int len = this._rs.readAll(this._header, 0, this._header.length);
                        if (len < 0) {
                            return false;
                        }
                        if (this._header[0] != 71 || this._header[1] != 73 || this._header[2] != 79 || this._header[3] != 80) {
                            throw new IOException(L.l("unknown request {0}, {1}, {2}, {3}", (java.lang.Object)("" + this.toCh(this._header[0])), (java.lang.Object)("" + this.toCh(this._header[1])), (java.lang.Object)("" + this.toCh(this._header[2])), (java.lang.Object)("" + this.toCh(this._header[3]))));
                        }
                        this._major = this._header[4];
                        this._minor = this._header[5];
                        if (this._major != 1) {
                            throw new IOException("unknown major");
                        }
                        this._flags = this._header[6];
                        this._isBigEndian = (this._flags & 1) == 0;
                        this._hasMoreFragments = (this._flags & 2) == 2;
                        this._type = this._header[7];
                        this._in = new InputStreamMessageReader((InputStream)this._rs, !this._hasMoreFragments, 0);
                        if (this._minor != 0) break block21;
                        switch (this._type) {
                            case 0: {
                                this.readRequest10();
                                break block22;
                            }
                            case 1: {
                                this.readReply10();
                                break block22;
                            }
                            case 5: {
                                return false;
                            }
                            case 6: {
                                throw new RuntimeException("MSG_ERROR: unknown protocol error");
                            }
                            default: {
                                throw new RuntimeException();
                            }
                        }
                    }
                    if (this._minor != 1) break block23;
                    switch (this._type) {
                        case 0: {
                            this.readRequest10();
                            break block22;
                        }
                        case 1: {
                            this.readReply10();
                            break block22;
                        }
                        case 5: {
                            return false;
                        }
                        case 6: {
                            throw new RuntimeException("MSG_ERROR: unknown protocol error");
                        }
                        default: {
                            throw new RuntimeException();
                        }
                    }
                }
                if (this._minor != 2) break block24;
                switch (this._type) {
                    case 0: {
                        this.readRequest12();
                        break block22;
                    }
                    case 1: {
                        this.readReply12();
                        break block22;
                    }
                    case 5: {
                        return false;
                    }
                    case 6: {
                        throw new RuntimeException("MSG_ERROR: unknown protocol error");
                    }
                    default: {
                        throw new RuntimeException("unknown type: " + this._type);
                    }
                }
            }
            throw new IOException("unknown minor");
        }
        return true;
    }

    private void readRequest10() throws IOException {
        this.readServiceContextList();
        this.requestId = this._in.read_long();
        this.responseExpected = this._in.read() != 0;
        this.readOctetSequence(this._objectKey);
        this.readString(this._operation);
        this.readOctetSequence(this.principal);
    }

    private void readReply10() throws IOException {
        this.readServiceContextList();
        int requestId = this._in.read_long();
        int status = this._in.read_long();
        switch (status) {
            case 0: {
                return;
            }
            case 2: {
                String exceptionId = this.readString();
                int minorStatus = this._in.read_long();
                int completionStatus = this._in.read_long();
                if (this._unknownExn instanceof RuntimeException) {
                    throw (RuntimeException)this._unknownExn;
                }
                if (this._unknownExn instanceof Throwable) {
                    throw new RemoteUserException(this._unknownExn);
                }
                throw new RuntimeException("exception: " + exceptionId);
            }
            case 1: {
                String type = this.read_string();
                Serializable value = this.read_value();
                if (value instanceof RuntimeException) {
                    throw (RuntimeException)value;
                }
                if (value instanceof Throwable) {
                    throw new RemoteUserException((Throwable)value);
                }
                throw new IOException("user exception: " + value);
            }
        }
        throw new IOException("unknown status: " + status);
    }

    private void readRequest12() throws IOException {
        this.requestId = this._in.read_long();
        byte flags = this.read_octet();
        this.responseExpected = flags != 0;
        int disposition = this.read_long();
        this.readOctetSequence(this._objectKey);
        this.readString(this._operation);
        this.readServiceContextList();
    }

    private void readReply12() throws IOException {
        int requestId = this._in.read_long();
        int status = this._in.read_long();
        this.readServiceContextList();
        switch (status) {
            case 0: {
                return;
            }
            case 2: {
                String exceptionId = this.readString();
                int minorStatus = this._in.read_long();
                int completionStatus = this._in.read_long();
                if (this._unknownExn != null) {
                    Throwable cause;
                    if (this._unknownExn instanceof RemoteException && (cause = this._unknownExn.getCause()) instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    throw new RemoteUserException(this._unknownExn);
                }
                throw new IOException("exception: " + exceptionId);
            }
            case 1: {
                Serializable value = this.read_value();
                if (value instanceof RuntimeException) {
                    throw (RuntimeException)value;
                }
                if (value instanceof Throwable) {
                    throw new RemoteUserException((Throwable)value);
                }
                if (value != null) {
                    throw new IOException("user exception: " + value + " " + value.getClass().getName());
                }
                throw new IOException("null user exception");
            }
        }
        throw new IOException("unknown status: " + status);
    }

    private void readServiceContextList() throws IOException {
        this._xid = null;
        int length = this._in.read_long();
        for (int i = 0; i < length; ++i) {
            int endian;
            int serviceId = this._in.read_long();
            int dataLength = this._in.read_long();
            int startOffset = this._in.setOffset(0);
            if (serviceId == 1) {
                endian = this._in.read();
                int charSet = this._in.read_long();
                int wcharSet = this._in.read_long();
            } else if (serviceId == 9) {
                endian = this._in.read();
                this._unknownExn = (Throwable)this.read_value();
            } else if (serviceId == 0) {
                XidImpl xid;
                endian = this._in.read();
                int timeout = this._in.read_long();
                int coord = this._in.read_long();
                int term = this._in.read_long();
                int format = this._in.read_long();
                int bqualLength = this._in.read_long();
                int xidLength = this._in.read_long();
                byte[] local = new byte[bqualLength];
                byte[] global = new byte[xidLength - bqualLength];
                this._in.read(global, 0, global.length);
                this._in.read(local, 0, local.length);
                int parents = this._in.read_long();
                this._xid = xid = new XidImpl(global, local);
            } else {
                this._in.skip(dataLength);
            }
            this._in.addOffset(startOffset);
        }
    }

    public IOR readIOR() throws IOException {
        IOR ior = new IOR();
        return ior.read(this);
    }

    public java.lang.Object readObject(Class cl) throws IOException {
        IOR ior = this.readIOR();
        return null;
    }

    public String readWideString() throws IOException {
        CharBuffer cb = CharBuffer.allocate();
        for (int len = this._in.read_long(); len > 0; --len) {
            cb.append((char)this.read_short());
        }
        return cb.close();
    }

    public Serializable read_value() {
        return this.read_value(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Serializable read_value(Class type) {
        try {
            int newChunk22;
            String string;
            block31: {
                int newChunk22;
                Class tail2;
                block30: {
                    int oldChunkEnd = this._chunkEnd;
                    this._chunkEnd = -1;
                    this._in.align(4);
                    int startOffset = this._in.getOffset();
                    int code = this.read_long();
                    String repId = "";
                    boolean isChunked = false;
                    java.lang.Object value = null;
                    if (code == 0) {
                        return null;
                    }
                    if (code == -1) {
                        this._chunkEnd = oldChunkEnd;
                        int start = this._in.getOffset();
                        int delta = this.read_long();
                        int target = start + delta;
                        log.fine("INDIRECT:" + delta);
                        value = this._context.getRef(target);
                        if (value == null) throw new IndirectionException(target);
                        return value;
                    }
                    if ((code & 0x7FFFFF00) != 0x7FFFFF00) {
                        repId = this.readString(code);
                    } else {
                        isChunked = (code & 8) == 8;
                        boolean hasCodeBase = (code & 1) == 1;
                        int repository = code & 6;
                        if (hasCodeBase) {
                            this.readCodeBase();
                        }
                        if (repository != 2) {
                            throw new RuntimeException("Can't cope with repository=" + repository);
                        }
                        repId = this.read_string();
                    }
                    try {
                        if (isChunked) {
                            int chunkLength = this._in.read_long();
                            this._chunkEnd = chunkLength + this._in.getOffset();
                            ++this._chunkDepth;
                        }
                        if (repId.equals("IDL:omg.org/CORBA/WStringValue:1.0")) {
                            value = this.read_wstring();
                        } else {
                            String className;
                            if (!repId.startsWith("RMI:") && !repId.startsWith("IDL:")) {
                                log.warning("unknown rep: " + repId + " " + Integer.toHexString(code));
                                throw new UnsupportedOperationException("problem parsing repid: '" + repId + "'");
                            }
                            int p = repId.indexOf(58, 4);
                            if (p < 0) {
                                throw new RuntimeException("unknown RMI: " + repId);
                            }
                            if (repId.startsWith("IDL:omg.org")) {
                                className = "org.omg" + repId.substring(11, p).replace('/', '.');
                                int tail2 = className.lastIndexOf(46);
                                className = className.substring(0, tail2) + "Package" + className.substring(tail2);
                            } else {
                                className = repId.substring(4, p);
                            }
                            if (className.equals("javax.rmi.CORBA.ClassDesc")) {
                                tail2 = this.readClass();
                                java.lang.Object var13_19 = null;
                                if (this._chunkDepth <= 0) return tail2;
                                --this._chunkDepth;
                                int delta = this._chunkEnd - this._in.getOffset();
                                this._chunkEnd = -1;
                                if (delta > 0) {
                                    this._in.skip(delta);
                                }
                                if ((newChunk22 = this._in.read_long()) < 0) break block30;
                                throw new IllegalStateException(L.l("{0}: expected end of chunk {1}", this.getOffset(), newChunk22));
                            }
                            Class cl = null;
                            try {
                                cl = CauchoSystem.loadClass(className);
                            }
                            catch (ClassNotFoundException e) {
                                e.printStackTrace();
                                throw new RuntimeException(e);
                            }
                            value = this._valueHandler.readValue((org.omg.CORBA.portable.InputStream)this, startOffset, cl, repId, this.runTime);
                        }
                        this._context.addRef(startOffset, (Serializable)value);
                        string = value;
                        break block31;
                    }
                    catch (Throwable throwable) {
                        int newChunk22;
                        java.lang.Object var13_21 = null;
                        if (this._chunkDepth <= 0) throw throwable;
                        --this._chunkDepth;
                        int delta = this._chunkEnd - this._in.getOffset();
                        this._chunkEnd = -1;
                        if (delta > 0) {
                            this._in.skip(delta);
                        }
                        if ((newChunk22 = this._in.read_long()) >= 0) {
                            throw new IllegalStateException(L.l("{0}: expected end of chunk {1}", this.getOffset(), newChunk22));
                        }
                        this._chunkDepth = -(newChunk22 + 1);
                        if (this._chunkDepth <= 0) throw throwable;
                        newChunk22 = this._in.read_long();
                        this._chunkEnd = this._in.getOffset() + newChunk22;
                        throw throwable;
                    }
                }
                this._chunkDepth = -(newChunk22 + 1);
                if (this._chunkDepth <= 0) return tail2;
                newChunk22 = this._in.read_long();
                this._chunkEnd = this._in.getOffset() + newChunk22;
                return tail2;
            }
            java.lang.Object var13_20 = null;
            if (this._chunkDepth <= 0) return string;
            --this._chunkDepth;
            int delta = this._chunkEnd - this._in.getOffset();
            this._chunkEnd = -1;
            if (delta > 0) {
                this._in.skip(delta);
            }
            if ((newChunk22 = this._in.read_long()) >= 0) {
                throw new IllegalStateException(L.l("{0}: expected end of chunk {1}", this.getOffset(), newChunk22));
            }
            this._chunkDepth = -(newChunk22 + 1);
            if (this._chunkDepth <= 0) return string;
            newChunk22 = this._in.read_long();
            this._chunkEnd = this._in.getOffset() + newChunk22;
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Class readClass() throws IOException {
        String codebase = (String)((java.lang.Object)this.read_value(String.class));
        String repId = (String)((java.lang.Object)this.read_value(String.class));
        log.fine("CODE: " + codebase);
        log.fine("REP-ID: " + repId);
        if (codebase != null && codebase.startsWith("RMI:")) {
            String temp = repId;
            repId = codebase;
            codebase = temp;
        }
        return this.loadClass(repId);
    }

    private Class loadClass(String repId) throws RuntimeException {
        if (!repId.startsWith("RMI:")) {
            throw new RuntimeException("unknown RMI: " + repId);
        }
        int p = repId.indexOf(58, 4);
        if (p < 0) {
            throw new RuntimeException("unknown RMI: " + repId);
        }
        String className = repId.substring(4, p);
        if ("javax.rmi.CORBA.ClassDesc".equals(className)) {
            return Class.class;
        }
        java.lang.Object cl = null;
        try {
            Thread thread = Thread.currentThread();
            return Class.forName(className, false, thread.getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    private String readCodeBase() {
        String codeBase = this.read_string();
        return codeBase;
    }

    public java.lang.Object read_fault() {
        int startOffset;
        int originalOffset = startOffset = this._in.getOffset();
        String repId = this.read_string();
        if (repId.equals("IDL:omg.org/CORBA/WStringValue:1.0")) {
            return this.read_wstring();
        }
        Class cl = null;
        if (repId.startsWith("RMI:")) {
            int p = repId.indexOf(58, 4);
            if (p < 0) {
                throw new RuntimeException("unknown RMI: " + repId);
            }
            String className = repId.substring(4, p);
            try {
                cl = CauchoSystem.loadClass(className);
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
            return this._valueHandler.readValue((org.omg.CORBA.portable.InputStream)this, this._in.getOffset(), cl, repId, this.runTime);
        }
        String className = null;
        if (repId.startsWith("IDL:")) {
            String tail = repId.substring(4);
            int p = tail.indexOf(58);
            if (p > 0) {
                tail = tail.substring(0, p);
            }
            if (tail.startsWith("omg.org/")) {
                tail = "org.omg." + tail.substring("omg.org/".length());
            }
            className = tail.replace('/', '.');
        } else {
            className = repId;
        }
        String handler = className + "Handler";
        Class handlerClass = null;
        try {
            cl = CauchoSystem.loadClass(className);
            handlerClass = CauchoSystem.loadClass(handler);
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (cl == null) {
            int p = className.lastIndexOf(46);
            className = className.substring(0, p) + "Package" + className.substring(p);
            handler = className + "Helper";
            try {
                cl = CauchoSystem.loadClass(className);
                handlerClass = CauchoSystem.loadClass(handler);
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (cl != null && handlerClass != null) {
            Method readHelper = null;
            try {
                readHelper = handlerClass.getMethod("read", org.omg.CORBA.portable.InputStream.class);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (readHelper != null) {
                try {
                    this._in.setOffset(startOffset);
                    this._rs.setOffset(originalOffset);
                    return readHelper.invoke(null, new java.lang.Object[]{this});
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                catch (Exception e) {
                    throw new RuntimeException(String.valueOf(e));
                }
            }
        }
        return new IOException("unknown fault: " + repId);
    }

    public boolean read_boolean() {
        return this._in.read() != 0;
    }

    public char read_char() {
        return (char)this._in.read();
    }

    public char read_wchar() {
        if (this._minor == 2) {
            this._in.read();
            return (char)this._in.read_short();
        }
        return (char)this.read_short();
    }

    public short read_ushort() {
        return this.read_short();
    }

    public int read_long() {
        return this._in.read_long();
    }

    public int read_ulong() {
        return this.read_long();
    }

    public long read_longlong() {
        return this.readLong();
    }

    public long read_ulonglong() {
        return this.read_longlong();
    }

    public byte read_octet() {
        return (byte)this._in.read();
    }

    public float read_float() {
        int v = this.read_long();
        return Float.intBitsToFloat(v);
    }

    public double read_double() {
        long v = this.read_longlong();
        return Double.longBitsToDouble(v);
    }

    public void read_boolean_array(boolean[] v, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            v[i + offset] = this.read_boolean();
        }
    }

    public void read_char_array(char[] v, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            v[i + offset] = this.read_char();
        }
    }

    public String read_string() {
        int len = this.read_long();
        int offset = this._in.getOffset();
        if (len < 0) {
            int delta = this.read_long();
            String v = this._context.getString(offset + delta);
            return v;
        }
        char[] cb = this._cb;
        if (cb.length < len) {
            cb = this._cb = new char[len + (1024 - len % 1024) % 1024];
        }
        for (int i = 0; i < len - 1; ++i) {
            cb[i] = this.read_char();
        }
        this.read_octet();
        String v = new String(cb, 0, len - 1);
        this._context.putString(offset, v);
        return v;
    }

    public String readString(int len) {
        char[] cb = this._cb;
        if (cb.length < len) {
            cb = this._cb = new char[len + (1024 - len % 1024) % 1024];
        }
        for (int i = 0; i < len - 1; ++i) {
            cb[i] = this.read_char();
        }
        this.read_octet();
        return new String(cb, 0, len - 1);
    }

    public void read_wchar_array(char[] v, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            v[i + offset] = this.read_wchar();
        }
    }

    public String read_wstring() {
        return this.read_wstring(this.read_long());
    }

    public String read_wstring(int len) {
        char[] cb = this._cb;
        if (this._minor >= 2) {
            int sublen = len / 2;
            if (cb.length < sublen) {
                cb = this._cb = new char[sublen + (1024 - sublen % 1024) % 1024];
            }
            for (int i = 0; i < sublen; ++i) {
                cb[i] = (char)this.read_short();
            }
            String v = new String(cb, 0, sublen);
            return v;
        }
        if (cb.length < len) {
            cb = this._cb = new char[len + (1024 - len % 1024) % 1024];
        }
        for (int i = 0; i < len - 1; ++i) {
            cb[i] = (char)this.read_short();
        }
        this.read_short();
        return new String(cb, 0, len - 1);
    }

    public void read_octet_array(byte[] v, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            v[i + offset] = this.read_octet();
        }
    }

    public void read_short_array(short[] v, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            v[i + offset] = this.read_short();
        }
    }

    public void read_ushort_array(short[] v, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            v[i + offset] = this.read_ushort();
        }
    }

    public void read_long_array(int[] v, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            v[i + offset] = this._in.read_long();
        }
    }

    public void read_ulong_array(int[] v, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            v[i + offset] = this.read_ulong();
        }
    }

    public void read_longlong_array(long[] v, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            v[i + offset] = this.read_longlong();
        }
    }

    public void read_ulonglong_array(long[] v, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            v[i + offset] = this.read_ulonglong();
        }
    }

    public void read_float_array(float[] v, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            v[i + offset] = this.read_float();
        }
    }

    public void read_double_array(double[] v, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            v[i + offset] = this.read_double();
        }
    }

    public java.lang.Object read_abstract_interface() {
        boolean discriminator = this.read_boolean();
        if (discriminator) {
            return this.read_Object();
        }
        return this.read_value();
    }

    public Object read_Object(Class cl) {
        return this.read_Object();
    }

    public Object read_Object() {
        try {
            IOR ior = this.readIOR();
            if (this._orb != null) {
                return new StubImpl(this._orb, ior);
            }
            return new DummyObjectImpl(ior);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TypeCode read_TypeCode() {
        int kind = this.read_long();
        try {
            switch (kind) {
                case 0: {
                    return TypeCodeImpl.TK_NULL;
                }
                case 8: {
                    return BooleanTypeCode.TYPE_CODE;
                }
                case 26: {
                    return WcharTypeCode.TYPE_CODE;
                }
                case 10: {
                    return OctetTypeCode.TYPE_CODE;
                }
                case 2: {
                    return ShortTypeCode.TYPE_CODE;
                }
                case 3: {
                    return LongTypeCode.TYPE_CODE;
                }
                case 23: {
                    return LongLongTypeCode.TYPE_CODE;
                }
                case 6: {
                    return FloatTypeCode.TYPE_CODE;
                }
                case 7: {
                    return DoubleTypeCode.TYPE_CODE;
                }
                case 18: {
                    TypeCodeImpl typeCode = new TypeCodeImpl(TCKind.tk_string);
                    typeCode.setLength(this.read_ulong());
                    return typeCode;
                }
                case 27: {
                    TypeCodeImpl typeCode = new TypeCodeImpl(TCKind.tk_wstring);
                    typeCode.setLength(this.read_ulong());
                    return typeCode;
                }
                case 19: {
                    return SequenceTypeCode.readTypeCode(this);
                }
                case 29: {
                    return ValueTypeCode.readTypeCode(this);
                }
                case 30: {
                    return ValueBoxTypeCode.readTypeCode(this);
                }
                case 32: {
                    return AbstractInterfaceTypeCode.readTypeCode(this);
                }
                default: {
                    System.out.println("UNKNOWN:" + kind);
                    throw new UnsupportedOperationException("unknown typecode kind: " + kind);
                }
            }
        }
        catch (Throwable throwable) {
            java.lang.Object var5_32 = null;
            throw throwable;
        }
    }

    public Any read_any() {
        try {
            TypeCode typeCode = this.read_TypeCode();
            AnyImpl any = new AnyImpl();
            any.read_value((org.omg.CORBA.portable.InputStream)this, typeCode);
            return any;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Principal read_Principal() {
        throw new UnsupportedOperationException();
    }

    public int read_sequence_length() {
        int length = this.read_long();
        if (length < 0 || length > 65536) {
            throw new RuntimeException("sequence too long:" + length);
        }
        return length;
    }

    public void readOctetSequence(ByteBuffer bb) throws IOException {
        int len = this._in.read_long();
        if (len > 65536) {
            throw new IOException("too large chunk " + len);
        }
        bb.ensureCapacity(len);
        this._in.read(bb.getBuffer(), 0, len);
        bb.setLength(len);
    }

    public String readString() {
        int len = this._in.read_long();
        if (len < 1 || len > 65536) {
            throw new IllegalStateException("string length problems: " + len);
        }
        char[] cb = this._cb;
        if (cb.length < len) {
            cb = this._cb = new char[len + (1024 - len % 1024) % 1024];
        }
        for (int i = 0; i < len - 1; ++i) {
            cb[i] = (char)this.read_octet();
        }
        byte ch = this.read_octet();
        return new String(cb, 0, len - 1);
    }

    public void readString(CharBuffer cb) throws IOException {
        int len = this._in.read_long();
        if (len > 65536) {
            throw new IOException("too large chunk " + len);
        }
        cb.clear();
        for (int i = 0; i < len - 1; ++i) {
            int ch = this.read();
            cb.append((char)ch);
        }
        int ch = this.read();
    }

    public short read_short() {
        return (short)this._in.read_short();
    }

    public int readInt() {
        return this._in.read_long();
    }

    public int readInt(byte[] buffer, int offset) {
        byte ch1 = buffer[offset++];
        byte ch2 = buffer[offset++];
        byte ch3 = buffer[offset++];
        byte ch4 = buffer[offset++];
        return ((ch1 & 0xFF) << 24) + ((ch2 & 0xFF) << 16) + ((ch3 & 0xFF) << 8) + (ch4 & 0xFF);
    }

    public long readLong() {
        return this._in.read_longlong();
    }

    private void align4() {
        this._in.align(4);
    }

    private void align8() throws IOException {
        this._in.align(8);
    }

    public void alignMethodArgs() {
        if (this._minor >= 2) {
            this._in.align(8);
        }
    }

    public int read() {
        return this._in.read();
    }

    public byte[] readBytes() throws IOException {
        int len = this._in.read_long();
        if (len > 65536) {
            throw new IOException("too large chunk " + len);
        }
        byte[] buf = new byte[len];
        this._in.read(buf, 0, len);
        return buf;
    }

    public void completeRead() throws IOException {
    }

    public void close() {
        ReadWritePair pair = this._pair;
        this._pair = null;
        this._rs = null;
        if (pair != null) {
            if (this._pool != null) {
                this._pool.free(pair);
            } else {
                try {
                    pair.getWriteStream().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                pair.getReadStream().close();
            }
        }
    }

    private void writeHexGroup(byte[] buffer, int offset, int length) {
        int end = offset + length;
        while (offset < end) {
            int j;
            int chunkLength = 16;
            for (j = 0; j < chunkLength; ++j) {
                System.out.print(" ");
                this.printHex(buffer[offset + j]);
            }
            System.out.print(" ");
            for (j = 0; j < chunkLength; ++j) {
                this.printCh(buffer[offset + j]);
            }
            offset += chunkLength;
            System.out.println();
        }
    }

    private void printHex(int d) {
        int ch1 = d >> 4 & 0xF;
        int ch2 = d & 0xF;
        if (ch1 >= 10) {
            System.out.print((char)(97 + ch1 - 10));
        } else {
            System.out.print((char)(48 + ch1));
        }
        if (ch2 >= 10) {
            System.out.print((char)(97 + ch2 - 10));
        } else {
            System.out.print((char)(48 + ch2));
        }
    }

    private void printCh(int d) {
        if (d >= 32 && d <= 127) {
            System.out.print("" + (char)d);
        } else {
            System.out.print(".");
        }
    }

    private String toCh(int d) {
        if (d >= 32 && d <= 127) {
            return "" + (char)d;
        }
        return "" + d;
    }

    private static String toHex(int v) {
        CharBuffer cb = new CharBuffer();
        for (int i = 28; i >= 0; i -= 4) {
            int h = v >> i & 0xF;
            if (h >= 10) {
                cb.append((char)(97 + h - 10));
                continue;
            }
            cb.append(h);
        }
        return cb.toString();
    }
}

