/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.iiop;

import com.caucho.iiop.CosServer;
import com.caucho.iiop.IOR;
import com.caucho.iiop.Iiop10Writer;
import com.caucho.iiop.Iiop11Writer;
import com.caucho.iiop.Iiop12Writer;
import com.caucho.iiop.IiopProtocol;
import com.caucho.iiop.IiopReader;
import com.caucho.iiop.IiopSkeleton;
import com.caucho.iiop.IiopWriter;
import com.caucho.iiop.StreamMessageWriter;
import com.caucho.iiop.orb.ORBImpl;
import com.caucho.jca.UserTransactionProxy;
import com.caucho.server.connection.Connection;
import com.caucho.server.port.ServerRequest;
import com.caucho.transaction.TransactionManagerImpl;
import com.caucho.transaction.XidImpl;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.rmi.RemoteException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.InitialContext;
import javax.transaction.UserTransaction;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import org.omg.CORBA.portable.OutputStream;

public class IiopRequest
implements ServerRequest {
    private static final Logger log = Logger.getLogger(IiopRequest.class.getName());
    Connection _conn;
    IiopProtocol _server;
    ORBImpl _orb;
    IiopReader _reader;
    ClassLoader _loader;
    StreamMessageWriter _messageWriter;
    IiopWriter _writer10;
    IiopWriter _writer11;
    IiopWriter _writer12;
    ReadStream _readStream;
    WriteStream _writeStream;
    CosServer _cos;
    IiopSkeleton _cosSkel;
    String _hostName;
    int _port;
    private UserTransactionProxy _utm;
    TransactionManagerImpl _tm;
    UserTransaction _ut;

    IiopRequest(IiopProtocol server, Connection conn) {
        this._server = server;
        this._conn = conn;
        InetAddress local = this._conn.getLocalAddress();
        this._reader = new IiopReader();
        this._messageWriter = new StreamMessageWriter();
        this._writer10 = new Iiop10Writer();
        this._writer10.init(this._messageWriter);
        this._writer11 = new Iiop11Writer();
        this._writer11.init(this._messageWriter);
        this._writer12 = new Iiop12Writer();
        this._writer12.init(this._messageWriter);
        this._cos = this._server.getCos();
        this._utm = UserTransactionProxy.getInstance();
        this._loader = Thread.currentThread().getContextClassLoader();
    }

    public void init() {
    }

    public boolean isWaitForRead() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean handleRequest() throws IOException {
        ClassLoader oldLoader;
        Thread thread;
        block42: {
            IiopWriter writer;
            block39: {
                InetAddress local;
                thread = Thread.currentThread();
                oldLoader = thread.getContextClassLoader();
                thread.setContextClassLoader(this._loader);
                log.finer("IIOP[" + this._conn.getId() + "]: handle request");
                this._readStream = this._conn.getReadStream();
                this._writeStream = this._conn.getWriteStream();
                if (this._orb == null) {
                    local = this._conn.getLocalAddress();
                    this._orb = this._server.getOrb(local.getHostName(), this._conn.getLocalPort());
                    this._reader.setOrb(this._orb);
                    this._writer10.setOrb(this._orb);
                    this._writer11.setOrb(this._orb);
                    this._writer12.setOrb(this._orb);
                }
                if (this._cosSkel == null) {
                    local = this._conn.getLocalAddress();
                    this._hostName = local.getHostName();
                    this._port = this._conn.getLocalPort();
                    this._cos.setHost(this._hostName);
                    this._cos.setPort(this._port);
                    ArrayList<Class> apiList = new ArrayList<Class>();
                    apiList.add(this._cos.getClass());
                    this._cosSkel = new IiopSkeleton(this._cos, apiList, this._loader, this._hostName, this._port, "/NameService");
                }
                this._reader.init(this._readStream);
                this._messageWriter.init(this._writeStream);
                writer = this._writer10;
                if (this._reader.readRequest()) break block39;
                boolean apiList = false;
                Object var13_8 = null;
                thread.setContextClassLoader(oldLoader);
                try {
                    this._utm.abortTransaction();
                }
                catch (Throwable e2) {
                    log.log(Level.WARNING, e2.toString(), e2);
                }
                return apiList;
            }
            switch (this._reader.getMinorVersion()) {
                case 0: {
                    writer = this._writer10;
                    break;
                }
                case 1: {
                    writer = this._writer11;
                    break;
                }
                case 2: {
                    writer = this._writer12;
                    break;
                }
                default: {
                    writer = this._writer10;
                }
            }
            writer.init();
            writer.setHost(this._hostName);
            writer.setPort(this._port);
            String oid = this._reader.getObjectKey().toString();
            if (log.isLoggable(Level.FINER)) {
                log.finer("IIOP[" + this._conn.getId() + "] OID: " + oid);
            }
            XidImpl xid = this._reader.getXid();
            try {
                block41: {
                    try {
                        if (xid != null) {
                            this.beginTransaction(xid);
                        }
                        if (oid.equals("INIT")) {
                            String str = this._reader.readString();
                            writer.startReplyOk(this._reader.getRequestId());
                            if (str.equals("NameService")) {
                                String nameService = "IDL:omg.org/CosNaming/NamingContext:1.0";
                                IOR ior = new IOR(nameService, this._hostName, this._port, "/NameService");
                                byte[] bytes = ior.getByteArray();
                                writer.write(bytes, 0, bytes.length);
                            } else {
                                writer.writeNullIOR();
                            }
                            break block41;
                        }
                        if (oid.equals("/NameService")) {
                            this._cosSkel.service(this._cosSkel.getObject(), this._reader, writer);
                            break block41;
                        }
                        IiopSkeleton skel = this._server.getService(this._hostName, this._port, oid);
                        if (skel == null) {
                            log.fine(this.dbgId() + "can't find service: " + oid);
                            throw new IOException("bad oid: " + oid);
                        }
                        skel.service(skel.getObject(), this._reader, writer);
                        log.fine(this.dbgId() + "complete request");
                    }
                    catch (SystemException e) {
                        log.log(Level.WARNING, e.toString(), e);
                        writer.startReplySystemException(this._reader.getRequestId(), e.toString(), e.minor, e.completed.value(), null);
                        Object var11_32 = null;
                        if (xid != null) {
                            this.endTransaction(xid);
                        }
                        break block42;
                    }
                    catch (UserException e) {
                        log.log(Level.WARNING, e.toString(), e);
                        writer.startReplyUserException(this._reader.getRequestId());
                        try {
                            Class<?> helperClass = Class.forName(((Object)((Object)e)).getClass().getName() + "Helper", false, ((Object)((Object)e)).getClass().getClassLoader());
                            Method writeMethod = helperClass.getMethod("write", OutputStream.class, ((Object)((Object)e)).getClass());
                            writeMethod.invoke(null, new Object[]{writer, e});
                        }
                        catch (Exception e1) {
                            throw new RuntimeException(e1);
                        }
                        Object var11_33 = null;
                        if (xid != null) {
                            this.endTransaction(xid);
                        }
                        break block42;
                    }
                    catch (RemoteException e) {
                        log.log(Level.WARNING, e.toString(), e);
                        String msg = e.toString();
                        writer.startReplySystemException(this._reader.getRequestId(), e.toString(), 0, 0, e);
                        Object var11_34 = null;
                        if (xid != null) {
                            this.endTransaction(xid);
                        }
                        break block42;
                    }
                    catch (Throwable e) {
                        log.log(Level.WARNING, e.toString(), e);
                        writer.startReplyUserException(this._reader.getRequestId());
                        String repId = this._reader.getValueHandler().getRMIRepositoryID(e.getClass());
                        writer.write_value(e);
                        Object var11_35 = null;
                        if (xid != null) {
                            this.endTransaction(xid);
                        }
                    }
                }
                Object var11_31 = null;
                if (xid != null) {
                    this.endTransaction(xid);
                }
            }
            catch (Throwable throwable) {
                Object var11_36 = null;
                if (xid != null) {
                    this.endTransaction(xid);
                }
                throw throwable;
            }
        }
        this._messageWriter.close();
        this._reader.completeRead();
        boolean bl = true;
        Object var13_9 = null;
        thread.setContextClassLoader(oldLoader);
        try {
            this._utm.abortTransaction();
        }
        catch (Throwable e2) {
            log.log(Level.WARNING, e2.toString(), e2);
        }
        return bl;
        catch (Throwable e) {
            boolean bl2;
            try {
                log.log(Level.WARNING, this.dbgId() + e.toString(), e);
                bl2 = false;
                Object var13_10 = null;
                thread.setContextClassLoader(oldLoader);
            }
            catch (Throwable throwable) {
                Object var13_11 = null;
                thread.setContextClassLoader(oldLoader);
                try {
                    this._utm.abortTransaction();
                }
                catch (Throwable e2) {
                    log.log(Level.WARNING, e2.toString(), e2);
                }
                throw throwable;
            }
            try {
                this._utm.abortTransaction();
            }
            catch (Throwable e2) {
                log.log(Level.WARNING, e2.toString(), e2);
            }
            return bl2;
        }
    }

    String dbgId() {
        return "Iiop[" + this._conn.getId() + "] ";
    }

    public boolean handleResume() throws IOException {
        return false;
    }

    private void beginTransaction(XidImpl xid) throws Exception {
        this.getUserTransaction().begin();
    }

    private void endTransaction(XidImpl xid) {
        try {
            this.getUserTransaction().commit();
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void protocolCloseEvent() {
    }

    private UserTransaction getUserTransaction() {
        if (this._ut == null) {
            try {
                this._ut = (UserTransaction)new InitialContext().lookup("java:comp/UserTransaction");
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString());
            }
        }
        return this._ut;
    }
}

