/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.iiop;

import com.caucho.iiop.DummyObjectImpl;
import com.caucho.iiop.IOR;
import com.caucho.iiop.IiopReader;
import com.caucho.iiop.IiopWriter;
import com.caucho.iiop.SkeletonMethod;
import com.caucho.util.L10N;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.omg.CORBA.NO_IMPLEMENT;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IiopSkeleton
extends DummyObjectImpl {
    private static final L10N L = new L10N(IiopSkeleton.class);
    private static final Logger log = Logger.getLogger(IiopSkeleton.class.getName());
    private static HashMap<String, String> _knownClasses = new HashMap();
    private ClassLoader _loader;
    private Class _remoteClass;
    private ArrayList<Class> _apiList;
    private HashMap<String, SkeletonMethod> _methodMap = new HashMap();
    private Object _obj;

    public IiopSkeleton(Object obj, ArrayList<Class> apiList, ClassLoader loader, String host, int port, String oid) {
        super(new IOR(apiList.get(0), host, port, oid));
        if (obj == null) {
            throw new NullPointerException();
        }
        this._obj = obj;
        this._apiList = apiList;
        this._remoteClass = this._apiList.get(0);
        this._loader = loader;
        this.introspectMethods();
    }

    Object getObject() {
        return this._obj;
    }

    ArrayList<Class> getApiList() {
        return this._apiList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void service(Object obj, IiopReader reader, IiopWriter writer) throws Throwable {
        String op = reader.getOperation().toString();
        Object method = null;
        SkeletonMethod skelMethod = null;
        if (log.isLoggable(Level.FINE)) {
            log.fine("IIOP-call: " + this._remoteClass.getName() + "." + op);
        }
        if ((skelMethod = this._methodMap.get(op)) != null) {
            Thread thread = Thread.currentThread();
            ClassLoader oldLoader = thread.getContextClassLoader();
            try {
                thread.setContextClassLoader(this._loader);
                skelMethod.service(obj, reader, writer);
                Object var10_9 = null;
                thread.setContextClassLoader(oldLoader);
            }
            catch (Throwable throwable) {
                Object var10_10 = null;
                thread.setContextClassLoader(oldLoader);
                throw throwable;
            }
        } else if (!this.serviceSystemMethod(obj, op, reader, writer)) {
            throw new NO_IMPLEMENT(L.l("{0}: '{1}' is an unknown method.", (Object)this._remoteClass.getName(), (Object)op));
        }
    }

    Method getMethod(String name) {
        for (int j = 0; j < this._apiList.size(); ++j) {
            Method[] methods = this._apiList.get(j).getMethods();
            for (int i = 0; i < methods.length; ++i) {
                if (!methods[i].getName().equals(name)) continue;
                return methods[i];
            }
        }
        return null;
    }

    private void introspectMethods() {
        for (int j = 0; j < this._apiList.size(); ++j) {
            Method[] methods = this._apiList.get(j).getMethods();
            for (int i = 0; i < methods.length; ++i) {
                this.introspectMethod(methods[i]);
            }
        }
    }

    private void introspectMethod(Method method) {
        boolean isJava = !this._remoteClass.getName().startsWith("com.caucho.iiop");
        SkeletonMethod skelMethod = new SkeletonMethod(this, method, isJava);
        this._methodMap.put(method.getName(), skelMethod);
        this._methodMap.put(IiopSkeleton.mangle(method), skelMethod);
    }

    public static String mangle(Method method) {
        StringBuilder sb = new StringBuilder();
        sb.append(method.getName());
        sb.append("__");
        Class<?>[] args = method.getParameterTypes();
        for (int i = 0; i < args.length; ++i) {
            Class<?> arg = args[i];
            if (i > 0) {
                sb.append("__");
            }
            if (String.class.equals(arg)) {
                sb.append("CORBA_WStringValue");
                continue;
            }
            if (Integer.TYPE.equals(arg)) {
                sb.append("long");
                continue;
            }
            if (Long.TYPE.equals(arg)) {
                sb.append("longlong");
                continue;
            }
            sb.append(arg.getName().replace('.', '_'));
        }
        return sb.toString();
    }

    boolean serviceSystemMethod(Object obj, String op, IiopReader reader, IiopWriter writer) throws Exception {
        if (op.equals("_is_a")) {
            String name = reader.read_string();
            String className = _knownClasses.get(name);
            if (className == null) {
                if (name.startsWith("RMI:")) {
                    className = name.substring(4);
                    int p = className.indexOf(58);
                    if (p > 0) {
                        className = className.substring(0, p);
                    }
                } else {
                    className = name;
                }
            }
            Class<?> cl = obj.getClass();
            boolean value = this.isA(cl, className);
            if (log.isLoggable(Level.FINE)) {
                log.fine("IIOP _is_a: " + obj.getClass() + " " + className + " " + value);
            }
            writer.startReplyOk(reader.getRequestId());
            writer.write_boolean(value);
            return true;
        }
        return false;
    }

    private boolean isA(Class cl, String className) {
        while (cl != null) {
            if (cl.getName().equals(className)) {
                return true;
            }
            Class<?>[] ifs = cl.getInterfaces();
            for (int i = 0; i < ifs.length; ++i) {
                if (!this.isA(ifs[i], className)) continue;
                return true;
            }
            cl = cl.getSuperclass();
        }
        return false;
    }

    public String toString() {
        return "IiopSkeleton[" + this._remoteClass.getName() + "]";
    }

    static {
        _knownClasses.put("IDL:omg.org/CosNaming/NamingContext:1.0", "org.omg.CosNaming.NamingContext");
    }
}

