/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.iiop;

import com.caucho.iiop.DummyObjectImpl;
import com.caucho.iiop.IOR;
import com.caucho.iiop.IiopReader;
import com.caucho.iiop.MessageWriter;
import com.caucho.iiop.ServiceContext;
import com.caucho.iiop.WriterContext;
import com.caucho.iiop.any.AbstractInterfaceTypeCode;
import com.caucho.iiop.any.SequenceTypeCode;
import com.caucho.iiop.any.ValueBoxTypeCode;
import com.caucho.iiop.any.ValueTypeCode;
import com.caucho.iiop.orb.IiopProxyHandler;
import com.caucho.util.Alarm;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.ArrayList;
import javax.rmi.CORBA.ClassDesc;
import javax.rmi.CORBA.ValueHandler;
import org.omg.CORBA.Any;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Object;
import org.omg.CORBA.Principal;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class IiopWriter
extends OutputStream {
    protected static final int VALUE_TAG = 0x7FFFFF00;
    protected static final int VALUE_HAS_CODESET = 1;
    protected static final int VALUE_NO_TYPE = 0;
    protected static final int VALUE_ONE_REP_ID = 2;
    protected static final int VALUE_MANY_REP_IDS = 6;
    protected MessageWriter _out;
    protected int _type;
    protected SystemException _nullSystemException;
    protected IiopReader _reader;
    protected String _host;
    protected int _port;
    private ORB _orb;
    private IiopWriter _parent;
    private WriterContext _context;

    public IiopWriter() {
    }

    public IiopWriter(IiopWriter parent, MessageWriter out) {
        this._parent = parent;
        this._out = out;
        this._context = parent.getContext();
    }

    public void init(MessageWriter out) {
        this._out = out;
        this._context = new WriterContext();
    }

    public void init() {
        this._context = new WriterContext();
    }

    public void init(MessageWriter out, IiopReader reader) {
        this.init(out);
        this._reader = reader;
    }

    protected WriterContext getContext() {
        return this._context;
    }

    public void setHost(String host) {
        this._host = host;
    }

    public String getHost() {
        return this._host;
    }

    public void setPort(int port) {
        this._port = port;
    }

    public int getPort() {
        return this._port;
    }

    public void startRequest(IOR ior, String operation) throws IOException {
        byte[] bytes = ior.getOid();
        this.startRequest(bytes, 0, bytes.length, operation);
    }

    public void startRequest(byte[] oid, int off, int len, String operation) throws IOException {
        this.startRequest(oid, off, len, operation, (int)Alarm.getCurrentTime(), null);
    }

    public abstract void startRequest(byte[] var1, int var2, int var3, String var4, int var5, ArrayList<ServiceContext> var6) throws IOException;

    public void writeRequestServiceControlList() throws IOException {
        this.write_long(1);
        this.writeCodeSetService();
    }

    public void writeCodeSetService() throws IOException {
        this.write_long(1);
        this.write_long(12);
        this.write_long(0);
        this.write_long(65537);
        this.write_long(65792);
    }

    public abstract void startReplyOk(int var1) throws IOException;

    public abstract void startReplySystemException(int var1, String var2, int var3, int var4, Throwable var5) throws IOException;

    public void startReplyUserException(int requestId, String exceptionId) throws IOException {
        this.startReplyUserException(requestId);
        this.writeString(exceptionId);
    }

    public abstract void startReplyUserException(int var1) throws IOException;

    public void alignMethodArgs() {
    }

    public void writeIOR(IOR ior) {
        byte[] bytes = ior.getByteArray();
        this._out.align(4);
        this._out.write(bytes, 0, bytes.length);
    }

    public void writeNullIOR() {
        this.write_long(1);
        this.write_long(0);
        this.write_long(0);
    }

    public void writeNull() {
        this.write_long(0);
    }

    public ORB orb() {
        return this._orb;
    }

    public void setOrb(ORB orb) {
        this._orb = orb;
    }

    public InputStream create_input_stream() {
        throw new UnsupportedOperationException("no input stream");
    }

    public void write_boolean_array(boolean[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            this._out.write(value[i + offset] ? 1 : 0);
        }
    }

    public void write_char_array(char[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            this._out.write(value[i + offset]);
        }
    }

    public void write_wchar_array(char[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            this.write_wchar(value[i + offset]);
        }
    }

    public void write_octet_array(byte[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            this._out.write(value[i + offset]);
        }
    }

    public void write_short_array(short[] value, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            this._out.writeShort(value[i + offset]);
        }
    }

    public void write_ushort_array(short[] value, int offset, int length) {
        this._out.align(2);
        for (int i = 0; i < length; ++i) {
            this._out.writeShort(value[i + offset]);
        }
    }

    public void write_long_array(int[] value, int offset, int length) {
        this._out.align(4);
        for (int i = 0; i < length; ++i) {
            this._out.writeInt(value[i + offset]);
        }
    }

    public void write_ulong_array(int[] value, int offset, int length) {
        this._out.align(4);
        for (int i = 0; i < length; ++i) {
            this._out.writeInt(value[i + offset]);
        }
    }

    public void write_longlong_array(long[] value, int offset, int length) {
        this._out.align(8);
        for (int i = 0; i < length; ++i) {
            this._out.writeLong(value[i + offset]);
        }
    }

    public void write_ulonglong_array(long[] value, int offset, int length) {
        this._out.align(8);
        for (int i = 0; i < length; ++i) {
            this._out.writeLong(value[i + offset]);
        }
    }

    public void write_float_array(float[] value, int offset, int length) {
        this._out.align(4);
        for (int i = 0; i < length; ++i) {
            float v = value[i + offset];
            int bits = Float.floatToIntBits(v);
            this._out.writeInt(bits);
        }
    }

    public void write_double_array(double[] value, int offset, int length) {
        this._out.align(8);
        for (int i = 0; i < length; ++i) {
            double v = value[i + offset];
            long bits = Double.doubleToLongBits(v);
            this._out.writeLong(bits);
        }
    }

    public void write_string(String a) {
        if (a == null) {
            this.write_long(0);
            return;
        }
        this._out.align(4);
        int oldOffset = this._context.getString(a);
        if (oldOffset >= 0) {
            this.write_long(-1);
            int offset = this.getOffset();
            this.write_long(oldOffset - offset);
        } else {
            int length = a.length();
            this.write_long(length + 1);
            int offset = this.getOffset();
            this._context.putString(a, offset);
            for (int i = 0; i < length; ++i) {
                this._out.write(a.charAt(i));
            }
            this._out.write(0);
        }
    }

    public void write_wstring(String a) {
        if (a == null) {
            this.write_long(0);
            return;
        }
        int length = a.length();
        this.write_long(length + 1);
        for (int i = 0; i < length; ++i) {
            this._out.writeShort(a.charAt(i));
        }
        this._out.writeShort(0);
    }

    public void write_Object(Object obj) {
        if (obj == null) {
            this.write_long(1);
            this.write(0);
            this.write_long(0);
        } else {
            this.writeIOR(((DummyObjectImpl)obj).getIOR());
        }
    }

    public void write_TypeCode(TypeCode tc) {
        if (tc == null) {
            this.write_long(0);
            return;
        }
        try {
            switch (tc.kind().value()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 23: 
                case 24: 
                case 25: 
                case 26: {
                    this.write_long(tc.kind().value());
                    break;
                }
                case 18: {
                    this.write_long(tc.kind().value());
                    this.write_long(tc.length());
                    break;
                }
                case 19: {
                    SequenceTypeCode.writeTypeCode(this, tc);
                    break;
                }
                case 29: {
                    ValueTypeCode.writeTypeCode(this, tc);
                    break;
                }
                case 30: {
                    ValueBoxTypeCode.writeTypeCode(this, tc);
                    break;
                }
                case 32: {
                    AbstractInterfaceTypeCode.writeTypeCode(this, tc);
                    break;
                }
                default: {
                    System.out.println("UNKNOWN TC: " + tc + " " + tc.kind() + " " + tc.kind().value());
                    throw new UnsupportedOperationException(String.valueOf(tc));
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void write_abstract_interface(java.lang.Object obj) {
        this.write_boolean(false);
        if (obj instanceof Serializable || obj == null) {
            this.write_value((Serializable)obj);
        } else {
            this.write_value((Serializable)((java.lang.Object)((IiopProxyHandler)obj).getStub()));
        }
    }

    public void write_any(Any any) {
        this.write_TypeCode(any.type());
        any.write_value((org.omg.CORBA.portable.OutputStream)this);
    }

    public void write_Principal(Principal principal) {
        throw new UnsupportedOperationException();
    }

    public void write_value(Serializable obj, Class javaType) {
        this.write_value(obj);
    }

    public void write_value(Serializable obj) {
        ValueHandler valueHandler = this._context.getValueHandler();
        if (obj == null) {
            this.write_long(0);
            return;
        }
        if (obj instanceof String) {
            this.write_long(2147483394);
            this.write_string("IDL:omg.org/CORBA/WStringValue:1.0");
            this.write_wstring((String)((java.lang.Object)obj));
        } else if (obj instanceof Class) {
            this.write_long(2147483394);
            this.write_string(valueHandler.getRMIRepositoryID(ClassDesc.class));
            this.write_value((Serializable)((java.lang.Object)valueHandler.getRMIRepositoryID((Class)obj)));
            this.write_value((Serializable)((java.lang.Object)valueHandler.getRMIRepositoryID((Class)obj)));
        } else if (obj instanceof IDLEntity) {
            try {
                Class<?> helperClass = Class.forName(obj.getClass().getName() + "Helper", false, obj.getClass().getClassLoader());
                Method writeHelper = helperClass.getMethod("write", org.omg.CORBA.portable.OutputStream.class, obj.getClass());
                writeHelper.invoke(null, new java.lang.Object[]{this, obj});
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        } else {
            int oldValue = this._context.getRef(obj);
            if (oldValue < 0) {
                this._out.align(4);
                this._context.putRef(obj, this.getOffset());
                this.write_long(2147483394);
                String repId = valueHandler.getRMIRepositoryID(obj.getClass());
                this.write_string(repId);
                valueHandler.writeValue((org.omg.CORBA.portable.OutputStream)this, obj);
            } else {
                this._out.align(4);
                this.write_long(-1);
                int delta = oldValue - this.getOffset();
                this.write_long(delta);
            }
        }
    }

    public void write(int b) {
        this.write_long(b);
    }

    public void write_boolean(boolean v) {
        this._out.write(v ? 1 : 0);
    }

    public void write_octet(byte v) {
        this._out.write(v);
    }

    public void write_short(short v) {
        this._out.align(2);
        this._out.writeShort(v);
    }

    public void write_ushort(short v) {
        this._out.align(2);
        this._out.writeShort(v);
    }

    public void write_char(char v) {
        this._out.write(v);
    }

    public void write_wchar(char v) {
        this._out.align(2);
        this._out.writeShort(v);
    }

    public void write_long(int v) {
        this._out.align(4);
        this._out.writeInt(v);
    }

    public void write_ulong(int v) {
        this._out.align(4);
        this._out.writeInt(v);
    }

    public void write_longlong(long v) {
        this._out.align(8);
        this._out.writeLong(v);
    }

    public void write_ulonglong(long v) {
        this._out.align(8);
        this._out.writeLong(v);
    }

    public void write_float(float v) {
        int bits = Float.floatToIntBits(v);
        this._out.align(4);
        this._out.writeInt(bits);
    }

    public void write_double(double v) {
        long bits = Double.doubleToLongBits(v);
        this._out.align(8);
        this._out.writeLong(bits);
    }

    public void writeString(String v) {
        if (v == null) {
            this.write_long(0);
            return;
        }
        int len = v.length();
        this.write_long(len + 1);
        for (int i = 0; i < len; ++i) {
            this._out.write(v.charAt(i));
        }
        this._out.write(0);
    }

    public void writeBytes(byte[] b, int off, int len) {
        this.write_long(len);
        this._out.write(b, off, len);
    }

    public void write(byte[] b, int off, int len) {
        this._out.write(b, off, len);
    }

    public IiopReader _call() throws IOException {
        this._out.close();
        this._reader.readRequest();
        return this._reader;
    }

    public final int getOffset() {
        if (this._parent != null) {
            return this._parent.getOffset() + 4 + this._out.getOffset();
        }
        return this._out.getOffset();
    }
}

