/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.iiop;

import com.caucho.iiop.MessageReader;
import com.caucho.vfs.TempBuffer;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;

class InputStreamMessageReader
extends MessageReader {
    private InputStream _is;
    private int _offset;
    private int _chunkOffset;
    private int _align;
    private TempBuffer _tempBuffer;
    private byte[] _buffer;
    private int _length;
    private boolean _isLast;

    InputStreamMessageReader(InputStream is, boolean isLast, int offset) {
        try {
            this._is = is;
            this._isLast = isLast;
            this._length = ((this._is.read() & 0xFF) << 24) + ((this._is.read() & 0xFF) << 16) + ((this._is.read() & 0xFF) << 8) + (this._is.read() & 0xFF);
            if (this._length <= 16384) {
                this._tempBuffer = TempBuffer.allocate();
                this._buffer = this._tempBuffer.getBuffer();
            } else {
                this._buffer = new byte[this._length + (1024 - this._length % 1024) % 1024];
            }
            is.read(this._buffer, 0, this._length);
            this._chunkOffset = offset = 12;
            this._offset = offset;
            this._align = 0;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public int getOffset() {
        return this._offset + this._align;
    }

    public int setOffset(int offset) {
        int oldOffset = this._offset + this._align;
        this._align = offset - this._offset;
        return oldOffset;
    }

    public int read() {
        try {
            if (this._length <= this._offset - this._chunkOffset) {
                this.readFragmentHeader();
            }
            return this._buffer[this._offset++ - this._chunkOffset] & 0xFF;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void read(byte[] buffer, int offset, int length) {
        try {
            while (length > 0) {
                int sublen = this._length - (this._offset - this._chunkOffset);
                if (sublen <= 0) {
                    this.readFragmentHeader();
                    sublen = this._length - (this._offset - this._chunkOffset);
                }
                if (length < sublen) {
                    sublen = length;
                }
                System.arraycopy(this._buffer, this._offset - this._chunkOffset, buffer, offset, sublen);
                if (sublen < 0) {
                    throw new IOException("unexpected end of file");
                }
                offset += sublen;
                length -= sublen;
                this._offset += sublen;
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void readFragmentHeader() throws IOException {
        if (this._isLast) {
            throw new EOFException("read past end of file");
        }
        if (this._is.read() != 71 || this._is.read() != 73 || this._is.read() != 79 || this._is.read() != 80) {
            throw new IOException("Missing GIOP header.");
        }
        int major = this._is.read();
        int minor = this._is.read();
        if (major != 1) {
            throw new IOException("unknown major");
        }
        int flags = this._is.read();
        int type = this._is.read();
        if (type != 7) {
            throw new IOException("expected fragment at " + type);
        }
        this._isLast = (flags & 2) != 2;
        this._chunkOffset = this._offset;
        this._length = ((this._is.read() & 0xFF) << 24) + ((this._is.read() & 0xFF) << 16) + ((this._is.read() & 0xFF) << 8) + (this._is.read() & 0xFF);
        if (minor >= 2) {
            int reqId = ((this._is.read() & 0xFF) << 24) + ((this._is.read() & 0xFF) << 16) + ((this._is.read() & 0xFF) << 8) + (this._is.read() & 0xFF);
            this._length -= 4;
        }
        if (this._length < 0 || this._length > 65536) {
            throw new RuntimeException();
        }
        this._is.read(this._buffer, 0, this._length);
    }

    private void writeHexGroup(byte[] buffer, int offset, int length) {
        int end = offset + length;
        while (offset < end) {
            int j;
            int chunkLength = 16;
            for (j = 0; j < chunkLength; ++j) {
                System.out.print(" ");
                this.printHex(buffer[offset + j]);
            }
            System.out.print(" ");
            for (j = 0; j < chunkLength; ++j) {
                this.printCh(buffer[offset + j]);
            }
            offset += chunkLength;
            System.out.println();
        }
    }

    private void printHex(int d) {
        int ch1 = d >> 4 & 0xF;
        int ch2 = d & 0xF;
        if (ch1 >= 10) {
            System.out.print((char)(97 + ch1 - 10));
        } else {
            System.out.print((char)(48 + ch1));
        }
        if (ch2 >= 10) {
            System.out.print((char)(97 + ch2 - 10));
        } else {
            System.out.print((char)(48 + ch2));
        }
    }

    private void printCh(int d) {
        if (d >= 32 && d <= 127) {
            System.out.print("" + (char)d);
        } else {
            System.out.print(".");
        }
    }

    private String toCh(int d) {
        if (d >= 32 && d <= 127) {
            return "" + (char)d;
        }
        return "" + d;
    }

    private static String toHex(int v) {
        StringBuilder cb = new StringBuilder();
        for (int i = 28; i >= 0; i -= 4) {
            int h = v >> i & 0xF;
            if (h >= 10) {
                cb.append((char)(97 + h - 10));
                continue;
            }
            cb.append(h);
        }
        return cb.toString();
    }
}

