/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.iiop;

import com.caucho.ejb.AbstractEJBObject;
import com.caucho.ejb.AbstractServer;
import com.caucho.iiop.DummyObjectImpl;
import com.caucho.iiop.IOR;
import com.caucho.iiop.IiopReader;
import com.caucho.iiop.IiopWriter;
import com.caucho.log.Log;
import com.caucho.server.util.CauchoSystem;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.rmi.Remote;
import java.util.logging.Logger;
import javax.ejb.EJBHome;
import javax.ejb.EJBObject;
import javax.rmi.CORBA.Util;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;
import org.omg.CORBA.portable.Streamable;

public class MarshallObject {
    private static final Logger log = Log.open(MarshallObject.class);
    public static final int VOID = -1;
    public static final int BOOLEAN = 0;
    public static final int BYTE = 1;
    public static final int SHORT = 2;
    public static final int CHAR = 3;
    public static final int INT = 4;
    public static final int LONG = 5;
    public static final int FLOAT = 6;
    public static final int DOUBLE = 7;
    public static final int STRING = 8;
    public static final int BOOLEAN_ARRAY = 9;
    public static final int BYTE_ARRAY = 10;
    public static final int SHORT_ARRAY = 11;
    public static final int CHAR_ARRAY = 12;
    public static final int INT_ARRAY = 13;
    public static final int LONG_ARRAY = 14;
    public static final int FLOAT_ARRAY = 15;
    public static final int DOUBLE_ARRAY = 16;
    public static final int STRING_ARRAY = 17;
    public static final int OBJECT = 20;
    public static final int CORBA_OBJECT = 21;
    public static final int REMOTE = 22;
    public static final int EJB_HOME = 23;
    public static final int EJB_OBJECT = 24;
    public static final int OBJECT_ARRAY = 25;
    public static final int OBJECT_HELPER = 26;
    public static final int STREAMABLE = 27;
    private int _code;
    private Class _objClass;
    private MarshallObject _subObj;
    private Method _readHelper;
    private Method _writeHelper;
    private static final MarshallObject MARSHALL_SHORT = new MarshallObject(){

        public java.lang.Object unmarshall(IiopReader reader) throws Exception {
            short v = reader.read_short();
            return new Short(v);
        }

        public void marshall(java.lang.Object obj, IiopWriter writer) throws Exception {
            writer.write_short(((Number)obj).shortValue());
        }
    };
    private static final MarshallObject MARSHALL_CHAR = new MarshallObject(){

        public java.lang.Object unmarshall(IiopReader reader) throws Exception {
            char v = reader.read_wchar();
            return new Character(v);
        }

        public void marshall(java.lang.Object obj, IiopWriter writer) throws Exception {
            writer.write_wchar(((Character)obj).charValue());
        }
    };
    private static final MarshallObject MARSHALL_LONG = new MarshallObject(){

        public java.lang.Object unmarshall(IiopReader reader) throws Exception {
            return new Long(reader.read_longlong());
        }

        public void marshall(java.lang.Object obj, IiopWriter writer) throws Exception {
            writer.write_longlong((Long)obj);
        }
    };

    private MarshallObject() {
    }

    private MarshallObject(int code) {
        this._code = code;
    }

    private MarshallObject(int code, Class cl) {
        this._code = code;
        this._objClass = cl;
    }

    private MarshallObject(int code, Class cl, Method readHelper, Method writeHelper) {
        this._code = code;
        this._objClass = cl;
        this._readHelper = readHelper;
        this._writeHelper = writeHelper;
    }

    static MarshallObject create(Class cl, boolean isJava) {
        if (Void.TYPE.equals(cl)) {
            return new MarshallObject(-1);
        }
        if (Boolean.TYPE.equals(cl)) {
            return new MarshallObject(0);
        }
        if (Byte.TYPE.equals(cl)) {
            return new MarshallObject(1);
        }
        if (Short.TYPE.equals(cl)) {
            return MARSHALL_SHORT;
        }
        if (Character.TYPE.equals(cl)) {
            return MARSHALL_CHAR;
        }
        if (Integer.TYPE.equals(cl)) {
            return new MarshallObject(4);
        }
        if (Long.TYPE.equals(cl)) {
            return MARSHALL_LONG;
        }
        if (Float.TYPE.equals(cl)) {
            return new MarshallObject(6);
        }
        if (Double.TYPE.equals(cl)) {
            return new MarshallObject(7);
        }
        if (String.class.equals((java.lang.Object)cl)) {
            return new MarshallObject(8);
        }
        if (String[].class.equals((java.lang.Object)cl) && !isJava) {
            return new MarshallObject(17);
        }
        if (EJBHome.class.isAssignableFrom(cl)) {
            return new MarshallObject(23, cl);
        }
        if (EJBObject.class.isAssignableFrom(cl)) {
            return new MarshallObject(24, cl);
        }
        if (Remote.class.isAssignableFrom(cl)) {
            return new MarshallObject(22, cl);
        }
        if (Object.class.isAssignableFrom(cl)) {
            return new MarshallObject(21, cl);
        }
        if (cl.isArray() && !isJava) {
            Class<?> compType = cl.getComponentType();
            MarshallObject subObj = MarshallObject.create(compType, isJava);
            MarshallObject obj = new MarshallObject(25, compType);
            obj._subObj = subObj;
            return obj;
        }
        if (Streamable.class.isAssignableFrom(cl)) {
            return new MarshallObject(27, cl);
        }
        Class helperClass = null;
        Method readHelper = null;
        Method writeHelper = null;
        try {
            helperClass = CauchoSystem.loadClass(cl.getName() + "Helper");
            readHelper = helperClass.getMethod("read", InputStream.class);
            writeHelper = helperClass.getMethod("write", OutputStream.class, cl);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (readHelper != null) {
            return new MarshallObject(26, cl, readHelper, writeHelper);
        }
        return new MarshallObject(20, cl);
    }

    public java.lang.Object unmarshall(IiopReader reader) throws Exception {
        switch (this._code) {
            case 0: {
                return new Boolean(reader.read_boolean());
            }
            case 1: {
                return new Byte(reader.read_octet());
            }
            case 2: {
                return new Short(reader.read_short());
            }
            case 3: {
                return new Character(reader.read_wchar());
            }
            case 4: {
                return new Integer(reader.read_long());
            }
            case 5: {
                return new Long(reader.read_longlong());
            }
            case 6: {
                return new Float(reader.read_float());
            }
            case 7: {
                return new Double(reader.read_double());
            }
            case 8: {
                return (String)((java.lang.Object)reader.read_value(String.class));
            }
            case 9: {
                boolean[] array = new boolean[reader.read_sequence_length()];
                reader.read_boolean_array(array, 0, array.length);
                return array;
            }
            case 10: {
                byte[] array = new byte[reader.read_sequence_length()];
                reader.read_octet_array(array, 0, array.length);
                return array;
            }
            case 12: {
                char[] array = new char[reader.read_sequence_length()];
                reader.read_wchar_array(array, 0, array.length);
                return array;
            }
            case 11: {
                short[] array = new short[reader.read_sequence_length()];
                reader.read_short_array(array, 0, array.length);
                return array;
            }
            case 13: {
                int[] array = new int[reader.read_sequence_length()];
                reader.read_long_array(array, 0, array.length);
                return array;
            }
            case 14: {
                long[] array = new long[reader.read_sequence_length()];
                reader.read_longlong_array(array, 0, array.length);
                return array;
            }
            case 15: {
                float[] array = new float[reader.read_sequence_length()];
                reader.read_float_array(array, 0, array.length);
                return array;
            }
            case 16: {
                double[] array = new double[reader.read_sequence_length()];
                reader.read_double_array(array, 0, array.length);
                return array;
            }
            case 22: {
                return reader.readObject(this._objClass);
            }
            case 21: {
                return reader.read_Object();
            }
            case 25: {
                int len = reader.read_sequence_length();
                java.lang.Object[] obj = (java.lang.Object[])Array.newInstance(this._objClass, len);
                for (int i = 0; i < len; ++i) {
                    obj[i] = this._subObj.unmarshall(reader);
                }
                return obj;
            }
            case 26: {
                return this._readHelper.invoke(null, new java.lang.Object[]{reader});
            }
        }
        try {
            log.info("Class: " + this._objClass);
            return reader.read_value(this._objClass);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public void marshall(java.lang.Object obj, IiopWriter writer) throws Exception {
        switch (this._code) {
            case 0: {
                writer.write_boolean((Boolean)obj);
                break;
            }
            case 1: {
                writer.write_octet((Byte)obj);
                break;
            }
            case 2: {
                writer.write_short((Short)obj);
                break;
            }
            case 4: {
                writer.write_long((Integer)obj);
                break;
            }
            case 5: {
                writer.write_longlong((Long)obj);
                break;
            }
            case 6: {
                writer.write_float(((Float)obj).floatValue());
                break;
            }
            case 7: {
                writer.write_double((Double)obj);
                break;
            }
            case 3: {
                writer.write_wchar(((Character)obj).charValue());
                break;
            }
            case 8: {
                writer.write_value((Serializable)((java.lang.Object)((String)obj)), String.class);
                break;
            }
            case 22: 
            case 24: {
                if (obj instanceof AbstractEJBObject) {
                    AbstractEJBObject absObj = (AbstractEJBObject)obj;
                    AbstractServer server = absObj.__caucho_getServer();
                    String local = absObj.__caucho_getId();
                    String url = server.getProtocolId() + "?" + local;
                    String typeName = "RMI:" + this._objClass.getName() + ":0";
                    IOR ior = new IOR(typeName, writer.getHost(), writer.getPort(), url);
                    writer.write_Object((Object)new DummyObjectImpl(ior));
                    break;
                }
                writer.write_value((Serializable)obj);
                break;
            }
            case 23: {
                Util.writeRemoteObject((OutputStream)writer, (java.lang.Object)obj);
                break;
            }
            case 21: {
                writer.write_Object((Object)obj);
                break;
            }
            case 26: {
                this._writeHelper.invoke(null, new java.lang.Object[]{writer, obj});
                break;
            }
            default: {
                writer.write_value((Serializable)obj);
            }
        }
    }
}

