/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.iiop;

public abstract class MessageReader {
    public abstract int getOffset();

    public abstract int setOffset(int var1);

    public void addOffset(int delta) {
        this.setOffset(this.getOffset() + delta);
    }

    public abstract int read();

    public void read(byte[] buffer, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            buffer[i + offset] = (byte)this.read();
        }
    }

    public int read_short() {
        int offset = this.getOffset();
        while (offset % 2 != 0) {
            ++offset;
            this.read();
        }
        return ((this.read() & 0xFF) << 8) + (this.read() & 0xFF);
    }

    public int read_long() {
        int offset = this.getOffset();
        while (offset % 4 != 0) {
            ++offset;
            this.read();
        }
        int v = ((this.read() & 0xFF) << 24) + ((this.read() & 0xFF) << 16) + ((this.read() & 0xFF) << 8) + (this.read() & 0xFF);
        return v;
    }

    public long read_longlong() {
        int offset = this.getOffset();
        while (offset % 8 != 0) {
            ++offset;
            this.read();
        }
        return (((long)this.read() & 0xFFL) << 56) + (((long)this.read() & 0xFFL) << 48) + (((long)this.read() & 0xFFL) << 40) + (((long)this.read() & 0xFFL) << 32) + (((long)this.read() & 0xFFL) << 24) + (((long)this.read() & 0xFFL) << 16) + (((long)this.read() & 0xFFL) << 8) + ((long)this.read() & 0xFFL);
    }

    public void skip(int len) {
        while (len > 0) {
            this.read();
            --len;
        }
    }

    public void align(int v) {
        int offset = this.getOffset();
        while (offset % v != 0) {
            ++offset;
            this.read();
        }
    }

    public void close() {
    }
}

