/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.iiop;

import com.caucho.ejb.AbstractEJBObject;
import com.caucho.iiop.IiopReader;
import com.caucho.iiop.IiopSkeleton;
import com.caucho.iiop.IiopWriter;
import com.caucho.iiop.marshal.AnyMarshal;
import com.caucho.iiop.marshal.Marshal;
import com.caucho.iiop.marshal.RemoteMarshal;
import com.caucho.iiop.orb.EjbSessionObjectMarshal;
import com.caucho.iiop.orb.MarshalFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.rmi.RemoteException;
import java.util.logging.Logger;

public class SkeletonMethod {
    private static final Logger log = Logger.getLogger(SkeletonMethod.class.getName());
    private IiopSkeleton _skeleton;
    private Method _method;
    private Marshal[] _marshalArgs;
    private Marshal _marshalReturn;
    private Class[] _exnTypes;

    SkeletonMethod(IiopSkeleton skeleton, Method method, boolean isJava) {
        this._skeleton = skeleton;
        this._method = method;
        MarshalFactory factory = MarshalFactory.create();
        Class<?>[] paramTypes = method.getParameterTypes();
        this._marshalArgs = new Marshal[paramTypes.length];
        for (int i = 0; i < this._marshalArgs.length; ++i) {
            this._marshalArgs[i] = factory.create(paramTypes[i], !isJava);
        }
        this._marshalReturn = factory.create(method.getReturnType(), !isJava);
        this._exnTypes = method.getExceptionTypes();
    }

    void service(Object object, IiopReader reader, IiopWriter writer) throws Throwable {
        Object[] args = new Object[this._marshalArgs.length];
        if (args.length > 0) {
            reader.alignMethodArgs();
        }
        Class<?>[] paramTypes = this._method.getParameterTypes();
        for (int i = 0; i < args.length; ++i) {
            if (this._marshalArgs[i] instanceof AnyMarshal) {
                this._marshalArgs[i] = new RemoteMarshal(paramTypes[i]);
            }
            args[i] = this._marshalArgs[i].unmarshal(reader);
        }
        try {
            Object result = this._method.invoke(object, args);
            writer.startReplyOk(reader.getRequestId());
            if (result != null && result instanceof AbstractEJBObject) {
                this._marshalReturn = new EjbSessionObjectMarshal(this._method.getReturnType(), this._skeleton);
            }
            this._marshalReturn.marshal(writer, result);
        }
        catch (InvocationTargetException e) {
            Throwable cause = e.getCause();
            if (cause instanceof RemoteException) {
                throw cause;
            }
            for (int i = 0; i < this._exnTypes.length; ++i) {
                if (!this._exnTypes[i].isAssignableFrom(cause.getClass())) continue;
                throw cause;
            }
            throw new RemoteException(cause.toString(), cause);
        }
    }
}

