/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.iiop;

import com.caucho.iiop.IiopReader;
import java.io.IOException;

public class UnmarshallObject {
    public static final int BOOLEAN = 0;
    public static final int BYTE = 1;
    public static final int SHORT = 2;
    public static final int CHAR = 3;
    public static final int INT = 4;
    public static final int LONG = 5;
    public static final int FLOAT = 6;
    public static final int DOUBLE = 7;
    public static final int STRING = 8;
    public static final int BOOLEAN_ARRAY = 9;
    public static final int BYTE_ARRAY = 10;
    public static final int SHORT_ARRAY = 11;
    public static final int CHAR_ARRAY = 12;
    public static final int INT_ARRAY = 13;
    public static final int LONG_ARRAY = 14;
    public static final int FLOAT_ARRAY = 15;
    public static final int DOUBLE_ARRAY = 16;
    public static final int STRING_ARRAY = 17;
    private int code;

    private UnmarshallObject(int code) {
        this.code = code;
    }

    public Object unmarshall(IiopReader reader) throws IOException {
        switch (this.code) {
            case 0: {
                return new Boolean(reader.read_boolean());
            }
            case 1: {
                return new Byte(reader.read_octet());
            }
            case 2: {
                return new Short(reader.read_short());
            }
            case 3: {
                return new Character(reader.read_wchar());
            }
            case 4: {
                return new Integer(reader.read_long());
            }
            case 5: {
                return new Long(reader.read_longlong());
            }
            case 6: {
                return new Float(reader.read_float());
            }
            case 7: {
                return new Double(reader.read_double());
            }
            case 8: {
                return reader.read_wstring();
            }
            case 9: {
                boolean[] array = new boolean[reader.read_sequence_length()];
                reader.read_boolean_array(array, 0, array.length);
                return array;
            }
            case 10: {
                byte[] array = new byte[reader.read_sequence_length()];
                reader.read_octet_array(array, 0, array.length);
                return array;
            }
            case 12: {
                char[] array = new char[reader.read_sequence_length()];
                reader.read_wchar_array(array, 0, array.length);
                return array;
            }
            case 11: {
                short[] array = new short[reader.read_sequence_length()];
                reader.read_short_array(array, 0, array.length);
                return array;
            }
            case 13: {
                int[] array = new int[reader.read_sequence_length()];
                reader.read_long_array(array, 0, array.length);
                return array;
            }
            case 14: {
                long[] array = new long[reader.read_sequence_length()];
                reader.read_longlong_array(array, 0, array.length);
                return array;
            }
            case 15: {
                float[] array = new float[reader.read_sequence_length()];
                reader.read_float_array(array, 0, array.length);
                return array;
            }
            case 16: {
                double[] array = new double[reader.read_sequence_length()];
                reader.read_double_array(array, 0, array.length);
                return array;
            }
            case 17: {
                String[] array = new String[reader.read_sequence_length()];
                for (int i = 0; i < array.length; ++i) {
                    array[i] = reader.read_wstring();
                }
                return array;
            }
        }
        throw new IOException("unknown type");
    }
}

