/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.iiop.any;

import com.caucho.iiop.any.AbstractTypeCode;
import com.caucho.iiop.any.BooleanTypeCode;
import com.caucho.iiop.any.DoubleTypeCode;
import com.caucho.iiop.any.FloatTypeCode;
import com.caucho.iiop.any.LongLongTypeCode;
import com.caucho.iiop.any.LongTypeCode;
import com.caucho.iiop.any.NullTypeCode;
import com.caucho.iiop.any.OctetTypeCode;
import com.caucho.iiop.any.SequenceTypeCode;
import com.caucho.iiop.any.ShortTypeCode;
import com.caucho.iiop.any.StringTypeCode;
import com.caucho.iiop.any.ValueBoxTypeCode;
import com.caucho.iiop.any.ValueTypeCode;
import com.caucho.iiop.any.WcharTypeCode;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import javax.rmi.CORBA.Util;
import javax.rmi.CORBA.ValueHandler;

public class TypeCodeFactory {
    private static final ValueHandler _valueHandler = Util.createValueHandler();
    public static final HashMap<Class, AbstractTypeCode> _staticTypeCodeMap = new HashMap();
    public final HashMap<Class, AbstractTypeCode> _typeCodeMap = new HashMap();

    public AbstractTypeCode createTypeCode(Class cl) {
        if (cl == null) {
            return NullTypeCode.TYPE_CODE;
        }
        AbstractTypeCode typeCode = _staticTypeCodeMap.get(cl);
        if (typeCode != null) {
            return typeCode;
        }
        typeCode = this._typeCodeMap.get(cl);
        if (typeCode != null) {
            return typeCode;
        }
        if (cl.isArray()) {
            AbstractTypeCode contentType = this.createTypeCode(cl.getComponentType());
            typeCode = new ValueBoxTypeCode(_valueHandler.getRMIRepositoryID(cl), cl.getName(), new SequenceTypeCode(contentType));
        } else {
            typeCode = this.introspectClass(cl);
        }
        this._typeCodeMap.put(cl, typeCode);
        return typeCode;
    }

    private AbstractTypeCode introspectClass(Class type) {
        ValueTypeCode valueTypeCode = new ValueTypeCode(_valueHandler.getRMIRepositoryID(type), type.getName());
        this._typeCodeMap.put(type, valueTypeCode);
        if (!Object.class.equals(type.getSuperclass())) {
            valueTypeCode.setBaseTypeCode(this.createTypeCode(type.getSuperclass()));
        }
        for (Field field : type.getDeclaredFields()) {
            if (Modifier.isTransient(field.getModifiers()) || Modifier.isStatic(field.getModifiers())) continue;
            short visibility = 0;
            valueTypeCode.addMember(field.getName(), this.createTypeCode(field.getType()), visibility);
        }
        return valueTypeCode;
    }

    private static AbstractTypeCode valueBox(Class type, AbstractTypeCode contentType) {
        ValueHandler valueHandler = Util.createValueHandler();
        return new ValueBoxTypeCode(valueHandler.getRMIRepositoryID(type), type.getName(), contentType);
    }

    private static AbstractTypeCode array(Class type) {
        ValueHandler valueHandler = Util.createValueHandler();
        Class<?> componentType = type.getComponentType();
        AbstractTypeCode contentType = _staticTypeCodeMap.get(componentType);
        return new ValueBoxTypeCode(valueHandler.getRMIRepositoryID(type), type.getName(), new SequenceTypeCode(contentType));
    }

    static {
        ValueHandler valueHandler = Util.createValueHandler();
        _staticTypeCodeMap.put(Boolean.TYPE, BooleanTypeCode.TYPE_CODE);
        _staticTypeCodeMap.put(Boolean.class, TypeCodeFactory.valueBox(Boolean.class, BooleanTypeCode.TYPE_CODE));
        _staticTypeCodeMap.put(Character.TYPE, WcharTypeCode.TYPE_CODE);
        _staticTypeCodeMap.put(Character.class, TypeCodeFactory.valueBox(Character.class, WcharTypeCode.TYPE_CODE));
        _staticTypeCodeMap.put(Byte.TYPE, OctetTypeCode.TYPE_CODE);
        _staticTypeCodeMap.put(Byte.class, TypeCodeFactory.valueBox(Byte.class, OctetTypeCode.TYPE_CODE));
        _staticTypeCodeMap.put(Short.TYPE, ShortTypeCode.TYPE_CODE);
        _staticTypeCodeMap.put(Short.class, TypeCodeFactory.valueBox(Short.class, ShortTypeCode.TYPE_CODE));
        _staticTypeCodeMap.put(Integer.TYPE, LongTypeCode.TYPE_CODE);
        _staticTypeCodeMap.put(Integer.class, TypeCodeFactory.valueBox(Integer.class, LongTypeCode.TYPE_CODE));
        _staticTypeCodeMap.put(Long.TYPE, LongLongTypeCode.TYPE_CODE);
        _staticTypeCodeMap.put(Long.class, TypeCodeFactory.valueBox(Long.class, LongLongTypeCode.TYPE_CODE));
        _staticTypeCodeMap.put(Float.TYPE, FloatTypeCode.TYPE_CODE);
        _staticTypeCodeMap.put(Float.class, TypeCodeFactory.valueBox(Float.class, FloatTypeCode.TYPE_CODE));
        _staticTypeCodeMap.put(Double.TYPE, DoubleTypeCode.TYPE_CODE);
        _staticTypeCodeMap.put(Double.class, TypeCodeFactory.valueBox(Double.class, DoubleTypeCode.TYPE_CODE));
        _staticTypeCodeMap.put(String.class, TypeCodeFactory.valueBox(String.class, StringTypeCode.TYPE_CODE));
        _staticTypeCodeMap.put(boolean[].class, TypeCodeFactory.array(boolean[].class));
        _staticTypeCodeMap.put(char[].class, TypeCodeFactory.array(char[].class));
        _staticTypeCodeMap.put(byte[].class, TypeCodeFactory.array(byte[].class));
        _staticTypeCodeMap.put(short[].class, TypeCodeFactory.array(short[].class));
        _staticTypeCodeMap.put(int[].class, TypeCodeFactory.array(int[].class));
        _staticTypeCodeMap.put(long[].class, TypeCodeFactory.array(long[].class));
        _staticTypeCodeMap.put(float[].class, TypeCodeFactory.array(float[].class));
        _staticTypeCodeMap.put(double[].class, TypeCodeFactory.array(double[].class));
    }
}

