/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.iiop.any;

import com.caucho.iiop.IiopReader;
import com.caucho.iiop.any.AbstractBaseTypeCode;
import com.caucho.iiop.any.AbstractTypeCode;
import com.caucho.iiop.any.ValueBoxTypeCode;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;

public class TypeCodeImpl
extends AbstractTypeCode {
    protected static final L10N L = new L10N(TypeCodeImpl.class);
    protected static final Logger log = Logger.getLogger(TypeCodeImpl.class.getName());
    public static final TypeCode TK_NULL = new TypeCodeImpl(TCKind.tk_null);
    public static final int TK_VOID = 1;
    public static final int TK_SHORT = 2;
    public static final TypeCode TK_LONG = new TypeCodeImpl(TCKind.tk_long);
    public static final int TK_USHORT = 4;
    public static final int TK_ULONG = 5;
    public static final int TK_FLOAT = 6;
    public static final int TK_DOUBLE = 7;
    public static final int TK_BOOLEAN = 8;
    public static final int TK_CHAR = 9;
    public static final TypeCode TK_OCTET = new TypeCodeImpl(TCKind.tk_octet);
    public static final int TK_ANY = 11;
    public static final int TK_TYPE_CODE = 12;
    public static final int TK_PRINCIPAL = 13;
    public static final int TK_OBJREF = 14;
    public static final int TK_UNION = 16;
    public static final int TK_ENUM = 17;
    public static final int TK_STRING = 18;
    public static final int TK_SEQUENCE = 19;
    public static final int TK_ARRAY = 20;
    public static final int TK_ALIAS = 21;
    public static final int TK_EXCEPT = 22;
    public static final int TK_LONGLONG = 23;
    public static final int TK_ULONGLONG = 24;
    public static final int TK_LONGDOUBLE = 25;
    public static final int TK_WCHAR = 26;
    public static final int TK_WSTRING = 27;
    public static final int TK_FIXED = 28;
    public static final int TK_VALUE = 29;
    public static final int TK_VALUE_BOX = 30;
    public static final int TK_NATIVE = 31;
    public static final int TK_ABSTRACT_INTERFACE = 32;
    private TCKind _kind;
    private String _id;
    private short _typeModifier;
    private TypeCode _concreteBaseType;
    private ArrayList<Member> _members = new ArrayList();
    private TypeCode _contentType;
    private int _length;

    public TypeCodeImpl(TCKind kind) {
        if (kind == null) {
            throw new NullPointerException();
        }
        this._kind = kind;
    }

    private TypeCodeImpl(TCKind kind, String repId, short modifier) {
        this._kind = kind;
        this._id = repId;
        this._typeModifier = modifier;
    }

    private TypeCodeImpl(TCKind kind, String repId) {
        this._kind = kind;
        this._id = repId;
    }

    public static TypeCodeImpl createValue(String repId, String name, short modifier) {
        return new TypeCodeImpl(TCKind.tk_value, repId, modifier);
    }

    public static TypeCodeImpl createAbstractInterface(String repId, String name) {
        return new TypeCodeImpl(TCKind.tk_abstract_interface, repId);
    }

    public static TypeCodeImpl createSequence() {
        return new TypeCodeImpl(TCKind.tk_sequence);
    }

    public boolean equal(TypeCode tc) {
        return tc == this;
    }

    public boolean equivalent(TypeCode tc) {
        return tc == this;
    }

    public TypeCode get_compact_typecode() {
        return this;
    }

    public TCKind kind() {
        return this._kind;
    }

    public String id() throws BadKind {
        return this._id;
    }

    public String name() throws BadKind {
        return "";
    }

    public short type_modifier() throws BadKind {
        return this._typeModifier;
    }

    public void setConcreteBaseType(TypeCode baseType) {
        this._concreteBaseType = baseType;
    }

    public TypeCode concrete_base_type() throws BadKind {
        return this._concreteBaseType;
    }

    public int member_count() throws BadKind {
        return this._members.size();
    }

    public void addMember(String name, TypeCode type, short visibility) {
        this._members.add(new Member(name, type, visibility));
    }

    public String member_name(int index) throws BadKind, Bounds {
        return this._members.get(index).getName();
    }

    public TypeCode member_type(int index) throws BadKind, Bounds {
        return this._members.get(index).getType();
    }

    public short member_visibility(int index) throws BadKind, Bounds {
        throw new UnsupportedOperationException();
    }

    public Any member_label(int index) throws BadKind, Bounds {
        return null;
    }

    public TypeCode discriminator_type() throws BadKind {
        throw new UnsupportedOperationException();
    }

    public int default_index() throws BadKind {
        throw new UnsupportedOperationException();
    }

    public void setLength(int length) {
        this._length = length;
    }

    public int length() throws BadKind {
        return this._length;
    }

    public void setContentType(TypeCode type) {
        this._contentType = type;
    }

    public TypeCode content_type() throws BadKind {
        return this._contentType;
    }

    public short fixed_digits() throws BadKind {
        throw new UnsupportedOperationException();
    }

    public short fixed_scale() throws BadKind {
        throw new UnsupportedOperationException();
    }

    public static AbstractTypeCode read(IiopReader reader) throws IOException {
        int tcKind = reader.readInt();
        switch (tcKind) {
            case 30: {
                return ValueBoxTypeCode.readTypeCode(reader);
            }
            case 32: {
                int len = reader.read_sequence_length();
                int offset = reader.getOffset();
                int tail = offset + len;
                byte endian = reader.read_octet();
                String repId = reader.readString();
                String name = reader.readString();
                return new AbstractBaseTypeCode(TCKind.from_int((int)tcKind));
            }
            case 18: {
                int maxLen = reader.read_ulong();
                log.info("string len: " + maxLen);
                return new TypeCodeImpl(TCKind.from_int((int)tcKind));
            }
            case -1: {
                throw new UnsupportedOperationException("INDIRECTION");
            }
        }
        throw new UnsupportedOperationException();
    }

    public Object readValue(IiopReader reader) {
        log.fine("READ: " + (Object)((Object)this));
        switch (this._kind.value()) {
            case 0: 
            case 1: {
                return null;
            }
            case 3: {
                return new Integer(reader.read_long());
            }
            case 5: {
                return new Integer(reader.read_ulong());
            }
            case 18: {
                return reader.read_string();
            }
            case 27: {
                return reader.read_wstring();
            }
            case 32: {
                return reader.read_abstract_interface();
            }
            case 29: {
                return reader.read_value();
            }
            case 30: {
                return reader.read_value();
            }
        }
        throw new UnsupportedOperationException(String.valueOf((Object)this));
    }

    public String toString() {
        return "TypeCodeImpl[" + this._kind.value() + "]";
    }

    static class Member {
        private String _name;
        private TypeCode _type;
        private short _visibility;

        Member(String name, TypeCode type, short visibility) {
            this._name = name;
            this._type = type;
            this._visibility = visibility;
        }

        String getName() {
            return this._name;
        }

        TypeCode getType() {
            return this._type;
        }

        short getVisibility() {
            return this._visibility;
        }
    }
}

