/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.iiop.any;

import com.caucho.iiop.EncapsulationMessageWriter;
import com.caucho.iiop.Iiop12Writer;
import com.caucho.iiop.IiopReader;
import com.caucho.iiop.IiopWriter;
import com.caucho.iiop.any.AbstractTypeCode;
import java.io.Serializable;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;

public class ValueBoxTypeCode
extends AbstractTypeCode {
    private TypeCode _contentType;
    private String _id;
    private String _name;

    public ValueBoxTypeCode(String id, String name) {
        this._id = id;
        this._name = name;
    }

    public ValueBoxTypeCode(String id, String name, TypeCode contentType) {
        this._id = id;
        this._name = name;
        this._contentType = contentType;
    }

    public TCKind kind() {
        return TCKind.tk_value_box;
    }

    public String id() {
        return this._id;
    }

    public String name() {
        return this._name;
    }

    public TypeCode content_type() {
        return this._contentType;
    }

    public static ValueBoxTypeCode readTypeCode(IiopReader is) {
        int len = is.read_sequence_length();
        byte endian = is.read_octet();
        String id = is.readString();
        String name = is.readString();
        ValueBoxTypeCode typeCode = new ValueBoxTypeCode(id, name);
        typeCode._contentType = is.read_TypeCode();
        return typeCode;
    }

    public static void writeTypeCode(IiopWriter os, TypeCode tc) {
        try {
            os.write_long(tc.kind().value());
            EncapsulationMessageWriter encap = new EncapsulationMessageWriter();
            Iiop12Writer subOut = new Iiop12Writer();
            subOut.init(encap);
            subOut.write(0);
            subOut.write_string(tc.id());
            subOut.write_string(tc.name());
            subOut.write_TypeCode(tc.content_type());
            encap.close();
            os.write_long(encap.getOffset());
            encap.writeToWriter(os);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object readValue(IiopReader is) {
        return is.read_value();
    }

    public void writeValue(IiopWriter os, Object v) {
        os.write_value((Serializable)v);
    }

    public String toString() {
        return "ValueBoxTypeCode[" + this._contentType + "]";
    }
}

