/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.iiop.any;

import com.caucho.iiop.EncapsulationMessageWriter;
import com.caucho.iiop.Iiop12Writer;
import com.caucho.iiop.IiopReader;
import com.caucho.iiop.IiopWriter;
import com.caucho.iiop.any.AbstractTypeCode;
import java.io.Serializable;
import java.util.ArrayList;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;

public class ValueTypeCode
extends AbstractTypeCode {
    private String _id;
    private String _name;
    private short _modifier;
    private AbstractTypeCode _baseTypeCode;
    private ArrayList<Member> _members = new ArrayList();

    ValueTypeCode(String id, String name) {
        this._id = id;
        this._name = name;
    }

    ValueTypeCode(String id, String name, short modifier) {
        this._id = id;
        this._name = name;
        this._modifier = modifier;
    }

    public TCKind kind() {
        return TCKind.tk_value;
    }

    public String id() {
        return this._id;
    }

    public String name() {
        return this._name;
    }

    public void setBaseTypeCode(AbstractTypeCode base) {
        this._baseTypeCode = base;
    }

    public TypeCode concrete_base_type() {
        return this._baseTypeCode;
    }

    public short type_modifier() {
        return this._modifier;
    }

    public void addMember(String name, TypeCode type, short visibility) {
        this._members.add(new Member(name, type, visibility));
    }

    public int member_count() {
        return this._members.size();
    }

    public String member_name(int index) {
        return this._members.get(index).getName();
    }

    public TypeCode member_type(int index) {
        return this._members.get(index).getType();
    }

    public short member_visibility(int index) {
        return this._members.get(index).getVisibility();
    }

    public static ValueTypeCode readTypeCode(IiopReader is) {
        int len = is.read_sequence_length();
        byte endian = is.read_octet();
        String id = is.read_string();
        String name = is.read_string();
        short modifier = is.read_short();
        ValueTypeCode typeCode = new ValueTypeCode(id, name, modifier);
        TypeCode base = is.read_TypeCode();
        typeCode.setBaseTypeCode((AbstractTypeCode)base);
        int count = is.read_ulong();
        for (int i = 0; i < count; ++i) {
            String fieldName = is.read_string();
            TypeCode fieldType = is.read_TypeCode();
            short visibility = is.read_short();
            typeCode.addMember(fieldName, fieldType, visibility);
        }
        return typeCode;
    }

    public static void writeTypeCode(IiopWriter os, TypeCode tc) {
        try {
            os.write_long(tc.kind().value());
            EncapsulationMessageWriter encap = new EncapsulationMessageWriter();
            Iiop12Writer subOut = new Iiop12Writer();
            subOut.init(encap);
            subOut.write(0);
            subOut.write_string(tc.id());
            subOut.write_string(tc.name());
            subOut.write_short(tc.type_modifier());
            subOut.write_TypeCode(tc.concrete_base_type());
            subOut.write_ulong(tc.member_count());
            for (int i = 0; i < tc.member_count(); ++i) {
                subOut.write_string(tc.member_name(i));
                subOut.write_TypeCode(tc.member_type(i));
                subOut.write_short(tc.member_visibility(i));
            }
            encap.close();
            os.write_long(encap.getOffset());
            encap.writeToWriter(os);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Object readValue(IiopReader is) {
        return is.read_value();
    }

    public void writeValue(IiopWriter os, Object value) {
        os.write_value((Serializable)value);
    }

    public String toString() {
        return "ValueTypeCode[" + this._id + "]";
    }

    static class Member {
        private String _name;
        private TypeCode _type;
        private short _visibility;

        Member(String name, TypeCode type, short visibility) {
            this._name = name;
            this._type = type;
            this._visibility = visibility;
        }

        String getName() {
            return this._name;
        }

        TypeCode getType() {
            return this._type;
        }

        short getVisibility() {
            return this._visibility;
        }
    }
}

