/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.iiop.marshal;

import com.caucho.iiop.marshal.Marshal;
import java.lang.reflect.Array;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public class ArrayMarshal
extends Marshal {
    private final Class _component;
    private final Marshal _subMarshal;

    public ArrayMarshal(Class component, Marshal subMarshal) {
        this._component = component;
        this._subMarshal = subMarshal;
    }

    public void marshal(OutputStream os, Object value) {
        Object[] obj = (Object[])value;
        int len = obj.length;
        os.write_long(len);
        for (int i = 0; i < len; ++i) {
            this._subMarshal.marshal(os, obj[i]);
        }
    }

    public Object unmarshal(InputStream is) {
        try {
            int len = is.read_long();
            if (len < 0 || len >= 65536) {
                throw new RuntimeException("sequence too long:" + len);
            }
            Object[] obj = (Object[])Array.newInstance(this._component, len);
            for (int i = 0; i < len; ++i) {
                obj[i] = this._subMarshal.unmarshal(is);
            }
            return obj;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

