/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.iiop.marshal;

import com.caucho.ejb.AbstractEJBObject;
import com.caucho.ejb.AbstractServer;
import com.caucho.iiop.DummyObjectImpl;
import com.caucho.iiop.IOR;
import com.caucho.iiop.marshal.Marshal;
import com.caucho.iiop.orb.IiopProxy;
import com.caucho.iiop.orb.IiopProxyHandler;
import com.caucho.iiop.orb.ORBImpl;
import com.caucho.iiop.orb.StubImpl;
import com.caucho.iiop.orb.StubMarshal;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.logging.Logger;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public class RemoteMarshal
extends Marshal {
    private static final Logger log = Logger.getLogger(RemoteMarshal.class.getName());
    private Class _cl;

    public RemoteMarshal(Class cl) {
        this._cl = cl;
    }

    public void marshal(OutputStream os, java.lang.Object value) {
        if (value instanceof IiopProxy) {
            IiopProxyHandler handler = (IiopProxyHandler)Proxy.getInvocationHandler(value);
            StubImpl stub = handler.getStub();
            os.write_Object((Object)new DummyObjectImpl(stub.getIOR()));
        } else if (value instanceof AbstractEJBObject) {
            AbstractEJBObject absObj = (AbstractEJBObject)value;
            AbstractServer server = absObj.__caucho_getServer();
            String local = absObj.__caucho_getId();
            String url = server.getProtocolId(this._cl) + "?" + local;
            String typeName = "RMI:" + this._cl.getName() + ":0";
            ORBImpl orb = (ORBImpl)os.orb();
            IOR ior = new IOR(typeName, orb.getHost(), orb.getPort(), url);
            os.write_Object((Object)new DummyObjectImpl(ior));
        } else {
            os.write_value((Serializable)value);
        }
    }

    public java.lang.Object unmarshal(InputStream is) {
        Object value = is.read_Object(this._cl);
        if (value instanceof StubImpl) {
            Class<?> type = this._cl;
            StubImpl stub = (StubImpl)value;
            IOR ior = stub.getIOR();
            String typeId = ior.getTypeId();
            if (typeId.startsWith("RMI:")) {
                int p = typeId.lastIndexOf(58);
                String typeName = typeId.substring(4, p);
                try {
                    ClassLoader loader = Thread.currentThread().getContextClassLoader();
                    Class<?> typeClass = Class.forName(typeName, false, loader);
                    if (typeClass.isInterface()) {
                        type = typeClass;
                    }
                }
                catch (Exception e) {
                    log.finer(e.toString());
                }
            }
            StubMarshal stubMarshal = new StubMarshal(type);
            IiopProxyHandler handler = new IiopProxyHandler(stub.getORBImpl(), (ObjectImpl)stub, stubMarshal);
            return Proxy.newProxyInstance(type.getClassLoader(), new Class[]{type, IiopProxy.class}, (InvocationHandler)handler);
        }
        return value;
    }
}

