/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.iiop.orb;

import com.caucho.util.Alarm;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadWritePair;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.util.HashMap;

public class IiopSocketPool {
    private String _host;
    private int _port;
    private Path _path;
    private ReadWritePair _pair;
    private long _lastFreeTime;
    private long _maxIdleTime = 10000L;

    public IiopSocketPool(String host, int port) {
        this._host = host;
        this._port = port;
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("timeout", new Long(600000L));
        this._path = Vfs.lookup("tcp://" + host + ":" + port, props);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ReadWritePair open() throws IOException {
        IiopSocketPool iiopSocketPool = this;
        synchronized (iiopSocketPool) {
            long now = Alarm.getCurrentTime();
            ReadWritePair pair = this._pair;
            this._pair = null;
            if (pair != null && now < this._lastFreeTime + this._maxIdleTime) {
                return pair;
            }
            if (pair != null) {
                IiopSocketPool.closePair(pair);
            }
        }
        return this._path.openReadWrite();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void free(ReadWritePair pair) {
        ReadWritePair closePair = null;
        IiopSocketPool iiopSocketPool = this;
        synchronized (iiopSocketPool) {
            closePair = this._pair;
            this._pair = pair;
            this._lastFreeTime = Alarm.getCurrentTime();
        }
        if (closePair != null) {
            IiopSocketPool.closePair(closePair);
        }
    }

    private static void closePair(ReadWritePair pair) {
        pair.getReadStream().close();
        try {
            pair.getWriteStream().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public String toString() {
        return "IiopSocketPool[" + this._host + ", " + this._port + "]";
    }
}

