/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.iiop.orb;

import com.caucho.iiop.marshal.AnyMarshal;
import com.caucho.iiop.marshal.ArrayMarshal;
import com.caucho.iiop.marshal.BooleanMarshal;
import com.caucho.iiop.marshal.ByteMarshal;
import com.caucho.iiop.marshal.CharMarshal;
import com.caucho.iiop.marshal.DoubleMarshal;
import com.caucho.iiop.marshal.FloatMarshal;
import com.caucho.iiop.marshal.HelperMarshal;
import com.caucho.iiop.marshal.IntMarshal;
import com.caucho.iiop.marshal.LongMarshal;
import com.caucho.iiop.marshal.Marshal;
import com.caucho.iiop.marshal.RemoteMarshal;
import com.caucho.iiop.marshal.ShortMarshal;
import com.caucho.iiop.marshal.VoidMarshal;
import com.caucho.iiop.orb.CorbaObjectMarshal;
import com.caucho.iiop.orb.SerializableMarshal;
import com.caucho.iiop.orb.StreamableMarshal;
import com.caucho.iiop.orb.StringMarshal;
import java.io.Serializable;
import java.rmi.Remote;
import java.util.HashMap;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.IDLEntity;
import org.omg.CORBA.portable.Streamable;

public class MarshalFactory {
    private static MarshalFactory _factory = new MarshalFactory();
    private static HashMap<Class, Marshal> _classMap = new HashMap();

    public static MarshalFactory create() {
        return _factory;
    }

    public Marshal create(Class cl, boolean isIdl) {
        Marshal marshal = _classMap.get(cl);
        if (marshal != null) {
            return marshal;
        }
        if (Streamable.class.isAssignableFrom(cl)) {
            return new StreamableMarshal(cl);
        }
        if (IDLEntity.class.isAssignableFrom(cl)) {
            return new HelperMarshal(cl);
        }
        if (cl.isArray() && this.isIDLEntity(cl.getComponentType())) {
            Class<?> compType = cl.getComponentType();
            Marshal subMarshal = this.create(compType, isIdl);
            return new ArrayMarshal(compType, subMarshal);
        }
        if (Remote.class.isAssignableFrom(cl)) {
            return new RemoteMarshal(cl);
        }
        if (Serializable.class.isAssignableFrom(cl)) {
            return SerializableMarshal.MARSHAL;
        }
        return AnyMarshal.MARSHAL;
    }

    private boolean isIDLEntity(Class cl) {
        if (IDLEntity.class.isAssignableFrom(cl)) {
            return true;
        }
        if (cl.isArray()) {
            return this.isIDLEntity(cl.getComponentType());
        }
        return false;
    }

    static {
        _classMap.put(Void.TYPE, VoidMarshal.MARSHAL);
        _classMap.put(Boolean.TYPE, BooleanMarshal.MARSHAL);
        _classMap.put(Character.TYPE, CharMarshal.MARSHAL);
        _classMap.put(Byte.TYPE, ByteMarshal.MARSHAL);
        _classMap.put(Short.TYPE, ShortMarshal.MARSHAL);
        _classMap.put(Integer.TYPE, IntMarshal.MARSHAL);
        _classMap.put(Long.TYPE, LongMarshal.MARSHAL);
        _classMap.put(Float.TYPE, FloatMarshal.MARSHAL);
        _classMap.put(Double.TYPE, DoubleMarshal.MARSHAL);
        _classMap.put(String.class, StringMarshal.MARSHAL);
        _classMap.put(Object.class, CorbaObjectMarshal.MARSHAL);
    }
}

