/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.j2ee;

import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum J2EEVersion {
    J2EE12{

        public boolean hasFeaturesOf(J2EEVersion version) {
            return version == J2EE12;
        }
    }
    ,
    J2EE13{

        public boolean hasFeaturesOf(J2EEVersion version) {
            return version == J2EE12 || version == J2EE13;
        }
    }
    ,
    J2EE14{

        public boolean hasFeaturesOf(J2EEVersion version) {
            return version == J2EE12 || version == J2EE13 || version == J2EE14;
        }
    }
    ,
    JAVAEE5{

        public boolean hasFeaturesOf(J2EEVersion version) {
            return version == J2EE12 || version == J2EE13 || version == J2EE14 || version == JAVAEE5;
        }
    }
    ,
    RESIN{

        public boolean hasFeaturesOf(J2EEVersion version) {
            return true;
        }
    };

    private static final L10N L;
    public static final String J2EE_NAMESPACE = "http://java.sun.com/xml/ns/j2ee";
    public static final String JAVAEE_NAMESPACE = "http://java.sun.com/xml/ns/javaee";
    public static final String RESIN_NAMESPACE = "http://caucho.com/ns/resin";

    public static J2EEVersion getJ2EEVersion(Element top) {
        String publicId;
        DocumentType doctype;
        String version = top.getAttribute("version");
        String ns = top.getNamespaceURI();
        if (version.length() > 0) {
            if (ns == null) {
                throw new ConfigException(L.l("namespace is required because version is specified, either xmlns='{0}', xmlns='{1}', or xmlns='{2}'", (Object)RESIN_NAMESPACE, (Object)JAVAEE_NAMESPACE, (Object)J2EE_NAMESPACE));
            }
            if (ns.equals(J2EE_NAMESPACE)) {
                if (version.equals("1.4")) {
                    return J2EE14;
                }
                throw new ConfigException(L.l("version must be '{0}' for namespace '{1}'", (Object)"1.4", (Object)ns));
            }
            if (ns.equals(JAVAEE_NAMESPACE)) {
                if (version.equals("5") || version.equals("5.0") || version.equals("2.5")) {
                    return JAVAEE5;
                }
                throw new ConfigException(L.l("version must be '{0}' for namespace '{1}'", (Object)"5", (Object)ns));
            }
            if (ns.equals(RESIN_NAMESPACE)) {
                return RESIN;
            }
        } else if (ns != null) {
            if (ns.equals(RESIN_NAMESPACE)) {
                return RESIN;
            }
            throw new ConfigException(L.l("unknown namespace '{0}', namespace must be one of xmlns='{1}', xmlns='{2}', or xmlns='{3}'", (Object)ns, (Object)RESIN_NAMESPACE, (Object)JAVAEE_NAMESPACE, (Object)J2EE_NAMESPACE));
        }
        if ((doctype = top.getOwnerDocument().getDoctype()) != null && (publicId = doctype.getPublicId()) != null && publicId.contains("1.3")) {
            return J2EE13;
        }
        return J2EE12;
    }

    public abstract boolean hasFeaturesOf(J2EEVersion var1);

    static {
        L = new L10N(J2EEVersion.class);
    }
}

