/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.j2ee.appclient;

import com.caucho.amber.manager.PersistenceEnvironmentListener;
import com.caucho.config.Config;
import com.caucho.config.ConfigELContext;
import com.caucho.config.ConfigException;
import com.caucho.config.j2ee.InjectIntrospector;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.types.EjbRef;
import com.caucho.config.types.Icon;
import com.caucho.ejb.cfg.PostConstructConfig;
import com.caucho.ejb.cfg.PreDestroyConfig;
import com.caucho.el.EL;
import com.caucho.el.MapVariableResolver;
import com.caucho.j2ee.J2EEVersion;
import com.caucho.java.WorkDir;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentBean;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.L10N;
import com.caucho.vfs.JarPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AppClient
implements EnvironmentBean {
    private static L10N L = new L10N(AppClient.class);
    private static Logger log = Logger.getLogger(AppClient.class.getName());
    private static final EnvironmentLocal<AppClient> _local = new EnvironmentLocal();
    private final EnvironmentClassLoader _loader;
    private J2EEVersion _j2eeVersion = J2EEVersion.RESIN;
    private Path _home;
    private boolean _isMetadataComplete;
    private Path _rootDirectory;
    private Path _workDirectory;
    private String _mainClassName;
    private Path _clientJar;
    private Path _earFile;
    private ArrayList<Path> _configList = new ArrayList();
    private Lifecycle _lifecycle = new Lifecycle(log);
    private Method _mainMethod;
    private String[] _mainArgs = new String[0];
    private Hashtable _ejbEnv = new Hashtable();
    private Context _ejbContext;
    private PreDestroyConfig _preDestroyConfig;
    private PostConstructConfig _postConstructConfig;
    ArrayList<EjbRef> _ejbRefList = new ArrayList();

    private AppClient() {
        this._loader = new EnvironmentClassLoader();
        _local.set(this, this._loader);
        this._home = CauchoSystem.getResinHome();
    }

    @Override
    public ClassLoader getClassLoader() {
        return this._loader;
    }

    public static AppClient getLocal() {
        return _local.get();
    }

    public PostConstructConfig getPostConstruct() {
        return this._postConstructConfig;
    }

    public PreDestroyConfig getPreDestroy() {
        return this._preDestroyConfig;
    }

    public void setConfigNode(Node node) {
        this._j2eeVersion = J2EEVersion.getJ2EEVersion((Element)node);
    }

    public J2EEVersion getJ2EEVersion() {
        return this._j2eeVersion;
    }

    public void setMetadataComplete(boolean isComplete) {
        this._isMetadataComplete = isComplete;
    }

    public void setRootDirectory(Path rootDirectory) {
        this._rootDirectory = rootDirectory;
        Vfs.setPwd(this._rootDirectory);
    }

    public void setWorkDirectory(Path workDirectory) {
        this._workDirectory = workDirectory;
    }

    public void setId(String id) {
    }

    public void setDescription(String value) {
    }

    public void setIcon(Icon icon) {
    }

    private void addConfig(Path path) throws Exception {
        this._configList.add(path);
    }

    public void setClientJar(Path clientJar) {
        this._clientJar = clientJar;
    }

    public void setEarFile(Path earFile) {
        this._earFile = earFile;
    }

    public void setMainClass(String mainClassName) {
        this._mainClassName = mainClassName;
    }

    public void setMainArgs(String[] mainArgs) {
        this._mainArgs = mainArgs;
    }

    public void setPostConstruct(PostConstructConfig postConstruct) {
        this._postConstructConfig = postConstruct;
    }

    public void setPreDestroy(PreDestroyConfig preDestroy) {
        this._preDestroyConfig = preDestroy;
    }

    public void setSchemaLocation(String schemaLocation) {
    }

    public void setVersion(String version) {
    }

    public void setDisplayName(String displayName) {
    }

    public void setCallbackHandler(Class<CallbackHandler> callbackHandler) throws Exception {
        CallbackManager callback = new CallbackManager();
        CallbackHandler handler = callbackHandler.newInstance();
        callback.handle(handler);
        System.setProperty("java.naming.security.principal", callback.getName());
        System.setProperty("java.naming.security.credentials", callback.getPassword());
    }

    public EjbRef createEjbRef() {
        EjbRef ejbRef = new EjbRef(this._ejbContext);
        this._ejbRefList.add(ejbRef);
        ejbRef.setClientClassName(this._mainClassName);
        return ejbRef;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws Exception {
        if (!this._lifecycle.toInitializing()) {
            return;
        }
        if (this._clientJar == null) {
            throw new ConfigException(L.l("'client-jar' is required"));
        }
        if (this._rootDirectory == null) {
            this.setRootDirectory(this._clientJar.getParent());
        }
        if (this._workDirectory == null) {
            this._workDirectory = this._rootDirectory.lookup("META-INF/work");
        }
        WorkDir.setLocalWorkDir(this._workDirectory, this._loader);
        this._loader.setId(this.toString());
        this._loader.addJar(this._clientJar);
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._loader);
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, L.l("root-directory is {0}", (Object)this._rootDirectory));
            }
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, L.l("work-directory is {0}", (Object)WorkDir.getLocalWorkDir()));
            }
            this._ejbContext = new InitialContext(this._ejbEnv);
            JarPath jarPath = JarPath.create(this._clientJar);
            this.configureFrom(jarPath.lookup("META-INF/application-client.xml"), true);
            this.configureFrom(jarPath.lookup("META-INF/resin-application-client.xml"), true);
            for (Path configPath : this._configList) {
                this.configureFrom(configPath, true);
            }
            this.mergeEjbRefs();
            Environment.addChildLoaderListener(new PersistenceEnvironmentListener());
            if (this._mainClassName == null) {
                throw new ConfigException(L.l("'main-class' is required"));
            }
            Class<?> mainClass = Class.forName(this._mainClassName, false, this._loader);
            ArrayList<ConfigProgram> injectList = new ArrayList<ConfigProgram>();
            InjectIntrospector.introspectInject(injectList, mainClass);
            for (ConfigProgram inject : injectList) {
                inject.inject(null, null);
            }
            this._mainMethod = mainClass.getMethod("main", String[].class);
            this._lifecycle.setName(this.toString());
            this._lifecycle.toInit();
            Object var9_8 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var9_9 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    private void configureFrom(Path xml, boolean optional) throws Exception {
        if (xml.canRead()) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, L.l("reading configuration file {0}", (Object)xml));
            }
            HashMap<String, Object> variableMap = new HashMap<String, Object>();
            variableMap.put("resin", new ResinVar());
            MapVariableResolver varResolver = new MapVariableResolver(variableMap);
            ConfigELContext elContext = new ConfigELContext(varResolver);
            EL.setEnvironment(elContext, this._loader);
            EL.setVariableMap(variableMap, this._loader);
            Config config = new Config();
            config.configureBean((Object)this, xml, "com/caucho/server/e_app/app-client.rnc");
        } else {
            if (!optional) {
                throw new ConfigException(L.l("missing required configuration file {0}", (Object)xml));
            }
            if (log.isLoggable(Level.FINEST)) {
                log.log(Level.FINEST, L.l("no configuration file {0}", (Object)xml));
            }
        }
    }

    private void mergeEjbRefs() throws Exception {
        for (int i = 0; i < this._ejbRefList.size(); ++i) {
            EjbRef ref = this._ejbRefList.get(i);
            String refName = ref.getEjbRefName();
            for (int j = i + 1; j < this._ejbRefList.size(); ++j) {
                EjbRef other = this._ejbRefList.get(j);
                if (!refName.equals(other.getEjbRefName())) continue;
                ref.mergeFrom(other);
                this._ejbRefList.remove(j);
                --j;
            }
            ref.bind();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        this.init();
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this._loader);
            this._mainMethod.invoke(null, new Object[]{this._mainArgs});
            Object var4_3 = null;
            thread.setContextClassLoader(oldLoader);
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    public String toString() {
        return "AppClient[" + this._clientJar + "," + this._mainClassName + "]";
    }

    public static void main(String[] args) throws Throwable {
        String clientJar = null;
        String earFile = null;
        String main = null;
        String conf = null;
        String workDir = null;
        String[] mainArgs = null;
        EnvironmentClassLoader.initializeEnvironment();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.startsWith("-")) {
                String option = arg.substring(arg.startsWith("--") ? 2 : 1);
                if (option.equals("conf")) {
                    conf = args[++i];
                    continue;
                }
                if (option.equals("client-jar")) {
                    clientJar = args[++i];
                    continue;
                }
                if (option.equals("ear-file")) {
                    earFile = args[++i];
                    continue;
                }
                if (option.equals("work-dir")) {
                    workDir = args[++i];
                    continue;
                }
                if (option.equals("main")) {
                    main = args[++i];
                    mainArgs = new String[args.length - i - 1];
                    System.arraycopy(args, i + 1, mainArgs, 0, mainArgs.length);
                    break;
                }
            }
            throw new ConfigException(L.l("unknown arg '{0}'", (Object)args[i]));
        }
        AppClient appClient = new AppClient();
        if (workDir != null) {
            appClient.setWorkDirectory(Vfs.lookup(workDir));
        }
        if (clientJar != null) {
            appClient.setClientJar(Vfs.lookup(clientJar));
        }
        if (earFile != null) {
            appClient.setEarFile(Vfs.lookup(earFile));
        }
        if (conf != null) {
            appClient.addConfig(Vfs.lookup(conf));
        }
        if (main != null) {
            appClient.setMainClass(main);
        }
        if (mainArgs != null) {
            appClient.setMainArgs(mainArgs);
        }
        appClient.run();
    }

    static /* synthetic */ L10N access$000() {
        return L;
    }

    public class ResinVar {
        public Path getHome() {
            System.out.println("GET_HOME: " + AppClient.this._home);
            return AppClient.this._home;
        }

        public Path getRoot() {
            return AppClient.this._rootDirectory;
        }
    }

    public class CallbackManager {
        private final NameCallback _nameCallback = new NameCallback(AppClient.access$000().l("Name"));
        private final PasswordCallback _passwordCallback = new PasswordCallback(AppClient.access$000().l("Password"), false);

        public void handle(CallbackHandler handler) throws IOException, UnsupportedCallbackException {
            Callback[] callbacks = new Callback[]{this._nameCallback, this._passwordCallback};
            handler.handle(callbacks);
        }

        public String getName() {
            return this._nameCallback.getName();
        }

        public String getPassword() {
            return new String(this._passwordCallback.getPassword());
        }
    }
}

