/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.j2ee.deployclient;

import com.caucho.hessian.client.HessianProxyFactory;
import com.caucho.j2ee.deployclient.DeploymentProxyAPI;
import com.caucho.j2ee.deployclient.ProgressObjectImpl;
import com.caucho.util.L10N;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.deploy.model.DeployableObject;
import javax.enterprise.deploy.shared.DConfigBeanVersionType;
import javax.enterprise.deploy.shared.ModuleType;
import javax.enterprise.deploy.spi.DeploymentConfiguration;
import javax.enterprise.deploy.spi.DeploymentManager;
import javax.enterprise.deploy.spi.Target;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.DConfigBeanVersionUnsupportedException;
import javax.enterprise.deploy.spi.exceptions.DeploymentManagerCreationException;
import javax.enterprise.deploy.spi.exceptions.InvalidModuleException;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.ProgressObject;

public class DeploymentManagerImpl
implements DeploymentManager {
    private static final L10N L = new L10N(DeploymentManagerImpl.class);
    private static final Logger log = Logger.getLogger(DeploymentManagerImpl.class.getName());
    private String _uri;
    private DeploymentProxyAPI _proxy;

    DeploymentManagerImpl(String uri) {
        int p = uri.indexOf("http");
        if (p < 0) {
            throw new IllegalArgumentException(L.l("'{0}' is an illegal URI for DeploymentManager.", (Object)uri));
        }
        this._uri = uri.substring(p);
    }

    void connect(String user, String password) throws DeploymentManagerCreationException {
        try {
            HessianProxyFactory factory = new HessianProxyFactory();
            factory.setUser(user);
            factory.setPassword(password);
            factory.setReadTimeout(120000L);
            if (log.isLoggable(Level.FINE)) {
                log.fine("DeploymentManager[" + this._uri + "] creating proxy");
            }
            this._proxy = (DeploymentProxyAPI)factory.create(DeploymentProxyAPI.class, this._uri);
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            DeploymentManagerCreationException exn = new DeploymentManagerCreationException(e.getMessage());
            exn.initCause((Throwable)e);
            throw exn;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Target[] getTargets() throws IllegalStateException {
        Target[] targetArray;
        ClassLoader oldLoader;
        Thread thread;
        block9: {
            if (this._proxy == null) {
                throw new IllegalStateException("DeploymentManager is disconnected");
            }
            thread = Thread.currentThread();
            oldLoader = thread.getContextClassLoader();
            try {
                Target[] targetArray2;
                block8: {
                    try {
                        thread.setContextClassLoader(this.getClass().getClassLoader());
                        Target[] targets = this._proxy.getTargets();
                        if (targets == null) {
                            targetArray2 = new Target[]{};
                            Object var6_8 = null;
                            break block8;
                        }
                        targetArray = targets;
                        break block9;
                    }
                    catch (RuntimeException e) {
                        throw e;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                        throw new RuntimeException(e);
                    }
                }
                thread.setContextClassLoader(oldLoader);
                return targetArray2;
            }
            catch (Throwable throwable) {
                Object var6_10 = null;
                thread.setContextClassLoader(oldLoader);
                throw throwable;
            }
        }
        Object var6_9 = null;
        thread.setContextClassLoader(oldLoader);
        return targetArray;
    }

    public TargetModuleID[] getRunningModules(ModuleType moduleType, Target[] targetList) throws TargetException, IllegalStateException {
        return new TargetModuleID[0];
    }

    public TargetModuleID[] getNonRunningModules(ModuleType moduleType, Target[] targetList) throws TargetException, IllegalStateException {
        return new TargetModuleID[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TargetModuleID[] getAvailableModules(ModuleType moduleType, Target[] targetList) throws TargetException, IllegalStateException {
        if (this._proxy == null) {
            throw new IllegalStateException("DeploymentManager is disconnected");
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getClass().getClassLoader());
            TargetModuleID[] targetModuleIDArray = this._proxy.getAvailableModules(moduleType.toString());
            Object var7_6 = null;
            thread.setContextClassLoader(oldLoader);
            return targetModuleIDArray;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    public DeploymentConfiguration createConfiguration(DeployableObject dObj) throws InvalidModuleException {
        throw new UnsupportedOperationException();
    }

    /*
     * Loose catch block
     */
    public ProgressObject distribute(Target[] targetList, File archive, File deploymentPlan) throws IllegalStateException {
        FileInputStream archiveIn = null;
        FileInputStream ddIn = null;
        archiveIn = new FileInputStream(archive);
        ddIn = new FileInputStream(deploymentPlan);
        ProgressObject progressObject = this.distribute(targetList, archiveIn, ddIn);
        Object var8_8 = null;
        try {
            if (archiveIn != null) {
                ((InputStream)archiveIn).close();
            }
        }
        catch (Throwable e2) {
            log.log(Level.FINE, e2.toString(), e2);
        }
        try {
            if (ddIn != null) {
                ((InputStream)ddIn).close();
            }
        }
        catch (Throwable e2) {
            log.log(Level.FINE, e2.toString(), e2);
        }
        return progressObject;
        catch (Exception e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                Object var8_9 = null;
                try {
                    if (archiveIn != null) {
                        ((InputStream)archiveIn).close();
                    }
                }
                catch (Throwable e2) {
                    log.log(Level.FINE, e2.toString(), e2);
                }
                try {
                    if (ddIn != null) {
                        ((InputStream)ddIn).close();
                    }
                }
                catch (Throwable e2) {
                    log.log(Level.FINE, e2.toString(), e2);
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressObject distribute(Target[] targetList, InputStream archive, InputStream deploymentPlan) throws IllegalStateException {
        if (this._proxy == null) {
            String message = L.l("DeploymentManager is disconnected");
            log.log(Level.FINE, message);
            ProgressObjectImpl progress = new ProgressObjectImpl(new TargetModuleID[0]);
            progress.failed(message);
            return progress;
        }
        if (deploymentPlan == null) {
            String message = L.l("{0} is required", (Object)"deployment plan");
            log.log(Level.FINE, message);
            ProgressObjectImpl progress = new ProgressObjectImpl(new TargetModuleID[0]);
            progress.failed(message);
            return progress;
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getClass().getClassLoader());
            ProgressObject progressObject = this._proxy.distribute(targetList, deploymentPlan, archive);
            Object var8_11 = null;
            thread.setContextClassLoader(oldLoader);
            return progressObject;
        }
        catch (Throwable throwable) {
            Object var8_12 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressObject start(TargetModuleID[] moduleIDList) throws IllegalStateException {
        if (this._proxy == null) {
            throw new IllegalStateException("DeploymentManager is disconnected");
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getClass().getClassLoader());
            ProgressObject progressObject = this._proxy.start(moduleIDList);
            Object var6_5 = null;
            thread.setContextClassLoader(oldLoader);
            return progressObject;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressObject stop(TargetModuleID[] moduleIDList) throws IllegalStateException {
        if (this._proxy == null) {
            throw new IllegalStateException("DeploymentManager is disconnected");
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getClass().getClassLoader());
            ProgressObject progressObject = this._proxy.stop(moduleIDList);
            Object var6_5 = null;
            thread.setContextClassLoader(oldLoader);
            return progressObject;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressObject undeploy(TargetModuleID[] moduleIDList) throws IllegalStateException {
        if (this._proxy == null) {
            throw new IllegalStateException("DeploymentManager is disconnected");
        }
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getClass().getClassLoader());
            ProgressObject progressObject = this._proxy.undeploy(moduleIDList);
            Object var6_5 = null;
            thread.setContextClassLoader(oldLoader);
            return progressObject;
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            thread.setContextClassLoader(oldLoader);
            throw throwable;
        }
    }

    public boolean isRedeploySupported() {
        return false;
    }

    public ProgressObject redeploy(TargetModuleID[] targetList, File archive, File deploymentPlan) throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public ProgressObject redeploy(TargetModuleID[] targetList, InputStream archive, InputStream deploymentPlan) throws IllegalStateException {
        throw new UnsupportedOperationException();
    }

    public void release() {
    }

    public Locale getDefaultLocale() {
        throw new UnsupportedOperationException();
    }

    public Locale getCurrentLocale() {
        throw new UnsupportedOperationException();
    }

    public void setLocale(Locale locale) {
        throw new UnsupportedOperationException();
    }

    public Locale[] getSupportedLocales() {
        throw new UnsupportedOperationException();
    }

    public boolean isLocaleSupported(Locale locale) {
        return false;
    }

    public DConfigBeanVersionType getDConfigBeanVersion() {
        return DConfigBeanVersionType.V1_4;
    }

    public boolean isDConfigBeanVersionSupported(DConfigBeanVersionType version) {
        return true;
    }

    public void setDConfigBeanVersionSupported(DConfigBeanVersionType version) throws DConfigBeanVersionUnsupportedException {
    }

    public String toString() {
        return "DeploymentManagerImpl[" + this._uri + "]";
    }

    public ProgressObject distribute(Target[] arg0, ModuleType arg1, InputStream arg2, InputStream arg3) throws IllegalStateException {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void setDConfigBeanVersion(DConfigBeanVersionType arg0) throws DConfigBeanVersionUnsupportedException {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

