/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.j2ee.deployserver;

import com.caucho.config.ConfigException;
import com.caucho.config.types.RawString;
import com.caucho.util.L10N;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import com.caucho.xml.XmlPrinter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import javax.annotation.PostConstruct;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeploymentPlan {
    private static final L10N L = new L10N(DeploymentPlan.class);
    private String _archiveType;
    private String _name;
    private String _metaInf;
    private ArrayList<PlanFile> _fileList = new ArrayList();

    public void setArchiveType(String type) throws ConfigException {
        if (type.equals("war")) {
            this._metaInf = "WEB-INF/";
        } else if (type.equals("ear")) {
            this._metaInf = "META-INF/";
        } else if (type.equals("rar")) {
            this._metaInf = "META-INF/";
        } else {
            throw new ConfigException(L.l("'{0}' is an unknown archive type.", (Object)type));
        }
        this._archiveType = type;
    }

    public String getArchiveType() {
        return this._archiveType;
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    @PostConstruct
    public void init() {
        if (this._archiveType == null) {
            throw new ConfigException(L.l("`{0}' is required", (Object)"archive-type"));
        }
        if (this._name == null) {
            throw new ConfigException(L.l("`{0}' is required", (Object)"name"));
        }
    }

    public ExtFile createExtFile() {
        return new ExtFile();
    }

    public void addExtFile(ExtFile extFile) {
        this._fileList.add(extFile);
    }

    public RawFile createRawFile() {
        return new RawFile();
    }

    public void addRawFile(RawFile rawFile) {
        this._fileList.add(rawFile);
    }

    public ArrayList<PlanFile> getFileList() {
        return this._fileList;
    }

    public class RawFile
    extends PlanFile {
        private String _path;
        private String _data;

        public void setPath(String path) {
            if (path.startsWith("/")) {
                throw new ConfigException(L.l("path `{0}' cannot start with /", (Object)path));
            }
            this._path = path;
        }

        public void setData(RawString data) {
            this._data = data.getValue();
        }

        @PostConstruct
        public void init() {
            if (this._path == null) {
                throw new ConfigException(L.l("`{0}' is required", (Object)"path"));
            }
            if (this._data == null) {
                throw new ConfigException(L.l("`{0}' is required", (Object)"data"));
            }
        }

        public String getPath() {
            return this._path;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void writeToStream(OutputStream os) throws IOException {
            WriteStream writeStream = Vfs.openWrite(os);
            try {
                writeStream.print(this._data);
                Object var4_3 = null;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                writeStream.close();
                throw throwable;
            }
            writeStream.close();
        }
    }

    public class ExtFile
    extends PlanFile {
        private String _name;
        private Node _data;

        public void setName(String name) {
            if (name.startsWith("/")) {
                throw new ConfigException(L.l("name `{0}' cannot start with /", (Object)name));
            }
            this._name = name;
        }

        public void setData(Node data) {
            this._data = data.getFirstChild();
        }

        @PostConstruct
        public void init() {
            if (this._name == null) {
                throw new ConfigException(L.l("`{0}' is required", (Object)"name"));
            }
            if (this._data == null) {
                throw new ConfigException(L.l("`{0}' is required", (Object)"data"));
            }
        }

        public String getPath() {
            return DeploymentPlan.this._metaInf + this._name;
        }

        public void writeToStream(OutputStream os) throws IOException {
            XmlPrinter xmlPrinter = new XmlPrinter(os);
            xmlPrinter.setPretty(true);
            xmlPrinter.printXml(this._data);
        }
    }

    public abstract class PlanFile {
        public abstract String getPath();

        public abstract void writeToStream(OutputStream var1) throws IOException;

        public String toString() {
            return "DeploymentPlan$" + this.getClass().getSimpleName() + "[" + this.getPath() + "]";
        }
    }
}

