/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.j2ee.deployserver;

import com.caucho.config.ConfigException;
import com.caucho.j2ee.deployclient.ProgressObjectImpl;
import com.caucho.j2ee.deployclient.TargetImpl;
import com.caucho.j2ee.deployclient.TargetModuleIDImpl;
import com.caucho.j2ee.deployserver.DeploymentPlan;
import com.caucho.jmx.AbstractMBeanServer;
import com.caucho.jmx.Jmx;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.management.server.ArchiveDeployMXBean;
import com.caucho.management.server.DeployControllerMXBean;
import com.caucho.management.server.EAppMXBean;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.exceptions.TargetException;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;

public class DeploymentService {
    private static final L10N L = new L10N(DeploymentService.class);
    private static final Logger log = Logger.getLogger(DeploymentService.class.getName());
    private static final EnvironmentLocal<DeploymentService> _local = new EnvironmentLocal();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DeploymentService getDeploymentService() {
        EnvironmentLocal<DeploymentService> environmentLocal = _local;
        synchronized (environmentLocal) {
            DeploymentService deploymentService = _local.get();
            if (deploymentService == null) {
                deploymentService = new DeploymentService();
                _local.set(deploymentService);
            }
            return deploymentService;
        }
    }

    private DeploymentService() {
    }

    public TargetImpl[] getTargets() throws IllegalStateException {
        ArrayList<String> hosts;
        block12: {
            String host;
            Set<ObjectName> objectNames;
            AbstractMBeanServer mbeanServer;
            block11: {
                block10: {
                    mbeanServer = Jmx.getMBeanServer();
                    hosts = new ArrayList<String>();
                    try {
                        objectNames = mbeanServer.queryNames(new ObjectName("resin:type=EarDeploy,*"), null);
                        for (ObjectName objectName : objectNames) {
                            host = objectName.getKeyProperty("Host");
                            if (hosts.contains(host)) continue;
                            hosts.add(host);
                        }
                    }
                    catch (MalformedObjectNameException e) {
                        if (!log.isLoggable(Level.WARNING)) break block10;
                        log.log(Level.WARNING, e.toString(), e);
                    }
                }
                try {
                    objectNames = mbeanServer.queryNames(new ObjectName("resin:type=WebAppDeploy,*"), null);
                    for (ObjectName objectName : objectNames) {
                        host = objectName.getKeyProperty("Host");
                        if (hosts.contains(host)) continue;
                        hosts.add(host);
                    }
                }
                catch (MalformedObjectNameException e) {
                    if (!log.isLoggable(Level.WARNING)) break block11;
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
            try {
                objectNames = mbeanServer.queryNames(new ObjectName("resin:type=ResourceDeploy,*"), null);
                for (ObjectName objectName : objectNames) {
                    host = objectName.getKeyProperty("Host");
                    if (hosts.contains(host)) continue;
                    hosts.add(host);
                }
            }
            catch (MalformedObjectNameException e) {
                if (!log.isLoggable(Level.WARNING)) break block12;
                log.log(Level.WARNING, e.toString(), e);
            }
        }
        TargetImpl[] targets = new TargetImpl[hosts.size()];
        for (int i = 0; i < hosts.size(); ++i) {
            String host = (String)hosts.get(i);
            String description = "Virtual Host: " + host;
            targets[i] = new TargetImpl(host, description);
        }
        return targets;
    }

    public TargetModuleID[] getAvailableModules(String type) throws TargetException, IllegalStateException {
        return new TargetModuleID[0];
    }

    private String getExceptionMessage(Throwable exception) {
        if (exception == null) {
            return "";
        }
        if (exception instanceof ConfigException) {
            return exception.getMessage();
        }
        return exception.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProgressObject distribute(TargetImpl[] hostTargets, InputStream archiveIs, DeploymentPlan plan) throws IllegalStateException {
        String moduleID;
        ArchiveDeployMXBean mxbean;
        String name;
        block23: {
            if (hostTargets == null || hostTargets.length != 1) {
                String msg = L.l("jsr88 can only support single-host deploy");
                log.warning(msg);
                ProgressObjectImpl progress = new ProgressObjectImpl(new TargetModuleID[0]);
                progress.failed(msg);
                return progress;
            }
            String hostName = hostTargets[0].getName();
            name = plan.getName();
            mxbean = null;
            try {
                String jmxName;
                if ("ear".equals(plan.getArchiveType())) {
                    moduleID = "resin:name=" + name + ",type=EApp,Host=" + hostName;
                    jmxName = "resin:type=EarDeploy,Host=" + hostName + ",*";
                    mxbean = this.loadArchiveMXBean(jmxName);
                    break block23;
                }
                if ("war".equals(plan.getArchiveType())) {
                    moduleID = "resin:name=/" + name + ",type=WebApp,Host=" + hostName;
                    jmxName = "resin:type=WebAppDeploy,Host=" + hostName + ",*";
                    mxbean = this.loadArchiveMXBean(jmxName);
                    break block23;
                }
                if ("rar".equals(plan.getArchiveType())) {
                    moduleID = "resin:name=" + name + ",type=Resource,Host=" + hostName;
                    jmxName = "resin:type=ResourceDeploy,Host=" + hostName + ",*";
                    mxbean = this.loadArchiveMXBean(jmxName);
                    break block23;
                }
                throw new UnsupportedOperationException(plan.getArchiveType());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        boolean failed = false;
        StringBuilder message = new StringBuilder();
        Path archivePath = null;
        Throwable exception = null;
        TargetImpl childTarget = new TargetImpl(moduleID, "");
        TargetModuleIDImpl childModuleID = new TargetModuleIDImpl(childTarget, moduleID);
        if (mxbean != null) {
            try {
                Path deployPath = Vfs.lookup(mxbean.getArchivePath(name));
                deployPath.getParent().mkdirs();
                if (archivePath == null) {
                    this.createArchive(deployPath, plan, archiveIs);
                    archivePath = deployPath;
                } else {
                    WriteStream deployStream = deployPath.openWrite();
                    try {
                        deployStream.writeFile(archivePath);
                        Object var18_23 = null;
                    }
                    catch (Throwable throwable) {
                        Object var18_24 = null;
                        deployStream.close();
                        throw throwable;
                    }
                    deployStream.close();
                    {
                    }
                }
                mxbean.update();
                exception = mxbean.getConfigException(name);
            }
            catch (Exception e) {
                if (log.isLoggable(Level.INFO)) {
                    log.log(Level.INFO, e.toString(), e);
                }
                exception = e;
            }
            if (exception != null) {
                failed = true;
                this.describe(message, childModuleID, false, this.getExceptionMessage(exception));
            } else {
                if ("ear".equals(plan.getArchiveType())) {
                    try {
                        EAppMXBean eApp = (EAppMXBean)Jmx.find(moduleID);
                        if (eApp != null) {
                            childTarget.setClientRefs(eApp.getClientRefs());
                        }
                    }
                    catch (Exception e) {
                        log.log(Level.FINEST, e.toString(), e);
                    }
                }
                this.describe(message, childModuleID, true);
            }
        } else {
            failed = true;
            log.warning(L.l("jsr88 cannot deploy '{0}', can't find deployment resource (e.g. web-app-deploy, ear-deploy).", (Object)moduleID));
        }
        TargetModuleID[] targetModuleIDs = new TargetModuleID[]{childModuleID};
        ProgressObjectImpl progress = new ProgressObjectImpl(targetModuleIDs);
        if (failed) {
            progress.failed(message.toString());
        } else {
            progress.completed(message.toString());
        }
        return progress;
    }

    private ArchiveDeployMXBean loadArchiveMXBean(String pattern) {
        try {
            ObjectName objectName = null;
            for (ObjectName subName : Jmx.getMBeanServer().queryNames(new ObjectName(pattern), null)) {
                if (objectName != null) continue;
                objectName = subName;
            }
            if (objectName != null) {
                return (ArchiveDeployMXBean)Jmx.find(objectName);
            }
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
        }
        return null;
    }

    private ArchiveDeployMXBean getMXBean(ObjectName targetName) throws MalformedObjectNameException {
        String type = targetName.getKeyProperty("type");
        String host = targetName.getKeyProperty("Host");
        if (type.equals("EApp")) {
            String archiveName = "resin:type=EarDeploy,Host=" + host + ",*";
            return this.loadArchiveMXBean(archiveName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createArchive(Path archivePath, DeploymentPlan plan, InputStream archiveIs) throws IOException {
        Exception ex22;
        ZipOutputStream zipOutputStream;
        WriteStream archiveStream;
        String earFileName;
        Path originalPath;
        block38: {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, L.l("jsr88 deploying archive {0}", (Object)archivePath));
            }
            originalPath = archivePath;
            earFileName = archivePath.getTail();
            if (earFileName.endsWith(".ear")) {
                String s = earFileName;
                s = s.substring(0, s.length() - 3) + "__caucho_ear";
                archivePath = archivePath.getParent().lookup(s);
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, L.l("jsr88 creating temp archive {0}", (Object)archivePath));
                }
            } else {
                earFileName = null;
            }
            archiveStream = null;
            ZipInputStream zipInputStream = null;
            zipOutputStream = null;
            try {
                archiveStream = archivePath.openWrite();
                zipOutputStream = new ZipOutputStream((OutputStream)archiveStream);
                zipInputStream = new ZipInputStream(archiveIs);
                ZipEntry zipEntry = zipInputStream.getNextEntry();
                TreeSet<String> entryNames = new TreeSet<String>();
                int copyCount = 0;
                while (zipEntry != null) {
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, L.l("jsr88 copying entry {0}", (Object)zipEntry));
                    }
                    entryNames.add(zipEntry.getName());
                    zipOutputStream.putNextEntry(zipEntry);
                    try {
                        int ch = zipInputStream.read();
                        while (ch != -1) {
                            zipOutputStream.write(ch);
                            ch = zipInputStream.read();
                        }
                    }
                    catch (IOException e) {
                        log.log(Level.WARNING, L.l("exception copying entry {0}", (Object)zipEntry), e);
                    }
                    zipEntry = zipInputStream.getNextEntry();
                    ++copyCount;
                }
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, L.l("copied {0} entries", (long)copyCount));
                }
                if (archiveIs.read() != -1) {
                    if (log.isLoggable(Level.FINE)) {
                        log.log(Level.FINE, L.l("unexpected data at end of archive"));
                    }
                    while (archiveIs.read() != -1) {
                    }
                }
                int fileCount = 0;
                for (DeploymentPlan.PlanFile file : plan.getFileList()) {
                    String zipEntryName = file.getPath();
                    if (zipEntryName.startsWith("/")) {
                        zipEntryName = zipEntryName.substring(1);
                    }
                    if (log.isLoggable(Level.FINEST)) {
                        log.log(Level.FINEST, L.l("jsr88 plan file {0} output to {1}", (Object)file, (Object)zipEntryName));
                    }
                    if (entryNames.contains(zipEntryName)) {
                        log.log(Level.WARNING, L.l("plan file {0} overwrites existing file", (Object)zipEntryName));
                    }
                    entryNames.add(zipEntryName);
                    zipEntry = new ZipEntry(zipEntryName);
                    zipOutputStream.putNextEntry(zipEntry);
                    file.writeToStream(zipOutputStream);
                    ++fileCount;
                }
                if (log.isLoggable(Level.FINER)) {
                    log.log(Level.FINER, L.l("created {0} entries from plan", (long)fileCount));
                }
                zipInputStream.close();
                zipInputStream = null;
                zipOutputStream.close();
                zipOutputStream = null;
                archiveStream.close();
                archiveStream = null;
                Object var17_17 = null;
                if (zipInputStream == null) break block38;
            }
            catch (Throwable throwable) {
                Exception ex22;
                Object var17_18 = null;
                if (zipInputStream != null) {
                    try {
                        zipInputStream.close();
                    }
                    catch (Exception ex22) {
                        log.log(Level.FINER, ex22.toString(), ex22);
                    }
                }
                if (zipOutputStream != null) {
                    try {
                        zipOutputStream.close();
                    }
                    catch (Exception ex22) {
                        log.log(Level.FINER, ex22.toString(), ex22);
                    }
                }
                if (archiveStream != null) {
                    try {
                        archiveStream.close();
                    }
                    catch (Exception ex22) {
                        log.log(Level.FINER, ex22.toString(), ex22);
                    }
                }
                if (earFileName != null) {
                    if (log.isLoggable(Level.FINER)) {
                        log.log(Level.FINER, L.l("jsr88 renaming temp archive {0} to {1}", (Object)archivePath, (Object)originalPath));
                    }
                    archivePath.renameTo(originalPath);
                }
                throw throwable;
            }
            try {
                zipInputStream.close();
            }
            catch (Exception ex22) {
                log.log(Level.FINER, ex22.toString(), ex22);
            }
        }
        if (zipOutputStream != null) {
            try {
                zipOutputStream.close();
            }
            catch (Exception ex22) {
                log.log(Level.FINER, ex22.toString(), ex22);
            }
        }
        if (archiveStream != null) {
            try {
                archiveStream.close();
            }
            catch (Exception ex22) {
                log.log(Level.FINER, ex22.toString(), ex22);
            }
        }
        if (earFileName != null) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, L.l("jsr88 renaming temp archive {0} to {1}", (Object)archivePath, (Object)originalPath));
            }
            archivePath.renameTo(originalPath);
        }
    }

    public ProgressObject start(TargetModuleID[] ids) {
        ProgressObjectImpl progress = new ProgressObjectImpl(ids);
        boolean failed = false;
        StringBuilder message = new StringBuilder();
        for (TargetModuleID targetModuleID : ids) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, L.l("jsr88 starting {0}", (Object)targetModuleID.getModuleID()));
            }
            Exception exception = null;
            DeployControllerMXBean mxbean = null;
            try {
                ObjectName objectName = new ObjectName(targetModuleID.getModuleID());
                mxbean = (DeployControllerMXBean)Jmx.find(objectName);
                if (mxbean != null) {
                    mxbean.start();
                } else {
                    log.finer("Jsr88[] " + objectName + " is an unknown module");
                    failed = true;
                }
            }
            catch (Exception t) {
                log.log(Level.INFO, t.toString(), t);
                exception = t;
            }
            if (exception != null) {
                failed = true;
                this.describe(message, targetModuleID, false, this.getExceptionMessage(exception));
                continue;
            }
            this.describe(message, targetModuleID, true);
        }
        if (failed) {
            progress.failed(L.l("start {0}", (Object)message));
        } else {
            progress.completed(L.l("start {0}", (Object)message));
        }
        return progress;
    }

    public ProgressObject stop(TargetModuleID[] ids) {
        ProgressObjectImpl progress = new ProgressObjectImpl(ids);
        boolean failed = false;
        StringBuilder message = new StringBuilder();
        for (TargetModuleID targetModuleID : ids) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, L.l("jsr88 stopping {0}", (Object)targetModuleID.getModuleID()));
            }
            Exception exception = null;
            DeployControllerMXBean mxbean = null;
            try {
                ObjectName objectName = new ObjectName(targetModuleID.getModuleID());
                mxbean = (DeployControllerMXBean)Jmx.find(objectName);
                if (mxbean != null) {
                    mxbean.stop();
                } else {
                    log.finer("Jsr88[] " + objectName + " is an unknown module");
                    failed = true;
                }
            }
            catch (Exception t) {
                log.log(Level.INFO, t.toString(), t);
                exception = t;
            }
            if (exception != null) {
                failed = true;
                this.describe(message, targetModuleID, false, this.getExceptionMessage(exception));
                continue;
            }
            this.describe(message, targetModuleID, true);
        }
        if (failed) {
            progress.failed(L.l("stop {0}", (Object)message));
        } else {
            progress.completed(L.l("stop {0}", (Object)message));
        }
        return progress;
    }

    public ProgressObject undeploy(TargetModuleID[] ids) throws IllegalStateException {
        ProgressObjectImpl progress = new ProgressObjectImpl(ids);
        boolean failed = false;
        StringBuilder message = new StringBuilder();
        for (TargetModuleID targetModuleID : ids) {
            if (log.isLoggable(Level.FINE)) {
                log.log(Level.FINE, L.l("undeploying {0}", (Object)targetModuleID.getModuleID()));
            }
            ArchiveDeployMXBean mxbean = null;
            Throwable exception = null;
            try {
                ObjectName objectName = new ObjectName(targetModuleID.getModuleID());
                mxbean = this.getMXBean(objectName);
                if (mxbean != null) {
                    mxbean.undeploy(objectName.getKeyProperty("name"));
                }
            }
            catch (Throwable t) {
                log.log(Level.INFO, t.toString(), t);
                exception = t;
            }
            if (exception != null) {
                failed = true;
                this.describe(message, targetModuleID, false, this.getExceptionMessage(exception));
                continue;
            }
            this.describe(message, targetModuleID, true);
        }
        if (failed) {
            progress.failed(L.l("undeploy {0}", (Object)message));
        } else {
            progress.completed(L.l("undeploy {0}", (Object)message));
        }
        return progress;
    }

    private void describe(StringBuilder builder, TargetModuleID targetModuleID, boolean success) {
        this.describe(builder, targetModuleID, success, null);
    }

    private void describe(StringBuilder builder, TargetModuleID targetModuleID, boolean success, String message) {
        if (builder.length() > 0) {
            builder.append(", ");
        }
        if (success) {
            builder.append(L.l("successful for target {0} module {1}", (Object)targetModuleID.getTarget().getName(), (Object)targetModuleID.getModuleID()));
        } else {
            builder.append(L.l("failed for target {0} module {1}", (Object)targetModuleID.getTarget().getName(), (Object)targetModuleID.getModuleID()));
        }
        if (message != null) {
            builder.append(" '");
            builder.append(message);
            builder.append("'");
        }
    }
}

