/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.java;

import com.caucho.java.AbstractJavaCompiler;
import com.caucho.java.JavaCompiler;
import com.caucho.java.LineMap;
import com.caucho.log.Log;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.IOExceptionWrapper;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Logger;

public class GroovyCompiler
extends AbstractJavaCompiler {
    protected static final Logger log = Log.open(GroovyCompiler.class);
    private static final String GROOVY_COMPILER = "org.codehaus.groovy.tools.FileSystemCompiler";
    private static Class _groovyCompilerClass;
    private static Method _setOutputDir;
    private static Method _setClasspath;
    private static Method _compile;
    String _userPrefix;

    public GroovyCompiler(JavaCompiler compiler) {
        super(compiler);
    }

    protected void compileInt(String[] paths, LineMap lineMap) throws IOException {
        Object compiler;
        Thread thread = Thread.currentThread();
        ClassLoader loader = thread.getContextClassLoader();
        if (_groovyCompilerClass == null) {
            try {
                _groovyCompilerClass = Class.forName(GROOVY_COMPILER, false, loader);
                _setClasspath = _groovyCompilerClass.getMethod("setClasspath", String.class);
                _setOutputDir = _groovyCompilerClass.getMethod("setOutputDir", String.class);
                _compile = _groovyCompilerClass.getMethod("compile", String[].class);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        try {
            compiler = _groovyCompilerClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        try {
            String sourceExt = this._compiler.getSourceExtension();
            String path = paths[0];
            int tail = path.length() - sourceExt.length();
            String className = path.substring(0, tail);
            Path classFile = this._compiler.getClassDir().lookup(className + ".class");
            String cp = this.normalizeClassPath(this._compiler.getClassPath(), false);
            _setClasspath.invoke(compiler, cp);
            String dest = this.normalizePath(this._compiler.getClassDirName(), false);
            _setOutputDir.invoke(compiler, dest);
            ArrayList<String> argList = new ArrayList<String>();
            for (int i = 0; i < paths.length; ++i) {
                Path javaPath = this._compiler.getSourceDir().lookup(paths[i]);
                argList.add(javaPath.getNativePath());
            }
            String[] files = new String[argList.size()];
            argList.toArray(files);
            _compile.invoke(compiler, new Object[]{files});
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new IOExceptionWrapper((Throwable)e);
        }
    }

    String normalizeClassPath(String classPath, boolean generateRelative) {
        char sep = CauchoSystem.getPathSeparatorChar();
        int head = 0;
        int tail = 0;
        CharBuffer cb = CharBuffer.allocate();
        while (head < classPath.length()) {
            tail = classPath.indexOf(sep, head);
            if (tail < 0) {
                tail = classPath.length();
            }
            if (tail > head) {
                String segment = classPath.substring(head, tail);
                if (cb.length() != 0) {
                    cb.append(sep);
                }
                cb.append(this.normalizePath(segment, generateRelative));
            }
            head = tail + 1;
        }
        return cb.close();
    }

    String normalizePath(String segment, boolean generateRelative) {
        if (this._userPrefix == null) {
            Path userPath = Vfs.lookup(CauchoSystem.getUserDir());
            char sep = CauchoSystem.getFileSeparatorChar();
            this._userPrefix = userPath.getNativePath();
            if (this._userPrefix.length() == 0 || this._userPrefix.charAt(this._userPrefix.length() - 1) != sep) {
                this._userPrefix = this._userPrefix + sep;
            }
        }
        Path path = Vfs.lookup(segment);
        String nativePath = path.getNativePath();
        if (!generateRelative) {
            return nativePath;
        }
        if (nativePath.startsWith(this._userPrefix)) {
            nativePath = nativePath.substring(this._userPrefix.length());
        }
        if (nativePath.equals("")) {
            return ".";
        }
        return nativePath;
    }

    public static class CompilerThread
    implements Runnable {
        private volatile boolean _isDone;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            CompilerThread compilerThread;
            try {
                Object var2_1 = null;
                this._isDone = true;
                compilerThread = this;
            }
            catch (Throwable throwable) {
                Object var2_2 = null;
                this._isDone = true;
                CompilerThread compilerThread2 = this;
                synchronized (compilerThread2) {
                    this.notifyAll();
                }
                throw throwable;
            }
            synchronized (compilerThread) {
                this.notifyAll();
            }
        }
    }
}

