/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.java;

import com.caucho.java.AbstractJavaCompiler;
import com.caucho.java.JavaCompileException;
import com.caucho.java.JavaCompiler;
import com.caucho.java.JavacErrorParser;
import com.caucho.java.LineMap;
import com.caucho.loader.ClassLoaderContext;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.Encoding;
import com.caucho.vfs.IOExceptionWrapper;
import com.caucho.vfs.MemoryStream;
import com.caucho.vfs.Path;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.Vfs;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class InternalCompiler
extends AbstractJavaCompiler {
    private static final Logger log = Logger.getLogger(InternalCompiler.class.getName());
    private static boolean _hasCompiler;
    Process _process;
    String _userPrefix;
    boolean _isDead;

    public InternalCompiler(JavaCompiler compiler) {
        super(compiler);
    }

    protected void compileInt(String[] path, LineMap lineMap) throws IOException, JavaCompileException {
        if (!_hasCompiler) {
            Object exn = null;
            try {
                ClassLoader loader = ClassLoader.getSystemClassLoader();
                Class.forName("com.sun.tools.javac.Main", false, loader);
                _hasCompiler = true;
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                DynamicClassLoader env = new DynamicClassLoader(ClassLoader.getSystemClassLoader());
                Path javaHome = Vfs.lookup(System.getProperty("java.home"));
                Path jar = javaHome.lookup("./lib/tools.jar");
                env.addJar(jar);
                jar = javaHome.lookup("../lib/tools.jar");
                env.addJar(jar);
                Class.forName("com.sun.tools.javac.Main", false, env);
                _hasCompiler = true;
            }
            catch (ClassNotFoundException e) {
                throw new JavaCompileException(L.l("Resin can't load com.sun.tools.javac.Main.  Usually this means that the JDK tools.jar is missing from the classpath, possibly because of using a JRE instead of the JDK.  You can either add tools.jar to the classpath or change the compiler to an external one with <java compiler='javac'/> or jikes.\n\n{0}", (Object)String.valueOf(e)), e);
            }
        }
        this.executeInt(path, lineMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeInt(String[] path, LineMap lineMap) throws JavaCompileException, IOException {
        MemoryStream tempStream = new MemoryStream();
        WriteStream error = new WriteStream((StreamImpl)tempStream);
        try {
            String encoding;
            ArrayList<String> argList = new ArrayList<String>();
            argList.add("-d");
            argList.add(this._compiler.getClassDirName());
            if (this._compiler.getEncoding() != null && (encoding = Encoding.getJavaName((String)this._compiler.getEncoding())) != null && !encoding.equals("ISO8859_1")) {
                argList.add("-encoding");
                argList.add(this._compiler.getEncoding());
            }
            argList.add("-classpath");
            argList.add(this._compiler.getClassPath());
            ArrayList<String> args = this._compiler.getArgs();
            if (args != null) {
                argList.addAll(args);
            }
            for (int i = 0; i < path.length; ++i) {
                Path javaPath = this._compiler.getSourceDir().lookup(path[i]);
                argList.add(javaPath.getNativePath());
            }
            if (log.isLoggable(Level.FINER)) {
                CharBuffer msg = new CharBuffer();
                msg.append("javac(int)");
                for (int i = 0; i < argList.size(); ++i) {
                    if (((String)argList.get(i)).equals("-classpath") && !log.isLoggable(Level.FINEST)) {
                        ++i;
                        continue;
                    }
                    msg.append(" ");
                    msg.append((String)argList.get(i));
                }
                log.finer(msg.toString());
            }
            String[] argArray = argList.toArray(new String[argList.size()]);
            int status = -1;
            Thread thread = Thread.currentThread();
            ClassLoader oldLoader = thread.getContextClassLoader();
            DynamicClassLoader env = new DynamicClassLoader(ClassLoader.getSystemClassLoader());
            Path javaHome = Vfs.lookup(System.getProperty("java.home"));
            Path jar = javaHome.lookup("./lib/tools.jar");
            env.addJar(jar);
            jar = javaHome.lookup("../lib/tools.jar");
            env.addJar(jar);
            try {
                thread.setContextClassLoader(env);
                try {
                    Class<?> cl = Class.forName("com.sun.tools.javac.Main", false, env);
                    Object compiler = cl.newInstance();
                    Method compile = null;
                    Object value = null;
                    try {
                        compile = cl.getMethod("compile", String[].class, PrintWriter.class);
                        value = compile.invoke(compiler, argArray, error.getPrintWriter());
                    }
                    catch (Throwable e) {
                        log.log(Level.FINER, e.toString(), e);
                    }
                    if (compile == null) {
                        compile = cl.getMethod("compile", String[].class);
                        value = compile.invoke(compiler, new Object[]{argArray});
                    }
                    if (value instanceof Integer) {
                        status = (Integer)value;
                    }
                }
                catch (ClassNotFoundException e) {
                    e.printStackTrace();
                    throw new JavaCompileException(L.l("Can't find internal Java compiler.  Either configure an external compiler with <javac> or use a JDK which contains a Java compiler."), e);
                }
                catch (NoSuchMethodException e) {
                    throw new JavaCompileException(e);
                }
                catch (InstantiationException e) {
                    throw new JavaCompileException(e);
                }
                catch (IllegalAccessException e) {
                    throw new JavaCompileException(e);
                }
                catch (InvocationTargetException e) {
                    throw new IOExceptionWrapper((Throwable)e);
                }
                error.close();
                tempStream.close();
                Object var20_29 = null;
                thread.setContextClassLoader(oldLoader);
            }
            catch (Throwable throwable) {
                Object var20_30 = null;
                thread.setContextClassLoader(oldLoader);
                throw throwable;
            }
            ReadStream read = tempStream.openReadAndSaveBuffer();
            JavacErrorParser parser = new JavacErrorParser(this._compiler.getEncoding());
            String errors = parser.parseErrors((InputStream)read, lineMap);
            read.close();
            if (errors != null) {
                errors = errors.trim();
            }
            if (log.isLoggable(Level.FINE)) {
                int ch;
                read = tempStream.openReadAndSaveBuffer();
                CharBuffer cb = new CharBuffer();
                while ((ch = read.read()) >= 0) {
                    cb.append((char)ch);
                }
                read.close();
                log.fine(cb.toString());
            } else if (status == 0 && errors != null && !errors.equals("")) {
                final String msg = errors;
                new ClassLoaderContext(this._compiler.getClassLoader()){

                    public void run() {
                        log.warning(msg);
                    }
                };
            }
            if (status != 0) {
                throw new JavaCompileException(errors);
            }
            Object var22_32 = null;
        }
        catch (Throwable throwable) {
            Object var22_33 = null;
            tempStream.destroy();
            throw throwable;
        }
        tempStream.destroy();
    }
}

