/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.java;

import com.caucho.bytecode.JClass;
import com.caucho.java.LineMap;
import com.caucho.java.LineMapWriter;
import com.caucho.vfs.Path;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.io.Writer;

public class JavaWriter
extends Writer {
    private WriteStream _os;
    private int _indentDepth;
    private boolean _startLine = true;
    private LineMap _lineMap;
    private int _destLine = 1;
    private boolean _lastCr;
    private int _uniqueId;

    public JavaWriter(WriteStream os) {
        this._os = os;
    }

    public WriteStream getWriteStream() {
        return this._os;
    }

    public int getDestLine() {
        return this._destLine;
    }

    public void setLineMap(LineMap lineMap) {
        this._lineMap = lineMap;
    }

    public LineMap getLineMap() {
        return this._lineMap;
    }

    public void setLocation(String filename, int line) throws IOException {
        if (this._lineMap != null && filename != null && line >= 0) {
            this._lineMap.add(filename, line, this._destLine);
        }
    }

    public int generateId() {
        return this._uniqueId++;
    }

    public void printJavaString(String s) throws IOException {
        block6: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\\': {
                    this._os.print("\\\\");
                    continue block6;
                }
                case '\n': {
                    this._os.print("\\n");
                    continue block6;
                }
                case '\r': {
                    this._os.print("\\r");
                    continue block6;
                }
                case '\"': {
                    this._os.print("\\\"");
                    continue block6;
                }
                default: {
                    this._os.print(ch);
                }
            }
        }
    }

    public void printJavaChar(char ch) throws IOException {
        switch (ch) {
            case '\\': {
                this._os.print("\\\\");
                break;
            }
            case '\n': {
                this._os.print("\\n");
                break;
            }
            case '\r': {
                this._os.print("\\r");
                break;
            }
            case '\'': {
                this._os.print("\\'");
                break;
            }
            default: {
                this._os.print(ch);
            }
        }
    }

    public static String escapeJavaString(String s) {
        StringBuilder sb = new StringBuilder();
        block6: for (int i = 0; i < s.length(); ++i) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\\': {
                    sb.append("\\\\");
                    continue block6;
                }
                case '\n': {
                    sb.append("\\n");
                    continue block6;
                }
                case '\r': {
                    sb.append("\\r");
                    continue block6;
                }
                case '\"': {
                    sb.append("\\\"");
                    continue block6;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    public void pushDepth() throws IOException {
        this._indentDepth += 2;
    }

    public void popDepth() throws IOException {
        this._indentDepth -= 2;
    }

    public void print(String s) throws IOException {
        if (this._startLine) {
            this.printIndent();
        }
        if (s == null) {
            this._lastCr = false;
            this._os.print("null");
            return;
        }
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char ch = s.charAt(i);
            if (ch == '\n' && !this._lastCr) {
                ++this._destLine;
            } else if (ch == '\r') {
                ++this._destLine;
            }
            this._lastCr = ch == '\r';
            this._os.print(ch);
        }
    }

    public void write(char[] buffer, int offset, int length) throws IOException {
        this.print(new String(buffer, offset, length));
    }

    public void print(char ch) throws IOException {
        if (this._startLine) {
            this.printIndent();
        }
        if (ch == '\r') {
            ++this._destLine;
        } else if (ch == '\n' && !this._lastCr) {
            ++this._destLine;
        }
        this._lastCr = ch == '\r';
        this._os.print(ch);
    }

    public void print(boolean b) throws IOException {
        if (this._startLine) {
            this.printIndent();
        }
        this._os.print(b);
        this._lastCr = false;
    }

    public void print(int i) throws IOException {
        if (this._startLine) {
            this.printIndent();
        }
        this._os.print(i);
        this._lastCr = false;
    }

    public void print(long l) throws IOException {
        if (this._startLine) {
            this.printIndent();
        }
        this._os.print(l);
        this._lastCr = false;
    }

    public void print(Object o) throws IOException {
        if (this._startLine) {
            this.printIndent();
        }
        this._os.print(o);
        this._lastCr = false;
    }

    public void println(String s) throws IOException {
        this.print(s);
        this.println();
    }

    public void println(boolean v) throws IOException {
        this.print(v);
        this.println();
    }

    public void println(char ch) throws IOException {
        this.print(ch);
        this.println();
    }

    public void println(int v) throws IOException {
        this.print(v);
        this.println();
    }

    public void println(long v) throws IOException {
        this.print(v);
        this.println();
    }

    public void println(Object v) throws IOException {
        this.print(v);
        this.println();
    }

    public void println() throws IOException {
        this._os.println();
        if (!this._lastCr) {
            ++this._destLine;
        }
        this._lastCr = false;
        this._startLine = true;
    }

    public void printClass(Class cl) throws IOException {
        if (!cl.isArray()) {
            this.print(cl.getName().replace('$', '.'));
        } else {
            this.printClass(cl.getComponentType());
            this.print("[]");
        }
    }

    public void printJavaTypeToObject(String value, Class javaType) throws IOException {
        if (Object.class.isAssignableFrom(javaType)) {
            this.print(value);
        } else if (javaType.equals(Boolean.TYPE)) {
            this.print("new Boolean(" + value + ")");
        } else if (javaType.equals(Byte.TYPE)) {
            this.print("new Byte(" + value + ")");
        } else if (javaType.equals(Short.TYPE)) {
            this.print("new Short(" + value + ")");
        } else if (javaType.equals(Integer.TYPE)) {
            this.print("new Integer(" + value + ")");
        } else if (javaType.equals(Long.TYPE)) {
            this.print("new Long(" + value + ")");
        } else if (javaType.equals(Character.TYPE)) {
            this.print("String.valueOf(" + value + ")");
        } else if (javaType.equals(Float.TYPE)) {
            this.print("new Float(" + value + ")");
        } else if (javaType.equals(Double.TYPE)) {
            this.print("new Double(" + value + ")");
        } else {
            this.print(value);
        }
    }

    public void printJavaTypeToObject(String value, JClass javaType) throws IOException {
        if (javaType.getName().equals("boolean")) {
            this.print("new Boolean(" + value + ")");
        } else if (javaType.getName().equals("byte")) {
            this.print("new Byte(" + value + ")");
        } else if (javaType.getName().equals("short")) {
            this.print("new Short(" + value + ")");
        } else if (javaType.getName().equals("int")) {
            this.print("new Integer(" + value + ")");
        } else if (javaType.getName().equals("long")) {
            this.print("new Long(" + value + ")");
        } else if (javaType.getName().equals("char")) {
            this.print("String.valueOf(" + value + ")");
        } else if (javaType.getName().equals("float")) {
            this.print("new Float(" + value + ")");
        } else if (javaType.getName().equals("double")) {
            this.print("new Double(" + value + ")");
        } else {
            this.print(value);
        }
    }

    public void printIndent() throws IOException {
        this._startLine = false;
        for (int i = 0; i < this._indentDepth; ++i) {
            this._os.print(' ');
        }
        this._lastCr = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateSmap() throws IOException {
        if (this._lineMap != null) {
            Path dstPath = this.getWriteStream().getPath();
            Path smap = dstPath.getParent().lookup(dstPath.getTail() + ".smap");
            WriteStream out = smap.openWrite();
            try {
                String srcName = this._lineMap.getLastSourceFilename();
                LineMapWriter writer = new LineMapWriter(out);
                if (this._lineMap.getSourceType() != null) {
                    writer.setSourceType(this._lineMap.getSourceType());
                }
                writer.write(this._lineMap);
            }
            finally {
                out.close();
            }
        }
    }

    public String errorMessage(String message) {
        return message;
    }

    public void flush() {
    }

    public void close() {
    }
}

