/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.java.gen;

import com.caucho.java.JavaWriter;
import com.caucho.java.gen.ClassComponent;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.L10N;
import com.caucho.vfs.Depend;
import com.caucho.vfs.Path;
import com.caucho.vfs.PersistentDependency;
import com.caucho.vfs.Vfs;
import java.io.IOException;
import java.util.ArrayList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DependencyComponent
extends ClassComponent {
    private static final L10N L = new L10N(DependencyComponent.class);
    private String _initMethod = "_caucho_init";
    private String _isModifiedMethod = "_caucho_is_modified";
    private Path _searchPath;
    private ArrayList<PersistentDependency> _dependList = new ArrayList();

    public void setSearchPath(Path searchPath) {
        this._searchPath = searchPath;
    }

    public void addDependencyList(ArrayList<PersistentDependency> dependList) {
        for (int i = 0; i < dependList.size(); ++i) {
            this.addDependency(dependList.get(i));
        }
    }

    public void addDependency(PersistentDependency depend) {
        if (!this._dependList.contains(depend)) {
            this._dependList.add(depend);
        }
    }

    @Override
    public void generate(JavaWriter out) throws IOException {
        out.println("private static com.caucho.vfs.Dependency []_caucho_depend;");
        out.println();
        out.println("public static void " + this._initMethod + "(com.caucho.vfs.Path path)");
        out.println("{");
        out.pushDepth();
        out.println("_caucho_depend = new com.caucho.vfs.Dependency[" + this._dependList.size() + "];");
        Path searchPath = this._searchPath;
        for (int i = 0; i < this._dependList.size(); ++i) {
            PersistentDependency dependency = this._dependList.get(i);
            if (dependency instanceof Depend) {
                String pwd;
                String fullPath;
                Depend depend = (Depend)this._dependList.get(i);
                Path path = depend.getPath();
                out.print("_caucho_depend[" + i + "] = new com.caucho.vfs.Depend(");
                String relativePath = searchPath != null ? searchPath.lookup(path.getRelativePath()).getRelativePath() : ((fullPath = path.getFullPath()).startsWith(pwd = Vfs.lookup().getFullPath()) ? "./" + fullPath.substring(pwd.length()) : fullPath);
                out.print("path.lookup(\"" + relativePath + "\"), ");
                out.println(depend.getDigest() + "L, " + depend.getRequireSource() + ");");
                continue;
            }
            out.print("_caucho_depend[" + i + "] = ");
            out.print(dependency.getJavaCreateString());
            out.println(";");
        }
        out.popDepth();
        out.println("}");
        out.println();
        out.println("public static boolean " + this._isModifiedMethod + "()");
        out.println("{");
        out.pushDepth();
        this.printVersionChange(out);
        out.println("for (int i = _caucho_depend.length - 1; i >= 0; i--) {");
        out.println("  if (_caucho_depend[i].isModified())");
        out.println("    return true;");
        out.println("}");
        out.println();
        out.println("return false;");
        out.popDepth();
        out.println("}");
    }

    protected void printVersionChange(JavaWriter out) throws IOException {
        out.println("if (com.caucho.server.util.CauchoSystem.getVersionId() != 0x" + Long.toHexString(CauchoSystem.getVersionId()) + "L)");
        out.println("  return true;");
    }
}

