/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jca;

import com.caucho.config.ConfigException;
import com.caucho.config.types.Period;
import com.caucho.jca.IdlePoolSet;
import com.caucho.jca.PoolItem;
import com.caucho.jca.UserPoolItem;
import com.caucho.jca.UserTransactionImpl;
import com.caucho.jca.UserTransactionProxy;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.loader.EnvironmentLocal;
import com.caucho.management.server.AbstractManagedObject;
import com.caucho.management.server.ConnectionPoolMXBean;
import com.caucho.sql.ManagedConnectionImpl;
import com.caucho.util.Alarm;
import com.caucho.util.AlarmListener;
import com.caucho.util.L10N;
import com.caucho.util.WeakAlarm;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Date;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.resource.NotSupportedException;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnection;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ValidatingManagedConnectionFactory;
import javax.security.auth.Subject;
import javax.transaction.xa.XAResource;
import javax.transaction.xa.Xid;

public class ConnectionPool
extends AbstractManagedObject
implements ConnectionManager,
AlarmListener,
ConnectionPoolMXBean {
    private static final L10N L = new L10N(ConnectionPool.class);
    private static final Logger log = Logger.getLogger(ConnectionPool.class.getName());
    private static EnvironmentLocal<Integer> _idGen = new EnvironmentLocal();
    private String _name;
    private UserTransactionProxy _tm;
    private int _maxConnections = 128;
    private int _maxOverflowConnections = 0;
    private int _maxCreateConnections = 5;
    private int _maxIdleCount = 1024;
    private long _maxIdleTime = 30000L;
    private long _maxActiveTime = 21600000L;
    private long _maxPoolTime = 86400000L;
    private long _connectionWaitTime = 600000L;
    private long _connectionWaitCount = this._connectionWaitTime / 1000L;
    private boolean _enableLocalTransaction = true;
    private boolean _enableXA = true;
    private boolean _isLocalTransactionOptimization = true;
    private boolean _isShareable = true;
    private boolean _saveAllocationStackTrace = false;
    private boolean _isCloseDanglingConnections = true;
    private final ArrayList<PoolItem> _pool = new ArrayList();
    private IdlePoolSet _idlePool;
    private final ArrayList<PoolItem> _alarmConnections = new ArrayList();
    private Alarm _alarm;
    private long _lastValidCheckTime;
    private long _lastIdlePoolEmptyTime;
    private int _idCount;
    private int _createCount;
    private long _connectionCountTotal;
    private long _connectionCreateCountTotal;
    private long _connectionFailCountTotal;
    private long _lastFailTime;
    private final Lifecycle _lifecycle = new Lifecycle();

    ConnectionPool() {
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    public void setTransactionManager(UserTransactionProxy tm) {
        this._tm = tm;
    }

    public UserTransactionProxy getTransactionManager() {
        return this._tm;
    }

    public boolean isShareable() {
        return this._isShareable;
    }

    public void setShareable(boolean isShareable) {
        this._isShareable = isShareable;
    }

    public boolean isLocalTransactionOptimization() {
        return this._isLocalTransactionOptimization;
    }

    public void setLocalTransactionOptimization(boolean enable) {
        this._isLocalTransactionOptimization = enable;
    }

    public boolean allowLocalTransactionOptimization() {
        return this._isLocalTransactionOptimization && this._isShareable;
    }

    public boolean getSaveAllocationStackTrace() {
        return this._saveAllocationStackTrace;
    }

    public void setSaveAllocationStackTrace(boolean save) {
        this._saveAllocationStackTrace = save;
    }

    public boolean isCloseDanglingConnections() {
        return this._isCloseDanglingConnections;
    }

    public void setCloseDanglingConnections(boolean isClose) {
        this._isCloseDanglingConnections = isClose;
    }

    public void setLocalTransaction(boolean localTransaction) {
        this._enableLocalTransaction = localTransaction;
    }

    public boolean isLocalTransaction() {
        return this._enableLocalTransaction;
    }

    public void setXATransaction(boolean enable) {
        this._enableXA = enable;
    }

    public boolean isXATransaction() {
        return this._enableXA;
    }

    public long getMaxIdleTime() {
        if (0x3FFFFFFFFFFFFFFFL <= this._maxIdleTime) {
            return -1L;
        }
        return this._maxIdleTime;
    }

    public void setMaxIdleTime(long maxIdleTime) {
        this._maxIdleTime = maxIdleTime < 0L ? 0x3FFFFFFFFFFFFFFFL : maxIdleTime;
    }

    public int getMaxIdleCount() {
        return this._maxIdleCount;
    }

    public void setMaxIdleCount(int maxIdleCount) {
        this._maxIdleCount = maxIdleCount < 0 ? 0 : maxIdleCount;
    }

    public long getMaxActiveTime() {
        if (0x3FFFFFFFFFFFFFFFL <= this._maxActiveTime) {
            return -1L;
        }
        return this._maxActiveTime;
    }

    public void setMaxActiveTime(long maxActiveTime) {
        this._maxActiveTime = maxActiveTime < 0L ? 0x3FFFFFFFFFFFFFFFL : maxActiveTime;
    }

    public long getMaxPoolTime() {
        if (0x3FFFFFFFFFFFFFFFL <= this._maxPoolTime) {
            return -1L;
        }
        return this._maxPoolTime;
    }

    public void setMaxPoolTime(long maxPoolTime) {
        this._maxPoolTime = maxPoolTime < 0L ? 0x3FFFFFFFFFFFFFFFL : maxPoolTime;
    }

    public void setMaxConnections(int maxConnections) throws ConfigException {
        if (maxConnections == 0) {
            throw new ConfigException(L.l("max-connections '0' must be at least 1."));
        }
        this._maxConnections = maxConnections;
        if (maxConnections < 0) {
            this._maxConnections = 0x3FFFFFFF;
        }
    }

    public int getMaxConnections() {
        if (this._maxConnections < 0x3FFFFFFF) {
            return this._maxConnections;
        }
        return -1;
    }

    public void setConnectionWaitTime(Period waitTime) {
        this._connectionWaitTime = waitTime.getPeriod();
        if (this._connectionWaitTime < 0L) {
            this._connectionWaitTime = 0x3FFFFFFFFFFFFFFFL;
        }
        this._connectionWaitCount = this._connectionWaitTime / 1000L;
    }

    public long getConnectionWaitTime() {
        if (this._connectionWaitTime < 0x3FFFFFFFFFFFFFFFL) {
            return this._connectionWaitTime;
        }
        return -1L;
    }

    public void setMaxOverflowConnections(int maxOverflowConnections) {
        this._maxOverflowConnections = maxOverflowConnections;
    }

    public int getMaxOverflowConnections() {
        return this._maxOverflowConnections;
    }

    public void setMaxCreateConnections(int maxConnections) throws ConfigException {
        if (maxConnections == 0) {
            throw new ConfigException(L.l("max-create-connections '0' must be at least 1."));
        }
        this._maxCreateConnections = maxConnections;
        if (maxConnections < 0) {
            this._maxCreateConnections = 0x3FFFFFFF;
        }
    }

    public int getMaxCreateConnections() {
        if (this._maxCreateConnections < 0x3FFFFFFF) {
            return this._maxCreateConnections;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object init(ManagedConnectionFactory mcf) throws ConfigException, ResourceException {
        if (!this._lifecycle.toInit()) {
            return null;
        }
        if (this._name == null) {
            EnvironmentLocal<Integer> environmentLocal = _idGen;
            synchronized (environmentLocal) {
                Integer v = _idGen.get();
                v = v == null ? Integer.valueOf(1) : Integer.valueOf(v + 1);
                _idGen.set(v);
                this._name = mcf.getClass().getSimpleName() + "-" + v;
            }
        }
        if (this._tm == null) {
            throw new ConfigException(L.l("the connection manager needs a transaction manager."));
        }
        this._idlePool = new IdlePoolSet(this._maxIdleCount);
        this.registerSelf();
        this._alarm = new WeakAlarm((AlarmListener)this);
        if (!(mcf instanceof ValidatingManagedConnectionFactory)) {
            this._lastValidCheckTime = 0x3FFFFFFFFFFFFFFFL;
        }
        if (!this._enableXA) return mcf.createConnectionFactory((ConnectionManager)this);
        Subject subject = null;
        ManagedConnection mConn = mcf.createManagedConnection(subject, null);
        try {
            try {
                XAResource xa = mConn.getXAResource();
                this._tm.recover(xa);
            }
            catch (NotSupportedException e) {
                log.finer(e.toString());
                Object var6_8 = null;
                mConn.destroy();
                return mcf.createConnectionFactory((ConnectionManager)this);
            }
            catch (Throwable e) {
                log.log(Level.FINER, e.toString(), e);
                Object var6_9 = null;
                mConn.destroy();
                return mcf.createConnectionFactory((ConnectionManager)this);
            }
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_10 = null;
            mConn.destroy();
            throw throwable;
        }
        mConn.destroy();
        return mcf.createConnectionFactory((ConnectionManager)this);
    }

    public void start() {
        if (!this._lifecycle.toActive()) {
            return;
        }
        if (0L < this._maxIdleTime && this._maxIdleTime < 1000L) {
            this._alarm.queue(1000L);
        } else if (1000L < this._maxIdleTime && this._maxIdleTime < 60000L) {
            this._alarm.queue(this._maxIdleTime);
        } else {
            this._alarm.queue(60000L);
        }
    }

    String generateId() {
        return String.valueOf(this._idCount++);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object allocateConnection(ManagedConnectionFactory mcf, ConnectionRequestInfo info) throws ResourceException {
        Subject subject = null;
        Object conn = this.allocate(mcf, subject, info);
        ConnectionPool connectionPool = this;
        synchronized (connectionPool) {
            ++this._connectionCountTotal;
        }
        return conn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void toIdle(PoolItem item) {
        block17: {
            ManagedConnection mConn;
            if (this._pool.size() <= this._maxConnections && !item.isConnectionError() && (mConn = item.getManagedConnection()) != null) {
                block16: {
                    ArrayList<PoolItem> arrayList;
                    block15: {
                        try {
                            try {
                                mConn.cleanup();
                                Object oldIdleConn = null;
                                IdlePoolSet idlePoolSet = this._idlePool;
                                synchronized (idlePoolSet) {
                                    long now = Alarm.getCurrentTime();
                                    if (this._idlePool.size() == 0) {
                                        this._lastIdlePoolEmptyTime = now;
                                    }
                                    if (now - this._lastIdlePoolEmptyTime < this._maxIdleTime && this._idlePool.add(mConn)) {
                                        // MONITOREXIT @DISABLED, blocks:[0, 1, 5, 13, 14] lbl12 : MonitorExitStatement: MONITOREXIT : var4_5
                                        Object var9_7 = null;
                                        arrayList = this._pool;
                                        break block15;
                                    }
                                    this._lastIdlePoolEmptyTime = now;
                                    break block16;
                                }
                            }
                            catch (Throwable e) {
                                log.log(Level.FINE, e.toString(), e);
                                Object var9_9 = null;
                                ArrayList<PoolItem> arrayList2 = this._pool;
                                synchronized (arrayList2) {
                                    this._pool.notifyAll();
                                    break block17;
                                }
                            }
                        }
                        catch (Throwable throwable) {
                            Object var9_10 = null;
                            ArrayList<PoolItem> arrayList3 = this._pool;
                            synchronized (arrayList3) {
                                this._pool.notifyAll();
                                throw throwable;
                            }
                        }
                    }
                    synchronized (arrayList) {
                        this._pool.notifyAll();
                        return;
                    }
                }
                Object var9_8 = null;
                ArrayList<PoolItem> arrayList = this._pool;
                synchronized (arrayList) {
                    this._pool.notifyAll();
                }
            }
        }
        this.toDead(item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PoolItem getDelegatePoolItem(Xid xid) {
        ArrayList<PoolItem> pool;
        ArrayList<PoolItem> arrayList = pool = this._pool;
        synchronized (arrayList) {
            int size = pool.size();
            for (int i = 0; i < size; ++i) {
                PoolItem item = pool.get(i);
                if (!xid.equals(item.getXid())) continue;
                return item;
            }
        }
        return null;
    }

    public int getConnectionCount() {
        return this._pool.size();
    }

    public int getConnectionIdleCount() {
        return this._idlePool.size();
    }

    public int getConnectionActiveCount() {
        return this._pool.size() - this._idlePool.size();
    }

    public long getConnectionCountTotal() {
        return this._connectionCountTotal;
    }

    public long getConnectionCreateCountTotal() {
        return this._connectionCreateCountTotal;
    }

    public long getConnectionFailCountTotal() {
        return this._connectionFailCountTotal;
    }

    public Date getLastFailTime() {
        return new Date(this._lastFailTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        ArrayList<PoolItem> pool = this._pool;
        if (pool == null) {
            return;
        }
        ArrayList<PoolItem> clearItems = new ArrayList<PoolItem>();
        AbstractCollection abstractCollection = this._idlePool;
        synchronized (abstractCollection) {
            this._idlePool.clear();
        }
        abstractCollection = pool;
        synchronized (abstractCollection) {
            clearItems.addAll(pool);
            pool.clear();
        }
        for (int i = 0; i < clearItems.size(); ++i) {
            PoolItem poolItem = (PoolItem)clearItems.get(i);
            try {
                poolItem.destroy();
                continue;
            }
            catch (Throwable e) {
                log.log(Level.WARNING, e.toString(), e);
            }
        }
    }

    UserTransactionImpl getTransaction() {
        return this._tm.getUserTransaction();
    }

    private Object allocate(ManagedConnectionFactory mcf, Subject subject, ConnectionRequestInfo info) throws ResourceException {
        UserPoolItem userPoolItem = null;
        try {
            UserTransactionImpl transaction = this._tm.getUserTransaction();
            if (transaction == null) {
                return this.allocatePool(mcf, subject, info, null).allocateUserConnection();
            }
            userPoolItem = transaction.allocate(mcf, subject, info);
            if (userPoolItem == null) {
                userPoolItem = this.allocatePool(mcf, subject, info, null);
            }
            return userPoolItem.allocateUserConnection();
        }
        catch (RuntimeException e) {
            if (userPoolItem != null) {
                userPoolItem.close();
            }
            throw e;
        }
        catch (ResourceException e) {
            if (userPoolItem != null) {
                userPoolItem.close();
            }
            throw e;
        }
        catch (Throwable e) {
            if (userPoolItem != null) {
                userPoolItem.close();
            }
            throw new ResourceException(e);
        }
    }

    UserPoolItem allocatePool(ManagedConnectionFactory mcf, Subject subject, ConnectionRequestInfo info, UserPoolItem oldUserItem) throws ResourceException {
        UserPoolItem userPoolItem;
        long timeoutCount = this._connectionWaitCount;
        long expireTime = Alarm.getCurrentTimeActual() + this._connectionWaitTime;
        while (this._lifecycle.isActive()) {
            userPoolItem = this.allocateIdle(mcf, subject, info, oldUserItem);
            if (userPoolItem != null) {
                return userPoolItem;
            }
            userPoolItem = this.create(mcf, subject, info, false, oldUserItem);
            if (userPoolItem != null) {
                return userPoolItem;
            }
            long now = Alarm.getCurrentTimeActual();
            if (expireTime >= now) continue;
            break;
        }
        if (!this._lifecycle.isActive()) {
            throw new IllegalStateException(L.l("connection pool closed"));
        }
        userPoolItem = this.create(mcf, subject, info, true, oldUserItem);
        if (userPoolItem == null) {
            throw new NullPointerException(L.l("ConnectionPool create should not return a null PoolItem for overflow connections."));
        }
        return userPoolItem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserPoolItem allocateIdle(ManagedConnectionFactory mcf, Subject subject, ConnectionRequestInfo info, UserPoolItem oldUserItem) throws ResourceException {
        while (this._lifecycle.isActive()) {
            ManagedConnection mConn;
            IdlePoolSet vmcf;
            long now = Alarm.getCurrentTime();
            if (this._lastValidCheckTime + 1000L < now) {
                this._lastValidCheckTime = now;
                if (mcf instanceof ValidatingManagedConnectionFactory) {
                    vmcf = (ValidatingManagedConnectionFactory)mcf;
                    this.validate((ValidatingManagedConnectionFactory)vmcf);
                }
            }
            vmcf = this._idlePool;
            synchronized (vmcf) {
                mConn = mcf.matchManagedConnections((Set)this._idlePool, subject, info);
                if (mConn == null) {
                    return null;
                }
                this._idlePool.remove(mConn);
            }
            PoolItem poolItem = null;
            ArrayList<PoolItem> arrayList = this._pool;
            synchronized (arrayList) {
                for (int i = this._pool.size() - 1; i >= 0 && (poolItem = this._pool.get(i)).getManagedConnection() != mConn; --i) {
                }
            }
            if (poolItem == null) {
                throw new IllegalStateException(L.l("No matching PoolItem found for {0}", (Object)mConn));
            }
            UserPoolItem userPoolItem = null;
            userPoolItem = poolItem.toActive(subject, info, oldUserItem);
            if (userPoolItem != null) {
                return userPoolItem;
            }
            this.toDead(poolItem);
        }
        return null;
    }

    private void validate(ValidatingManagedConnectionFactory mcf) {
        Object invalid = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UserPoolItem create(ManagedConnectionFactory mcf, Subject subject, ConnectionRequestInfo info, boolean isOverflow, UserPoolItem oldUserItem) throws ResourceException {
        PoolItem poolItem;
        block30: {
            ArrayList<PoolItem> arrayList = this._pool;
            synchronized (arrayList) {
                int size = this._pool.size();
                if (isOverflow && this._maxConnections + this._maxOverflowConnections <= this._createCount + size) {
                    throw new ResourceException(L.l("Connection pool is full.  Can't allocate connection."));
                }
                if (!(isOverflow || this._maxConnections > this._createCount + size && this._maxCreateConnections > this._createCount)) {
                    try {
                        Thread.interrupted();
                        this._pool.wait(1000L);
                    }
                    catch (Exception e) {
                        log.log(Level.FINE, e.toString(), e);
                    }
                    return null;
                }
                ++this._createCount;
            }
            poolItem = null;
            ManagedConnection mConn = mcf.createManagedConnection(subject, info);
            if (mConn == null) {
                throw new ResourceException(L.l("'{0}' did not return a connection from createManagedConnection", (Object)mcf));
            }
            poolItem = new PoolItem(this, mcf, mConn);
            UserPoolItem userPoolItem = poolItem.toActive(subject, info, oldUserItem);
            if (userPoolItem == null) break block30;
            Object object = this;
            synchronized (object) {
                ++this._connectionCreateCountTotal;
            }
            object = userPoolItem;
            Object var14_16 = null;
            ArrayList<PoolItem> arrayList2 = this._pool;
            synchronized (arrayList2) {
                --this._createCount;
                if (poolItem != null) {
                    this._pool.add(poolItem);
                }
                this._pool.notifyAll();
            }
            return object;
        }
        try {
            ConnectionPool connectionPool;
            try {
                throw new IllegalStateException(L.l("Connection '{0}' was not valid on creation", (Object)poolItem));
            }
            catch (RuntimeException e) {
                connectionPool = this;
                synchronized (connectionPool) {
                    ++this._connectionFailCountTotal;
                    this._lastFailTime = Alarm.getCurrentTime();
                }
                throw e;
            }
            catch (ResourceException e) {
                connectionPool = this;
                synchronized (connectionPool) {
                    ++this._connectionFailCountTotal;
                    this._lastFailTime = Alarm.getCurrentTime();
                }
                throw e;
            }
        }
        catch (Throwable throwable) {
            Object var14_17 = null;
            ArrayList<PoolItem> arrayList = this._pool;
            synchronized (arrayList) {
                --this._createCount;
                if (poolItem != null) {
                    this._pool.add(poolItem);
                }
                this._pool.notifyAll();
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void handleAlarm(Alarm alarm) {
        block12: {
            if (!this._lifecycle.isActive()) {
                return;
            }
            try {
                long now = Alarm.getCurrentTime();
                this._alarmConnections.clear();
                ArrayList<PoolItem> arrayList = this._pool;
                synchronized (arrayList) {
                    this._alarmConnections.addAll(this._pool);
                }
                for (int i = this._alarmConnections.size() - 1; i >= 0; --i) {
                    PoolItem item = this._alarmConnections.get(i);
                    if (item.isValid()) continue;
                    this.toDead(item);
                }
                this._alarmConnections.clear();
                Object var7_7 = null;
                if (!this._lifecycle.isActive()) return;
                if (0L >= this._maxIdleTime || this._maxIdleTime >= 1000L) break block12;
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                if (!this._lifecycle.isActive()) throw throwable;
                if (0L < this._maxIdleTime && this._maxIdleTime < 1000L) {
                    this._alarm.queue(1000L);
                    throw throwable;
                } else if (1000L < this._maxIdleTime && this._maxIdleTime < 60000L) {
                    this._alarm.queue(this._maxIdleTime);
                    throw throwable;
                } else {
                    this._alarm.queue(60000L);
                }
                throw throwable;
            }
            this._alarm.queue(1000L);
            return;
        }
        if (1000L < this._maxIdleTime && this._maxIdleTime < 60000L) {
            this._alarm.queue(this._maxIdleTime);
            return;
        }
        this._alarm.queue(60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void toDead(PoolItem item) {
        AbstractCollection abstractCollection = this._idlePool;
        synchronized (abstractCollection) {
            this._idlePool.remove(item.getManagedConnection());
        }
        abstractCollection = this._pool;
        synchronized (abstractCollection) {
            this._pool.remove(item);
            this._pool.notifyAll();
        }
        try {
            item.destroy();
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public void markForPoolRemoval(ManagedConnectionImpl mConn) {
        for (PoolItem poolItem : this._pool) {
            if (poolItem.getManagedConnection() != mConn) continue;
            poolItem.setConnectionError();
            break;
        }
    }

    public void stop() {
        if (!this._lifecycle.toStop()) {
            return;
        }
        if (this._alarm != null) {
            this._alarm.dequeue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        ArrayList<PoolItem> pool;
        this.stop();
        if (!this._lifecycle.toDestroy()) {
            return;
        }
        ArrayList<PoolItem> arrayList = pool = this._pool;
        synchronized (arrayList) {
            for (int i = 0; i < pool.size(); ++i) {
                PoolItem poolItem = pool.get(i);
                try {
                    poolItem.destroy();
                    continue;
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
            pool.clear();
            this._idlePool.clear();
        }
    }

    public String toString() {
        return "ConnectionPool[" + this.getName() + "]";
    }
}

