/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jca;

import com.caucho.jca.ResourceArchive;
import com.caucho.jca.ResourceManagerImpl;
import com.caucho.lifecycle.Lifecycle;
import com.caucho.lifecycle.StartLifecycleException;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.util.L10N;
import java.util.logging.Logger;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ResourceAdapter;
import javax.webbeans.ComponentFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ResourceAdapterController
implements EnvironmentListener {
    private static final L10N L = new L10N(ResourceAdapterController.class);
    private static final Logger log = Logger.getLogger(ResourceAdapterController.class.getName());
    private final ComponentFactory<ResourceAdapter> _comp;
    private final ResourceArchive _raConfig;
    private Lifecycle _lifecycle = new Lifecycle();
    private ResourceAdapter _ra;

    public ResourceAdapterController(ComponentFactory<ResourceAdapter> comp, ResourceArchive raConfig) {
        this._comp = comp;
        this._raConfig = raConfig;
        Environment.addEnvironmentListener(this);
    }

    public ResourceAdapter getResourceAdapter() {
        this.start();
        return this._ra;
    }

    private void start() {
        if (!this._lifecycle.toActive()) {
            return;
        }
        this._ra = (ResourceAdapter)this._comp.get();
        try {
            this._ra.start((BootstrapContext)ResourceManagerImpl.create());
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new StartLifecycleException(e);
        }
    }

    private void stop() {
        if (!this._lifecycle.toStop()) {
            return;
        }
        try {
            ResourceAdapter ra = this._ra;
            if (ra != null) {
                ra.stop();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new StartLifecycleException(e);
        }
    }

    @Override
    public void environmentBind(EnvironmentClassLoader loader) throws StartLifecycleException {
    }

    @Override
    public void environmentStart(EnvironmentClassLoader loader) throws StartLifecycleException {
        this.start();
    }

    @Override
    public void environmentStop(EnvironmentClassLoader loader) {
        this.stop();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._comp + "]";
    }
}

