/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jca.cfg;

import com.caucho.config.ConfigException;
import com.caucho.config.types.BeanConfig;
import com.caucho.config.types.Period;
import com.caucho.jca.ConnectionPool;
import com.caucho.jca.ResourceAdapterController;
import com.caucho.jca.ResourceArchive;
import com.caucho.jca.ResourceArchiveManager;
import com.caucho.jca.ResourceManagerImpl;
import com.caucho.naming.Jndi;
import com.caucho.util.L10N;
import com.caucho.webbeans.Names;
import com.caucho.webbeans.component.ComponentImpl;
import com.caucho.webbeans.manager.WebBeansContainer;
import java.lang.annotation.Annotation;
import java.util.logging.Logger;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterAssociation;
import javax.webbeans.ComponentFactory;

public class ConnectionFactoryConfig
extends BeanConfig {
    private static final Logger log = Logger.getLogger(ConnectionFactoryConfig.class.getName());
    private static L10N L = new L10N(ConnectionFactoryConfig.class);
    private ResourceAdapter _ra;
    private int _maxConnections = 1024;
    private long _maxActiveTime = Integer.MAX_VALUE;

    public ConnectionFactoryConfig() {
        this.setBeanConfigClass(ManagedConnectionFactory.class);
    }

    protected String getDefaultScope() {
        return null;
    }

    public void setResourceAdapter(ResourceAdapter ra) {
        this._ra = ra;
    }

    public void setMaxConnections(int max) {
        this._maxConnections = max;
    }

    public void setMaxActiveTime(Period period) {
        this._maxActiveTime = period.getPeriod();
    }

    public void init() {
        super.init();
        ComponentImpl comp = this.getComponent();
        ManagedConnectionFactory managedFactory = (ManagedConnectionFactory)comp.get();
        if (managedFactory instanceof ResourceAdapterAssociation) {
            Class<?> cl = managedFactory.getClass();
            ResourceAdapter ra = this.findResourceAdapter(cl);
            ResourceAdapterAssociation factoryAssoc = (ResourceAdapterAssociation)managedFactory;
            try {
                factoryAssoc.setResourceAdapter(ra);
            }
            catch (Exception e) {
                throw ConfigException.create((Throwable)e);
            }
        }
        ResourceManagerImpl rm = ResourceManagerImpl.create();
        ConnectionPool cm = rm.createConnectionPool();
        if (this.getName() != null) {
            cm.setName(this.getName());
        }
        cm.setMaxConnections(this._maxConnections);
        cm.setMaxActiveTime(this._maxActiveTime);
        ResourceArchive rar = null;
        if (rar != null) {
            String trans = rar.getTransactionSupport();
            if (trans == null) {
                cm.setXATransaction(true);
                cm.setLocalTransaction(true);
            } else if (trans.equals("XATransaction")) {
                cm.setXATransaction(true);
                cm.setLocalTransaction(true);
            } else if (trans.equals("NoTransaction")) {
                cm.setXATransaction(false);
                cm.setLocalTransaction(false);
            } else if (trans.equals("LocalTransaction")) {
                cm.setXATransaction(false);
                cm.setLocalTransaction(true);
            }
        }
        try {
            Object connectionFactory = cm.init(managedFactory);
            cm.start();
            WebBeansContainer webBeans = WebBeansContainer.create();
            if (this.getName() != null) {
                Jndi.bindDeepShort(this.getName(), connectionFactory);
                webBeans.addSingleton(connectionFactory, this.getName());
            } else {
                webBeans.addSingleton(connectionFactory);
            }
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    private ResourceAdapter findResourceAdapter(Class cl) {
        if (this._ra != null) {
            return this._ra;
        }
        ResourceArchive ra = ResourceArchiveManager.findResourceArchive(cl.getName());
        if (ra == null) {
            throw new ConfigException(L.l("'{0}' does not have a defined resource-adapter.  Either define it in a &lt;resource-adapter> property or check the rar or META-INF/resin-ra.xml files", (Object)cl.getName()));
        }
        WebBeansContainer webBeans = WebBeansContainer.create();
        ComponentFactory<ResourceAdapterController> raComp = webBeans.resolveByType(ResourceAdapterController.class, new Annotation[]{Names.create(ra.getResourceAdapterClass().getName())});
        if (raComp == null) {
            throw new ConfigException(L.l("'{0}' does not have a configured resource-adapter for '{1}'.", (Object)ra.getResourceAdapterClass().getName(), (Object)cl.getName()));
        }
        ResourceAdapterController raController = (ResourceAdapterController)raComp.get();
        return raController.getResourceAdapter();
    }

    public void deploy() {
    }
}

