/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.jca.cfg;

import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import com.caucho.webbeans.cfg.AbstractBeanConfig;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;
import javax.annotation.PostConstruct;
import javax.mail.Authenticator;
import javax.mail.Session;

public class JavaMailConfig
extends AbstractBeanConfig {
    private static final L10N L = new L10N(JavaMailConfig.class);
    private static final Logger log = Logger.getLogger(JavaMailConfig.class.getName());
    private Properties _props = new Properties();
    private Authenticator _auth;
    private Session _session;

    public void setAuthenticator(Authenticator auth) {
        this._auth = auth;
    }

    public void setFrom(String from) {
        this.setProperty("mail.from", from);
    }

    public void setHost(String host) {
        this.setProperty("mail.host", host);
    }

    public void setImapHost(String host) {
        this.setProperty("mail.imap.host", host);
    }

    public void setImapUser(String user) {
        this.setProperty("mail.imap.user", user);
    }

    public void setPop3Host(String host) {
        this.setProperty("mail.pop3.host", host);
    }

    public void setPop3User(String user) {
        this.setProperty("mail.pop3.user", user);
    }

    public void setSmtpHost(String host) {
        this.setProperty("mail.smtp.host", host);
    }

    public void setSmtpSsl(boolean ssl) {
        this.setProperty("mail.smtp.ssl", String.valueOf(ssl));
    }

    public void setSmtpPort(int port) {
        this.setProperty("mail.smtp.port", String.valueOf(port));
    }

    public void setSmtpUser(String user) {
        this.setProperty("mail.smtp.user", user);
    }

    public void setStoreProtocol(String protocol) {
        this.setProperty("mail.store.protocol", protocol);
    }

    public void setTransportProtocol(String protocol) {
        this.setProperty("mail.transport.protocol", protocol);
    }

    public void setUser(String user) {
        this.setProperty("mail.user", user);
    }

    public void setProperty(String name, String value) {
        this._props.put(name, value);
    }

    public void setProperties(Properties props) {
        this._props.putAll((Map<?, ?>)props);
    }

    public void setValue(Properties props) {
        this._props.putAll((Map<?, ?>)props);
    }

    @PostConstruct
    public void init() throws ConfigException {
        try {
            if (this.getInit() != null) {
                this.getInit().configure(this);
            }
            this._session = this._auth != null ? Session.getInstance((Properties)this._props, (Authenticator)this._auth) : Session.getInstance((Properties)this._props);
            this.register(this._session);
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    public Object replaceObject() {
        return this._session;
    }
}

